/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.processdesigner.states;

import oracle.bpm.designer.action.NewTransitionOperation;
import oracle.bpm.designer.controller.ActivityController;
import oracle.bpm.designer.controller.Controller;
import oracle.bpm.designer.controller.NodeContainerController;
import oracle.bpm.designer.controller.SequenceFlowController;
import oracle.bpm.designer.processdesigner.states.AbstractAddObjectState;
import oracle.bpm.geom.Point;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.TransitionType;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.event.MouseEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddingTransitionState
extends AbstractAddObjectState {
    private SequenceFlowController sequenceFlowController;
    private SequenceFlow transition;

    public AddingTransitionState(@NotNull NodeContainerController<?> container, @Nullable FlowNode from, @Nullable FlowNode to, @NotNull TransitionType type) {
        this.transition = container.getModelObject().createSequenceFlow();
        if (type.isConditional()) {
            this.transition.toConditionalFlow();
        }
        if (from != null) {
            this.transition.setSource(from);
        }
        if (to != null) {
            this.transition.setTarget(to);
        }
        this.sequenceFlowController = (SequenceFlowController)container.createDisposableControllerFor((FlowElement)this.transition);
    }

    @Override
    public void mouseRealeased(MouseEvent event, Point unscaled) {
        Controller<?> currentObject = this.findAnyController(unscaled);
        if (this.transition.getSource() == null) {
            ActivityController currentActivity;
            if (currentObject instanceof ActivityController && ModelUtils.shouldHaveOutgoingSequenceFlow((FlowNode)((FlowNode)(currentActivity = (ActivityController)currentObject).getModelObject()))) {
                this.transition.setSource((FlowNode)currentActivity.getModelObject());
            }
        } else if (currentObject.getModelObject() instanceof FlowNode) {
            FlowNode a = (FlowNode)currentObject.getModelObject();
            this.transition.setTarget(a);
            try {
                new NewTransitionOperation(this.transition).run();
            }
            catch (ProjectException e) {
                MessageDialog.showError((Throwable)e);
            }
        }
    }
}

