/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.processdesigner.states;

import oracle.bpm.command.Command;
import oracle.bpm.designer.ActionRunner;
import oracle.bpm.designer.capability.CapabilityEvent;
import oracle.bpm.designer.capability.CapabilityHelper;
import oracle.bpm.designer.capability.CapabilityType;
import oracle.bpm.designer.capability.SpecifiedResult;
import oracle.bpm.designer.controller.Controller;
import oracle.bpm.designer.processdesigner.states.AbstractDesignerState;
import oracle.bpm.geom.Point;
import oracle.bpm.ui.event.MouseEvent;
import org.jetbrains.annotations.NotNull;

public class AddingState
extends AbstractDesignerState {
    protected SpecifiedResult adding;
    protected final Controller controller;
    private final CapabilityType type;

    public AddingState(@NotNull CapabilityType type, @NotNull Controller controller) {
        this.type = type;
        this.controller = controller;
    }

    @Override
    public void mouseDragged(MouseEvent event, Point unscaled) {
        this.mouseMoved(event, event.getX(), event.getY(), unscaled);
    }

    @Override
    public void mouseMoved(MouseEvent mouse, int x, int y, Point unscaled) {
        if (this.adding == null) {
            this.startAdd(mouse, unscaled);
        } else {
            this.updateAdd(mouse, unscaled);
        }
    }

    @Override
    public void mouseRealeased(@NotNull MouseEvent mouse, @NotNull Point unscaled) {
        if (this.adding != null) {
            this.stopAdd(mouse, unscaled);
        } else {
            this.cancel();
        }
    }

    @Override
    public void cancel() {
        if (this.adding != null) {
            CapabilityEvent event = CapabilityEvent.create(this.adding, Point.ORIGIN);
            this.adding.getCapability().cancelAnyVisuals(event);
            this.adding = null;
        }
        super.cancel();
    }

    private void startAdd(@NotNull MouseEvent mouse, @NotNull Point unscaled) {
        Controller<?> controller = this.findAnyController(unscaled);
        SpecifiedResult result = CapabilityHelper.specify(controller, this.type);
        if (result != null) {
            this.adding = result;
            this.adding.setAdding(this.controller);
            CapabilityEvent event = CapabilityEvent.create(this.adding, unscaled, mouse);
            this.adding.getCapability().showTargetVisuals(event);
        }
    }

    private void updateAdd(@NotNull MouseEvent mouse, @NotNull Point unscaled) {
        SpecifiedResult result;
        Controller<?> controller = this.findAnyController(unscaled);
        if (!this.adding.getOwner().equals(controller) && (result = CapabilityHelper.specify(controller, this.type)) != null && !this.adding.getOwner().equals(result.getOwner())) {
            CapabilityEvent remove = CapabilityEvent.create(this.adding, unscaled, mouse);
            this.adding.getCapability().eraseTargetVisuals(remove);
            this.adding = result;
            this.adding.setAdding(this.controller);
        }
        CapabilityEvent event = CapabilityEvent.create(this.adding, unscaled, mouse);
        event.setTarget(controller);
        this.adding.getCapability().showTargetVisuals(event);
    }

    private void stopAdd(@NotNull MouseEvent mouse, @NotNull Point unscaled) {
        Controller<?> controller = this.findAnyController(unscaled);
        CapabilityEvent event = CapabilityEvent.create(this.adding, unscaled, mouse);
        event.setTarget(controller);
        this.adding.getCapability().eraseTargetVisuals(event);
        this.processCommand(this.adding, event);
        this.adding = null;
        this.getDomain().getCanvas().repaint();
    }

    private void processCommand(@NotNull SpecifiedResult result, @NotNull CapabilityEvent event) {
        Command command = result.getCapability().process(event);
        if (command != null) {
            ActionRunner.getInstance().run(command);
            result.getCapability().consolidate(event);
        } else {
            this.finished();
        }
    }
}

