/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.processdesigner.states;

import oracle.bpm.designer.capability.CapabilityEvent;
import oracle.bpm.designer.capability.CapabilityType;
import oracle.bpm.designer.capability.add.ContainerAddingSequenceFlowCapability;
import oracle.bpm.designer.controller.ConnectionControllerImpl;
import oracle.bpm.designer.controller.Controller;
import oracle.bpm.designer.controller.NodeContainerController;
import oracle.bpm.designer.processdesigner.states.AddingState;
import oracle.bpm.draw.DesignerLayer;
import oracle.bpm.draw.Drawable;
import oracle.bpm.draw.DrawableConnection;
import oracle.bpm.draw.DrawableConnectionImpl;
import oracle.bpm.geom.Point;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.TransitionType;
import oracle.bpm.ui.event.MouseEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddingSequenceFlowState
extends AddingState {
    private AddingSequenceFlowState(@NotNull ControllerConnectionFeedback controller) {
        super(CapabilityType.ADD_CONNECTION, controller);
    }

    public static AddingSequenceFlowState create(@NotNull NodeContainerController<?> container, @Nullable FlowNode from, @NotNull TransitionType type) {
        SequenceFlow flow = container.getModelObject().createSequenceFlow();
        if (type.isConditional()) {
            flow.toConditionalFlow();
        }
        DrawableConnectionFeedback drawable = new DrawableConnectionFeedback((Drawable)container.getDrawableObject(), flow);
        if (from != null) {
            drawable.setDrawableSource(container.getDomain().getDrawContext(), (Drawable)container.getDrawableObject().asDrawable((FlowElement)from));
        }
        ControllerConnectionFeedback controller = new ControllerConnectionFeedback(container, drawable);
        return new AddingSequenceFlowState(controller);
    }

    @Override
    public void mouseRealeased(@NotNull MouseEvent mouse, @NotNull Point unscaled) {
        if (this.adding != null && !this.isSourceDefined()) {
            this.keepAdding(mouse, unscaled);
        } else {
            super.mouseRealeased(mouse, unscaled);
        }
    }

    private boolean isSourceDefined() {
        DrawableConnection connection = this.getDrawableConnectionFeedback();
        return connection.getDrawableSource() != null;
    }

    private DrawableConnection getDrawableConnectionFeedback() {
        ControllerConnectionFeedback controller = (ControllerConnectionFeedback)this.adding.getAdding();
        return controller.getDrawableObject();
    }

    private void keepAdding(@NotNull MouseEvent mouse, @NotNull Point unscaled) {
        Controller<?> controller = this.findAnyController(unscaled);
        CapabilityEvent event = CapabilityEvent.create(this.adding, unscaled, mouse);
        event.setTarget(controller);
        if (this.adding.getCapability() instanceof ContainerAddingSequenceFlowCapability) {
            ContainerAddingSequenceFlowCapability capability = (ContainerAddingSequenceFlowCapability)this.adding.getCapability();
            capability.updateSource(event);
        }
        super.mouseMoved(mouse, mouse.getX(), mouse.getY(), unscaled);
    }

    public static class DrawableConnectionFeedback
    extends DrawableConnectionImpl<Object> {
        public DrawableConnectionFeedback(@NotNull Drawable container, @NotNull SequenceFlow connection) {
            super(container, (Object)connection, DesignerLayer.CAPABILITY);
        }
    }

    public static class ControllerConnectionFeedback
    extends ConnectionControllerImpl<Object> {
        protected ControllerConnectionFeedback(Controller container, @NotNull DrawableConnectionFeedback drawable) {
            super(container, drawable);
        }

        @NotNull
        public DrawableConnectionFeedback getDrawableObject() {
            return (DrawableConnectionFeedback)super.getDrawableObject();
        }
    }
}

