/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.processdesigner.states;

import oracle.bpm.designer.AddNoteAction;
import oracle.bpm.designer.ProcessDomain;
import oracle.bpm.designer.controller.NoteController;
import oracle.bpm.designer.processdesigner.states.AbstractAddObjectState;
import oracle.bpm.geom.Point;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.TextAnnotation;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Cursor;
import oracle.bpm.ui.event.MouseEvent;

public class AddingNoteState
extends AbstractAddObjectState {
    public NoteController noteController;
    private TextAnnotation note;

    public AddingNoteState(TextAnnotation newNote) {
        this.note = newNote;
    }

    @Override
    public void mouseRealeased(MouseEvent event, Point unscaled) {
        this.performAddAction(new AddNoteAction(this.note, unscaled.getX(), unscaled.getY()));
        this.getNoteController().editProperties();
    }

    @Override
    public void mouseEntered() {
        this.manager.getDomain().getCanvas().requestFocus();
    }

    @Override
    public void cancel() {
        super.cancel();
    }

    @Override
    public void mouseExited() {
        this.manager.getDomain().getCanvas().requestFocus();
    }

    @Override
    public void mouseMoved(MouseEvent event, int x, int y, Point unscaled) {
        this.getDomain().getCanvas().setCursor(Cursor.get((Cursor.CursorType)Cursor.CursorType.TEXT_CURSOR));
        this.manager.getDomain().getCanvas().setToolTipText((Msg)null);
    }

    private NoteController getNoteController() {
        if (this.noteController == null) {
            this.noteController = (NoteController)((ProcessDomain)this.getDomain()).getCanvas().getProcessController().createDisposableControllerFor((FlowElement)this.note);
        }
        return this.noteController;
    }
}

