/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.processdesigner.states;

import oracle.bpm.collections.PredicateUtils;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.Domain;
import oracle.bpm.designer.DomainStateManager;
import oracle.bpm.designer.ProcessDomain;
import oracle.bpm.designer.controller.Controller;
import oracle.bpm.designer.selection.DomainSelectionProvider;
import oracle.bpm.designer.selection.SelectionUtils;
import oracle.bpm.geom.Point;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.selection.DefaultSelection;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.ui.selection.SelectionProvider;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDesignerState {
    protected DomainStateManager manager;
    private boolean addingObject;
    private Domain domain;

    public AbstractDesignerState() {
        this(false);
    }

    public AbstractDesignerState(boolean isAddingObject) {
        this.addingObject = isAddingObject;
    }

    public DomainStateManager getDesignerController() {
        return this.manager;
    }

    public void mousePressed(MouseEvent event, Point unscaled) {
    }

    public void mouseRealeased(MouseEvent event, Point unscaled) {
    }

    public void mouseMoved(MouseEvent event, int x, int y, Point unscaled) {
    }

    public void mouseEntered() {
    }

    public void mouseExited() {
    }

    public void cancel() {
        this.finished();
    }

    public void finished() {
        this.stateFinished();
    }

    public boolean isAddingObject() {
        return this.addingObject;
    }

    public void mouseDragged(MouseEvent event, Point unscaled) {
    }

    public void mouseClicked() {
    }

    public void mouseDoubleClicked(MouseEvent event, Point unscaled) {
    }

    public void controlPressed() {
    }

    public void shiftPressed() {
    }

    public void shiftReleased() {
    }

    public void controlReleased() {
    }

    public void enteredPressed() {
    }

    public void escapePressed() {
        this.cancel();
    }

    public void deletePressed() {
    }

    public void setStateManager(@NotNull DomainStateManager manager) {
        this.manager = manager;
    }

    public final Domain getDomain() {
        if (this.domain == null && this.manager != null) {
            this.domain = this.manager.getDomain();
        }
        return this.domain;
    }

    public final boolean isShiftPressed() {
        return this.getDesignerController().isShiftPressed();
    }

    public final boolean isControlPressed() {
        return this.getDesignerController().isControlPressed();
    }

    public void init() {
    }

    public void copyPressed() {
    }

    protected void stateFinished() {
        this.getDomain().getSelectionProvider().clear();
        this.getDomain().getStateManager().setDefaultState();
    }

    @NotNull
    protected Controller<?> findAnyController(@NotNull Point unscaled) {
        Controller<?> result = this.getDomain().findController(PredicateUtils.<Controller>truePredicate(), unscaled.getX(), unscaled.getY(), PredicateUtils.<Controller>truePredicate());
        if (result == null) {
            throw new IllegalStateException("Controller not found at any level!");
        }
        return result;
    }

    protected DomainSelectionProvider getSelectionProvider() {
        return this.getDomain().getSelectionProvider();
    }

    protected void processSelectionChanged() {
        Selection selectedObjects = this.getSelectionProvider().getSelection();
        Object selection = !selectedObjects.isEmpty() ? SelectionUtils.asModelObjectSelection(selectedObjects) : DefaultSelection.createSingle((Object)((ProcessDomain)this.getDomain()).getDomainElement());
        this.notifySelectionToWorkbench((Selection)selection);
    }

    private void notifySelectionToWorkbench(Selection selection) {
        SelectionProvider selectionProvider = AbstractStudioWorkbench.getInstance().getEditorAreaSelectionProvider();
        if (selectionProvider.getSelection() != selection) {
            selectionProvider.setSelection(selection);
        }
    }
}

