/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.processdesigner;

import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import oracle.bpm.designer.Domain;
import oracle.bpm.designer.DomainStateManager;
import oracle.bpm.designer.ProcessDomain;
import oracle.bpm.designer.ZoomInAction;
import oracle.bpm.designer.ZoomOutAction;
import oracle.bpm.geom.Point;
import oracle.bpm.ui.MouseEventUtilities;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.event.MouseListener;
import oracle.bpm.ui.event.MouseMotionListener;
import org.jetbrains.annotations.NotNull;

public class DomainMouseManager
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private Domain domain;
    private DomainStateManager manager;

    public DomainMouseManager(@NotNull DomainStateManager manager) {
        this.manager = manager;
        this.domain = manager.getDomain();
    }

    public void mouseDragged(MouseEvent event) {
        if (!MouseEventUtilities.isPopupTrigger((MouseEvent)event) && !event.isButton3Down()) {
            Point unscaled = this.domain.getDrawContext().unscalePoint(event.getX(), event.getY());
            this.manager.getCurrentState().mouseDragged(event, unscaled);
            this.manager.checkAutoScrolling(event.getX(), event.getY());
        }
    }

    public void mouseMoved(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        Point unscaled = this.domain.getDrawContext().unscalePoint(x, y);
        this.manager.getCurrentState().mouseMoved(e, x, y, unscaled);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.isControlDown()) {
            if (e.getWheelRotation() > 0) {
                new ZoomOutAction((ProcessDomain)this.manager.getDomain()).run();
            } else {
                new ZoomInAction((ProcessDomain)this.manager.getDomain()).run();
            }
            e.consume();
        } else {
            this.domain.getCanvas().notifyMouseWheelEvent(e);
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseDoubleClicked(MouseEvent e) {
        Point unscaled = this.domain.getDrawContext().unscalePoint(e.getX(), e.getY());
        this.manager.getCurrentState().mouseDoubleClicked(e, unscaled);
    }

    public void mouseEntered(MouseEvent e) {
        this.manager.getCurrentState().mouseEntered();
    }

    public void mouseExited(MouseEvent e) {
        this.manager.getCurrentState().mouseExited();
    }

    public void mousePressed(MouseEvent e) {
        this.domain.getCanvas().requestFocus();
        Point unscaled = this.domain.getDrawContext().unscalePoint(e.getX(), e.getY());
        this.manager.getCurrentState().mousePressed(e, unscaled);
    }

    public void mouseReleased(MouseEvent e) {
        if (!MouseEventUtilities.isPopupTrigger((MouseEvent)e)) {
            Point unscaled = this.domain.getDrawContext().unscaleAndInvert(e.getX(), e.getY());
            this.manager.getCurrentState().mouseRealeased(e, unscaled);
        }
    }
}

