/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.processdesigner;

import oracle.bpm.designer.DomainStateManager;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.project.model.processes.Grid;
import oracle.bpm.ui.event.KeyEvent;
import oracle.bpm.ui.event.KeyListener;
import oracle.bpm.util.SystemInfo;
import org.jetbrains.annotations.NotNull;

public class DomainKeyboardManager {
    private KeyListener keyListener;
    private final DomainStateManager manager;
    private static final boolean STUDIO_DEBUG_MODE = System.getProperty("fuego.studio.debug") != null;

    public DomainKeyboardManager(@NotNull DomainStateManager manager) {
        this.manager = manager;
        this.keyListener = this.initializeKeyListener();
    }

    public KeyListener getKeyListener() {
        return this.keyListener;
    }

    public void escapePressed() {
        this.manager.getCurrentState().escapePressed();
    }

    public void shiftPressed() {
        this.manager.setShiftPressed(true);
    }

    public void shiftReleased() {
        this.manager.setShiftPressed(false);
    }

    private KeyListener initializeKeyListener() {
        return new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.isEscape()) {
                    DomainKeyboardManager.this.escapePressed();
                } else if (e.isDelete()) {
                    DomainKeyboardManager.this.deletePressed();
                    e.consume();
                } else if (e.isEnter()) {
                    DomainKeyboardManager.this.enterPressed();
                } else if (e.isControl()) {
                    if (!SystemInfo.isAnyMac()) {
                        DomainKeyboardManager.this.controlPressed();
                    }
                } else if (e.isMeta()) {
                    if (SystemInfo.isAnyMac()) {
                        DomainKeyboardManager.this.controlPressed();
                    }
                } else if (e.isShift()) {
                    DomainKeyboardManager.this.shiftPressed();
                } else if (e.getKeyChar() == 'c') {
                    if (e.isControlDown()) {
                        DomainKeyboardManager.this.copyPressed();
                    }
                } else if (e.getKeyChar() == '+') {
                    System.out.println("DomainKeyboardManager.keyPressed :'+': INCREASE GRID");
                    DomainKeyboardManager.this.increaseGridSize();
                } else if (e.getKeyChar() == '-') {
                    System.out.println("DomainKeyboardManager.keyPressed :'-': DECREASE GRID");
                    DomainKeyboardManager.this.decreaseGridSize();
                } else if (e.getKeyChar() == 'g') {
                    System.out.println("DomainKeyboardManager.keyPressed :'g': GRID TOOGLED");
                    DomainKeyboardManager.this.toogleShowGrid();
                } else if (STUDIO_DEBUG_MODE) {
                    if (e.getKeyChar() == 'd') {
                        System.out.println("DomainKeyboardManager.keyPressed :'d': DRAWABLE DEBUG TOOGLED");
                        DomainKeyboardManager.this.toogleDebugEnabled();
                    } else if (e.getKeyChar() == 'r') {
                        System.out.println("DomainKeyboardManager.keyPressed :'r': DRAWABLE REDRAW REGIONS TOOGLED");
                        DomainKeyboardManager.this.toogleShowRedrawRegions();
                    } else if (e.getKeyChar() == 'e') {
                        System.out.println("DomainKeyboardManager.keyPressed :'e': DRAWABLE BOUNDS TOOGLED");
                        DomainKeyboardManager.this.toogleShowDrawableBounds();
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
                if (e.isControl()) {
                    DomainKeyboardManager.this.controlReleased();
                }
                if (e.isShift()) {
                    DomainKeyboardManager.this.shiftReleased();
                }
            }

            public void keyTyped(KeyEvent e) {
            }
        };
    }

    private void increaseGridSize() {
        Grid grid = this.manager.getDomain().getGrid();
        grid.increaseSize();
        this.storeGridPrefSize(grid);
    }

    private void decreaseGridSize() {
        Grid grid = this.manager.getDomain().getGrid();
        grid.decreaseSize();
        this.storeGridPrefSize(grid);
    }

    private void storeGridPrefSize(Grid grid) {
        DesignerPreferences preferences = DesignerPreferences.getPreferences();
        preferences.setGridSize((Integer)grid.getSize().get());
        System.out.println("DomainKeyboardManager.storeGridPrefSize");
        System.out.println("preferences.getGridSize() = " + preferences.getGridSize().get());
        preferences.store();
    }

    private void toogleShowGrid() {
        DrawContext context = this.manager.getDomain().getDrawContext();
        boolean visible = !context.getShowGrid();
        context.setShowGrid(visible);
        System.out.println("DomainKeyboardManager.toogleShowGrid");
        System.out.println("visible = " + visible);
    }

    private void toogleShowRedrawRegions() {
        this.manager.getDomain().getDrawContext().toogleDrawableRedrawRegions();
    }

    private void toogleDebugEnabled() {
        this.manager.getDomain().getDrawContext().toogleDrawableDebug();
    }

    private void toogleShowDrawableBounds() {
        this.manager.getDomain().getDrawContext().toogleDrawableBounds();
    }

    private void copyPressed() {
        this.manager.getCurrentState().copyPressed();
    }

    private void controlPressed() {
        this.manager.getCurrentState().controlPressed();
    }

    private void enterPressed() {
        this.manager.getCurrentState().enteredPressed();
    }

    private void controlReleased() {
        this.manager.getCurrentState().controlReleased();
    }

    private void deletePressed() {
        this.manager.getCurrentState().deletePressed();
    }
}

