/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.process.wizard;

import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.process.wizard.FinalStep;
import oracle.bpm.designer.process.wizard.InitialStep;
import oracle.bpm.project.model.FolderContainer;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.Transactable;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.wizards.model.Wizard;
import oracle.bpm.ui.wizards.model.WizardStep;
import org.jetbrains.annotations.NotNull;

public class NewBPMProcessWizard
extends Wizard {
    private FolderContainer container;
    private boolean defaultTemplate = true;
    private Process process;
    private Project project;
    private int selectedTemplateIndex = 0;

    public NewBPMProcessWizard(@NotNull Project project) {
        this(project, project.getModelsRoot());
    }

    public NewBPMProcessWizard(@NotNull Project project, @NotNull FolderContainer folder) {
        this.project = project;
        this.container = folder;
        this.getSteps().add(new FinalStep(this));
        this.setMsg(DesignerMsg.CREATE_PROCESS);
    }

    public boolean isDefaultTemplate() {
        return this.defaultTemplate;
    }

    public int getSelectedTemplateIndex() {
        return this.selectedTemplateIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doFinish() {
        try {
            Sequence sequence = this.process.getLanes();
            Organization organization = this.project.getOrganization();
            for (Lane lane : sequence) {
                Role role1;
                if (lane.isAutomatic() || (role1 = organization.findRoleById(lane.getId())) != null) continue;
                String name = lane.getDefaultLabel();
                String id = ModelUtils.generateRoleId((Organization)organization, (String)name);
                Role role = organization.createRole(id, name);
                organization.addChild((ProjectObject)role);
            }
            try {
                this.project.getWriter().write(new ProjectObject[]{organization});
            }
            catch (ProjectException e) {
                throw new RuntimeException(e);
            }
            Transactable txn = (Transactable)this.container;
            try {
                txn.beginTransaction();
                this.container.addChild((ProjectObject)this.process);
            }
            finally {
                txn.endTransaction();
            }
        }
        catch (ProjectException e) {
            MessageDialog.showError((Throwable)e);
            return false;
        }
        return true;
    }

    public Process getProcess() {
        return this.process;
    }

    public FolderContainer getContainer() {
        return this.container;
    }

    public void setProcess(Process process) {
        this.process = process;
    }

    public Project getProject() {
        return this.project;
    }

    public void setDefaultTemplate(boolean b) {
        this.defaultTemplate = b;
    }

    public void setSelectedTemplateIndex(int index) {
        this.selectedTemplateIndex = index;
    }

    protected WizardStep getInitialStep() {
        return new InitialStep(this);
    }
}

