/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.process.wizard;

import java.util.ArrayList;
import javax.swing.DefaultListModel;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.process.AsynchronousProcessTemplate;
import oracle.bpm.designer.process.CallableProcessTemplate;
import oracle.bpm.designer.process.ManualProcessTemplate;
import oracle.bpm.designer.process.ProcessCreationTemplate;
import oracle.bpm.designer.process.SynchronousProcessTemplate;
import oracle.bpm.designer.process.TemplateProcessPreviewer;
import oracle.bpm.designer.process.wizard.NewBPMProcessWizard;
import oracle.bpm.draw.Color;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.ui.AbstractButton;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.List;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.border.Border;
import oracle.bpm.ui.border.BorderFactory;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.event.ListSelectionEvent;
import oracle.bpm.ui.event.ListSelectionListener;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.wizards.model.Wizard;
import oracle.bpm.ui.wizards.model.WizardStep;
import oracle.bpm.ui.wizards.ui.WizardStepPanel;

public class InitialStep
extends WizardStep<NewBPMProcessWizard> {
    private InitialStepPanel initialStepPanel;
    private Process selectedProcess;
    private ArrayList<ProcessCreationTemplate> templates;

    protected InitialStep(NewBPMProcessWizard owner) {
        super((Wizard)owner);
        this.selectedProcess = owner.getProcess();
    }

    public boolean doProcess() {
        if (this.selectedProcess == null) {
            this.selectedProcess = this.initialStepPanel.getSelectedProcess();
        }
        ((NewBPMProcessWizard)this.getWizard()).setProcess(this.selectedProcess);
        ((NewBPMProcessWizard)this.getWizard()).setDefaultTemplate(this.initialStepPanel.isDefault());
        ((NewBPMProcessWizard)this.getWizard()).setSelectedTemplateIndex(this.initialStepPanel.getSelectedTemplateIndex());
        return true;
    }

    public void undoProcess() {
    }

    public boolean isFinishable() {
        return true;
    }

    protected WizardStepPanel getPanelFor(UiContainer parent) {
        this.initialStepPanel = new InitialStepPanel(parent, this);
        this.initialStepPanel.setPageTitle(DesignerMsg.BPMN_PROCESS);
        return this.initialStepPanel;
    }

    private class InitialStepPanel
    extends WizardStepPanel {
        private RadioButton defaultButton;
        private List<ProcessCreationTemplate> templateList;

        public InitialStepPanel(UiContainer parent, WizardStep wizardStep) {
            super(parent, wizardStep);
            InitialStep.this.templates = new ArrayList();
            InitialStep.this.templates.add(new ManualProcessTemplate(((NewBPMProcessWizard)InitialStep.this.getWizard()).getProject(), ((NewBPMProcessWizard)InitialStep.this.getWizard()).getContainer()));
            InitialStep.this.templates.add(new AsynchronousProcessTemplate(((NewBPMProcessWizard)InitialStep.this.getWizard()).getProject(), ((NewBPMProcessWizard)InitialStep.this.getWizard()).getContainer()));
            InitialStep.this.templates.add(new SynchronousProcessTemplate(((NewBPMProcessWizard)InitialStep.this.getWizard()).getProject(), ((NewBPMProcessWizard)InitialStep.this.getWizard()).getContainer()));
            if (AbstractStudioWorkbench.getInstance().isInPreviewMode()) {
                InitialStep.this.templates.add(new CallableProcessTemplate(((NewBPMProcessWizard)InitialStep.this.getWizard()).getProject(), ((NewBPMProcessWizard)InitialStep.this.getWizard()).getContainer()));
            }
        }

        public boolean validateInput() {
            return true;
        }

        public Process getSelectedProcess() {
            return this.defaultButton.isSelected() ? this.getDefaultProcess() : ((ProcessCreationTemplate)this.templateList.getSelectedValue()).getProcess();
        }

        public boolean isDefault() {
            return this.defaultButton.isSelected();
        }

        public int getSelectedTemplateIndex() {
            return this.templateList.getSelectedIndex();
        }

        protected UiComponent createCenterPage(UiContainer parent) {
            Panel panel = new Panel(parent);
            panel.setLayout((Layout)new MigLayout("fill"));
            final Panel rpanel = new Panel((UiContainer)panel);
            final CardLayout cardLayout = new CardLayout();
            rpanel.setLayout((Layout)cardLayout);
            final TemplateProcessPreviewer processPreviewer = new TemplateProcessPreviewer(parent);
            processPreviewer.setSize(200, 100);
            this.defaultButton = new RadioButton(parent, DesignerMsg.DEFAULT_PROCESS);
            RadioButton fromPatternButton = new RadioButton(parent, DesignerMsg.FROM_PATTERN);
            ButtonGroup group = new ButtonGroup();
            group.add((AbstractButton)this.defaultButton);
            group.add((AbstractButton)fromPatternButton);
            Panel buttonPanel = new Panel((UiContainer)rpanel);
            buttonPanel.setLayout((Layout)new MigLayout("ins 0, gap 0"));
            buttonPanel.add((UiComponent)this.defaultButton, (Object)"wrap");
            buttonPanel.add((UiComponent)fromPatternButton);
            rpanel.add((UiComponent)new Panel((UiContainer)rpanel), (Object)"default");
            rpanel.add(this.createPatternsPanel((UiContainer)rpanel, processPreviewer), (Object)"patterns");
            if (((NewBPMProcessWizard)InitialStep.this.getWizard()).isDefaultTemplate()) {
                group.setSelected((AbstractButton)this.defaultButton, true);
                cardLayout.show((UiContainer)rpanel, "default");
            } else {
                group.setSelected((AbstractButton)fromPatternButton, true);
                cardLayout.show((UiContainer)rpanel, "patterns");
            }
            this.defaultButton.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.isStateSelected()) {
                        InitialStep.this.selectedProcess = InitialStepPanel.this.getDefaultProcess();
                        processPreviewer.updatePreview(InitialStep.this.selectedProcess);
                        cardLayout.show((UiContainer)rpanel, "default");
                    }
                }
            });
            fromPatternButton.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.isStateSelected()) {
                        cardLayout.show((UiContainer)rpanel, "patterns");
                        InitialStep.this.selectedProcess = ((ProcessCreationTemplate)InitialStepPanel.this.templateList.getSelectedValue()).getProcess();
                        processPreviewer.updatePreview(InitialStep.this.selectedProcess);
                    }
                }
            });
            processPreviewer.updatePreview(InitialStep.this.selectedProcess == null ? this.getDefaultProcess() : InitialStep.this.selectedProcess);
            panel.add((UiComponent)buttonPanel);
            panel.add(this.createPreviewPanel(processPreviewer, (UiContainer)panel), (Object)"gapleft 50, span 1 2, wrap, grow");
            panel.add((UiComponent)rpanel, (Object)"growy, wrap");
            return panel;
        }

        private Process getDefaultProcess() {
            return new AsynchronousProcessTemplate(((NewBPMProcessWizard)InitialStep.this.getWizard()).getProject(), ((NewBPMProcessWizard)InitialStep.this.getWizard()).getContainer()).getProcess();
        }

        private UiComponent createPreviewPanel(TemplateProcessPreviewer processPreviewer, UiContainer parent) {
            Panel p = new Panel(parent);
            p.setLayout((Layout)new BorderLayout());
            p.setBorder(BorderFactory.createTitledBorder((Border)BorderFactory.createLineBorder((Color)Color.BLACK, (int)2), (String)"Preview"));
            p.add((UiComponent)processPreviewer, (Object)"Center");
            return p;
        }

        private UiComponent createPatternsPanel(UiContainer parent, final TemplateProcessPreviewer previewer) {
            Panel p = new Panel(parent);
            p.setLayout((Layout)new BorderLayout());
            p.setBorder(BorderFactory.createTitledBorder((Border)BorderFactory.createLineBorder((Color)Color.BLACK, (int)2), (String)"Patterns"));
            this.templateList = new List(parent);
            DefaultListModel<ProcessCreationTemplate> listModel = new DefaultListModel<ProcessCreationTemplate>();
            for (ProcessCreationTemplate template : InitialStep.this.templates) {
                listModel.addElement(template);
            }
            this.templateList.setModel(listModel);
            this.templateList.setSelectedIndex(((NewBPMProcessWizard)InitialStep.this.getWizard()).getSelectedTemplateIndex());
            this.templateList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    InitialStep.this.selectedProcess = ((ProcessCreationTemplate)InitialStepPanel.this.templateList.getSelectedValue()).getProcess();
                    previewer.updatePreview(InitialStep.this.selectedProcess);
                }
            });
            this.templateList.setLabelProvider((LabelProvider)new LabelProvider<ProcessCreationTemplate>(){

                public Image getIcon(ProcessCreationTemplate element) {
                    return null;
                }

                public String getText(ProcessCreationTemplate element) {
                    return element.getLabel().toString();
                }
            });
            p.add(this.templateList, (Object)"Center");
            return p;
        }
    }
}

