/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.process.tree;

import oracle.bpm.designer.Context;
import oracle.bpm.designer.DesignerActions;
import oracle.bpm.designer.ProjectObjectTreeNode;
import oracle.bpm.designer.action.AddFlowNodesActionGroup;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.extensionpoint.metadata.TreeNodeMetadata;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.action.BaseAction;

@TreeNodeMetadata(objectType=SequenceFlow.class)
public class TransitionTreeNode
extends ProjectObjectTreeNode<SequenceFlow> {
    public TransitionTreeNode(SequenceFlow transition) {
        super((ProjectObject)transition);
    }

    @Override
    public Image resolveIcon() {
        Msg msg = ((SequenceFlow)this.getProjectObject()).isConditionalFlow() ? DesignerMsg.TREE_TRANSITION_CONDITIONAL : DesignerMsg.TREE_TRANSITION;
        return Image.create((Msg)msg);
    }

    @Override
    public ActionGroup createActions() {
        ActionGroup result = null;
        if (this.isEditorOpened()) {
            result = ActionGroup.create(this.getProjectObject(), (Class)((SequenceFlow)this.getProjectObject()).getRawClass());
            SequenceFlow flow = (SequenceFlow)this.getUserObject();
            result.add((BaseAction)new AddFlowNodesActionGroup(flow.getParentObject(), DesignerMsg.INSERT, (SequenceFlow)this.getUserObject()));
            result.sort();
        }
        return result;
    }

    public boolean delete() {
        DesignerActions.cutAction.actionPerformed(null);
        return true;
    }

    public boolean shouldOpenOnDoubleClick() {
        return false;
    }

    @Override
    public String toString() {
        FlowNode nodeTo = ((SequenceFlow)this.getProjectObject()).getTarget();
        return nodeTo.getDefaultLabel();
    }

    private boolean isEditorOpened() {
        return Context.getDomainFor(((SequenceFlow)this.getProjectObject()).getProcess()) != null;
    }
}

