/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.process.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.SequenceBuilder;
import oracle.bpm.designer.ProjectObjectTreeNode;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.extensionpoint.metadata.OutlineRootNode;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.view.filter.ProjectFilter;
import oracle.bpm.project.virtual.MeasurementMarksVirtualContainer;
import oracle.bpm.project.virtual.VirtualActivities;
import oracle.bpm.project.virtual.VirtualBusinessIndicatorsContainer;
import oracle.bpm.project.virtual.VirtualContainer;
import oracle.bpm.project.virtual.VirtualDataObjectsContainer;
import oracle.bpm.project.virtual.VirtualProjectDataObjectsContainer;
import org.jetbrains.annotations.NotNull;

@OutlineRootNode(objectClass=Process.class)
public class ProcessStructureTreeNode
extends ProjectObjectTreeNode<Process> {
    public ProcessStructureTreeNode(Process process) {
        super((ProjectObject)process);
        this.setMsg(DesignerMsg.PROCESS);
    }

    @Override
    protected void onLoading() {
        this.setFilter(new ProcessStructureNavigator());
        super.onLoading();
    }

    private static class ProcessStructureNavigator
    implements ProjectFilter {
        private Map<NodeContainer, VirtualActivities> activitiesContainerMap = new HashMap<NodeContainer, VirtualActivities>();
        private VirtualBusinessIndicatorsContainer businessIndicatorsContainer;
        private Map<NodeContainer, VirtualContainer> dataObjectsContainerMap = new HashMap<NodeContainer, VirtualContainer>();
        private Map<NodeContainer, MeasurementMarksVirtualContainer> measurementMarksContainerMap = new HashMap<NodeContainer, MeasurementMarksVirtualContainer>();
        private VirtualDataObjectsContainer projectDataObjectsContainer;

        private ProcessStructureNavigator() {
        }

        @NotNull
        public Sequence<? extends ProjectObject> getChildren(ProjectObjectContainer projectObject) {
            Sequence<Object> result;
            if (projectObject instanceof NodeContainer) {
                ArrayList<Object> children = new ArrayList<Object>();
                NodeContainer nodeContainer = (NodeContainer)projectObject;
                if (nodeContainer instanceof Process) {
                    Project project = nodeContainer.getProject();
                    Process defaultProcess = project.getProjectModel();
                    children.add(this.getProjectDataObjectsNodeContainer((ProjectObjectContainer)nodeContainer, (NodeContainer)defaultProcess));
                    children.add(this.getBusinessIndicatorsNodeContainer((ProjectObjectContainer)nodeContainer, (NodeContainer)defaultProcess));
                }
                children.add(this.getVirtualNodeContainer(nodeContainer));
                children.add(this.getVirtualActivities(nodeContainer));
                children.add(this.getVirtualMeasurementMarksContainer(nodeContainer));
                result = CollectionUtils.asSequence(children);
            } else if (projectObject instanceof FlowNode) {
                FlowNode node = (FlowNode)projectObject;
                Sequence conditionalSequence = node.getOutgoingConditionalFlows();
                Sequence flowSequence = node.getOutgoingSequenceFlows();
                SequenceBuilder builder = SequenceBuilder.create(conditionalSequence, flowSequence);
                result = builder.build();
            } else {
                result = projectObject.getChildren();
            }
            return result;
        }

        public ProjectObjectContainer getParent(ProjectObject projectObject) {
            FlowNode result;
            if (projectObject instanceof SequenceFlow) {
                SequenceFlow flowElement = (SequenceFlow)projectObject;
                result = flowElement.getSource();
            } else if (projectObject instanceof FlowNode) {
                FlowNode flowNode = (FlowNode)projectObject;
                NodeContainer nodeContainer = flowNode.getParentObject();
                result = (ProjectObjectContainer)this.activitiesContainerMap.get(nodeContainer);
            } else if (projectObject instanceof Measurement) {
                Measurement measurement = (Measurement)projectObject;
                NodeContainer nodeContainer = measurement.getParentObject();
                result = (ProjectObjectContainer)this.measurementMarksContainerMap.get(nodeContainer);
            } else if (projectObject instanceof DataObject) {
                if (projectObject instanceof ProjectDataObject) {
                    ProjectDataObject projectDataObject = (ProjectDataObject)projectObject;
                    result = projectDataObject.isBusiness() ? this.businessIndicatorsContainer : this.projectDataObjectsContainer;
                } else {
                    DataObject dataObject = (DataObject)projectObject;
                    NodeContainer nodeContainer = (NodeContainer)dataObject.getParentObject();
                    result = (ProjectObjectContainer)this.dataObjectsContainerMap.get(nodeContainer);
                }
            } else {
                result = (ProjectObjectContainer)projectObject.getParentObject();
            }
            return result;
        }

        private ProjectObject getProjectDataObjectsNodeContainer(ProjectObjectContainer parent, NodeContainer realParent) {
            if (this.projectDataObjectsContainer == null) {
                this.projectDataObjectsContainer = new VirtualProjectDataObjectsContainer(parent, realParent);
            }
            return this.projectDataObjectsContainer;
        }

        private ProjectObject getBusinessIndicatorsNodeContainer(ProjectObjectContainer parent, NodeContainer realParent) {
            if (this.businessIndicatorsContainer == null) {
                this.businessIndicatorsContainer = new VirtualBusinessIndicatorsContainer(parent, realParent);
            }
            return this.businessIndicatorsContainer;
        }

        private VirtualContainer getVirtualNodeContainer(NodeContainer parent) {
            VirtualContainer virtualContainer = this.dataObjectsContainerMap.get(parent);
            if (virtualContainer == null) {
                virtualContainer = new VirtualDataObjectsContainer(parent);
                this.dataObjectsContainerMap.put(parent, virtualContainer);
            }
            return virtualContainer;
        }

        private VirtualActivities getVirtualActivities(NodeContainer nodeContainer) {
            VirtualActivities virtualActivities = this.activitiesContainerMap.get(nodeContainer);
            if (virtualActivities == null) {
                virtualActivities = new VirtualActivities(nodeContainer);
                this.activitiesContainerMap.put(nodeContainer, virtualActivities);
            }
            return virtualActivities;
        }

        private MeasurementMarksVirtualContainer getVirtualMeasurementMarksContainer(NodeContainer nodeContainer) {
            MeasurementMarksVirtualContainer virtualMeasurementMarksContainer = this.measurementMarksContainerMap.get(nodeContainer);
            if (virtualMeasurementMarksContainer == null) {
                virtualMeasurementMarksContainer = new MeasurementMarksVirtualContainer(nodeContainer);
                this.measurementMarksContainerMap.put(nodeContainer, virtualMeasurementMarksContainer);
            }
            return virtualMeasurementMarksContainer;
        }
    }
}

