/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.process.tree;

import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.ModelContainerTreeNode;
import oracle.bpm.designer.ObjectSelectionListener;
import oracle.bpm.designer.ProjectNavigatorTree;
import oracle.bpm.designer.ProjectObjectTreeNode;
import oracle.bpm.designer.action.DeleteActionFactory;
import oracle.bpm.designer.action.OpenObjectAction;
import oracle.bpm.designer.process.tree.TransitionTreeNode;
import oracle.bpm.designer.utils.IconFactory;
import oracle.bpm.draw.DrawableFlowElement;
import oracle.bpm.draw.ProcessSelection;
import oracle.bpm.extensionpoint.metadata.TreeNodeMetadata;
import oracle.bpm.geom.Point;
import oracle.bpm.project.model.FolderContainer;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.ModelObject;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.dnd.DndAction;
import oracle.bpm.ui.dnd.DragItem;
import oracle.bpm.ui.dnd.DropItem;
import oracle.bpm.ui.dnd.FileTransfer;
import oracle.bpm.ui.dnd.LocalObjectTransfer;
import oracle.bpm.ui.dnd.TextTransfer;
import oracle.bpm.ui.dnd.Transfer;
import oracle.bpm.ui.tree.TreeNode;
import oracle.bpm.ui.tree.TreePath;
import org.jetbrains.annotations.NotNull;

@TreeNodeMetadata(objectType=Process.class)
public class DesignerProcessTreeNode
extends ProjectObjectTreeNode<Process>
implements ObjectSelectionListener,
DragItem,
DropItem {
    public DesignerProcessTreeNode(Process process) {
        super((ProjectObject)process);
    }

    public Process getModel() {
        return (Process)this.getProjectObject();
    }

    @Override
    public Image resolveIcon() {
        Process model = this.getModel();
        if (model != null) {
            return IconFactory.createProcessImageIcon(model.isReadOnly());
        }
        return null;
    }

    @Override
    public DesignerAction getOpenAction() {
        return new OpenObjectAction(this.getModel());
    }

    public String getProcessName() {
        if (this.getModel() != null) {
            return this.getModel().getName();
        }
        return "Invalid";
    }

    public ProjectNavigatorTree getProjectTree() {
        return (ProjectNavigatorTree)this.getTree();
    }

    public Transfer[] getTransfers() {
        return new Transfer[]{LocalObjectTransfer.getInstance(Process.class), FileTransfer.getInstance(), LocalObjectTransfer.getInstance(FolderContainer.class), TextTransfer.getInstance()};
    }

    public Object getObjectAs(Transfer transfer) {
        Object result = LocalObjectTransfer.getInstance(Process.class) == transfer ? this.getProjectObject() : (TextTransfer.getInstance() == transfer ? ((Process)this.getProjectObject()).getId() : null);
        return result;
    }

    public boolean delete() {
        Process process = this.getModel();
        boolean readOnly = process != null && process.isReadOnly();
        return !readOnly && DeleteActionFactory.getDeleteActionFor((ProjectObject)process).doIt();
    }

    public TransitionTreeNode findTransitionTreeNode(SequenceFlow transition) {
        return (TransitionTreeNode)this.find(transition);
    }

    public void processOpened() {
        this.reload();
    }

    @Override
    public String toString() {
        return this.getProcessName();
    }

    @Override
    public void whenObjectIsDeSelected(@NotNull DrawableFlowElement<? extends ModelObject> drawable, @NotNull ProcessSelection selection) {
        ProjectObjectTreeNode<FlowElement> treeNode = this.find(drawable.getModelObject());
        if (treeNode != null) {
            TreePath tp = TreePath.create((Object[])treeNode.getPath());
            if (this.getTree() == null) {
                return;
            }
            this.getTree().removeSelectionPath(tp);
        }
    }

    @Override
    public void whenObjectIsSelected(@NotNull DrawableFlowElement<? extends ModelObject> drawable, @NotNull ProcessSelection selection) {
        ProjectObjectTreeNode<FlowElement> treeNode = this.find(drawable.getModelObject());
        if (treeNode != null) {
            TreePath tp = TreePath.create((Object[])treeNode.getPath());
            if (!selection.isSingle()) {
                this.getTree().addSelectionPath(tp);
            } else {
                if (this.getTree() == null) {
                    return;
                }
                this.getTree().setSelectionPath(tp);
                this.getTree().scrollPathToVisible(tp);
            }
        }
    }

    public void drop(Object data, Transfer transfer, Point point, DndAction dndAction) {
        TreeNode treeNode = this.getParent();
        ModelContainerTreeNode containerNode = null;
        if (treeNode != null && treeNode instanceof ModelContainerTreeNode) {
            containerNode = (ModelContainerTreeNode)treeNode;
        }
        if (transfer == FileTransfer.getInstance()) {
            if (containerNode != null) {
                containerNode.drop(data, transfer, point, dndAction);
            }
            return;
        }
        if (transfer == LocalObjectTransfer.getInstance(Object.class) && data instanceof Process && containerNode != null) {
            containerNode.drop(data, transfer, point, dndAction);
        }
    }

    public boolean canDrop(Object data, Transfer transfer, Point point, DndAction dndAction) {
        return true;
    }

    @Override
    protected int getMultipleActionsMask() {
        return 31;
    }

    @Override
    protected String getName() {
        return ModelUtils.getModelTitle((Process)this.getModel());
    }

    protected void addCommonActions() {
        super.addCommonActions();
        this.getCommonActionsMap().put("delete-action", DeleteActionFactory.getDeleteActionFor((ProjectObject)this.getModel()));
    }
}

