/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.process;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.process.ProcessCreationTemplate;
import oracle.bpm.project.ProjectResourceObjectFactory;
import oracle.bpm.project.command.design.InsertActivityInTransitionCommand;
import oracle.bpm.project.model.FolderContainer;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ResourceContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.LaneUtils;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.resources.Msg;

public class ManualProcessTemplate
extends ProcessCreationTemplate {
    public ManualProcessTemplate() {
    }

    public ManualProcessTemplate(Project project, FolderContainer container) {
        super(project, container);
    }

    @Override
    public Msg getLabel() {
        return DesignerMsg.MANUAL_PROCESS;
    }

    @Override
    protected Process createProcess(String name) {
        try {
            Process process = ProjectResourceObjectFactory.createManualProcess((ResourceContainer)this.container, (String)name);
            Lane lane = process.createLane(DesignerMsg.ROLE.getString());
            lane.setSize(300);
            lane.setDefaultLabel(DesignerMsg.ROLE.getString());
            process.addChild((ProjectObject)lane);
            Activity activity = process.createActivity();
            activity = activity.toUserTask();
            process.addChild((ProjectObject)activity);
            LaneUtils.setLaneForFlowNode((Lane)lane, (FlowNode)activity);
            InsertActivityInTransitionCommand command = new InsertActivityInTransitionCommand((FlowNode)activity, (SequenceFlow)process.getSequenceFlows().iterator().next());
            command.execute();
            return process;
        }
        catch (ProjectException e) {
            return null;
        }
    }
}

