/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.print;

import oracle.bpm.designer.print.DomainPrintable;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.Drawable;
import oracle.bpm.draw.DrawableProcess;
import oracle.bpm.draw.Font;
import oracle.bpm.draw.FontMetrics;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.project.model.features.ViewScaleFeature;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.ui.UiUtilities;
import org.jetbrains.annotations.NotNull;

public class ProcessPrintable
extends DomainPrintable {
    private static final int PROCESS_HEADER_HEIGHT = 20;
    private static final Font PROCESS_HEADER_FONT = Font.SANS_SERIF.bold();

    public ProcessPrintable(@NotNull DrawableProcess drawable) {
        super((Drawable)drawable);
    }

    @Override
    protected int printHeader(int pageIndex, int width, int height) {
        Graphics graphics = this.getPrintingContext().getGraphics();
        graphics.setFont(this.getProcessHeaderFont());
        String text = ProjectDrawMsg.PROCESS.withColon().getString() + " " + ((Process)this.getDrawable().getModelObject()).getDefaultLabel();
        int textWidth = UiUtilities.computeStringWidth((FontMetrics)graphics.getFontMetrics(), (String)text);
        int textHeight = graphics.getFontMetrics().getHeight();
        graphics.setForeground(Color.BLACK);
        graphics.drawString(text, width / 2 - textWidth / 2, (int)((double)textHeight * 0.75));
        return super.printHeader(pageIndex, width, height);
    }

    @Override
    protected DrawContext createPrintableContext() {
        DrawContext context = super.createPrintableContext();
        context.setScale(((Float)((Process)this.getDrawable().getModelObject()).getFeatureValue(ViewScaleFeature.class)).floatValue());
        return context;
    }

    protected DrawableProcess getDrawable() {
        return (DrawableProcess)super.getDrawable();
    }

    @Override
    protected int getPrintingHeaderHeight() {
        return 20;
    }

    private Font getProcessHeaderFont() {
        return PROCESS_HEADER_FONT;
    }
}

