/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.preferences;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;

public enum HighlightLevel {
    NONE(ProjectDrawMsg.NONE),
    ERROR(DesignerMsg.ERRORS, Image.create((Msg)ProjectDrawMsg.ERROR)),
    WARNING(DesignerMsg.WARNINGS, Image.create((Msg)ProjectDrawMsg.WARNING));

    private final Msg msg;
    private final Image icon;

    private HighlightLevel(Msg msg) {
        this(msg, null);
    }

    private HighlightLevel(Msg msg, Image icon) {
        this.msg = msg;
        this.icon = icon;
    }

    public Msg getMsg() {
        return this.msg;
    }

    public Image getIcon() {
        return this.icon;
    }

    public boolean isDefault() {
        return this == HighlightLevel.getDefault();
    }

    public static HighlightLevel getDefault() {
        return WARNING;
    }

    public boolean isNone() {
        return this == NONE;
    }

    public boolean isError() {
        return this == ERROR;
    }

    public boolean isWarning() {
        return this == WARNING;
    }
}

