/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.organization;

import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.designer.ProjectObjectNameDialog;
import oracle.bpm.designer.action.organization.NewOrganizationalRoleAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.organization.RolePanel;
import oracle.bpm.designer.validator.CompositeValidator;
import oracle.bpm.designer.validator.organization.EmptyRoleLabelValidator;
import oracle.bpm.designer.validator.organization.RoleExistenceValidator;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.events.ProjectListenerAdapter;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.organization.RoleImpl;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ListSelectionEvent;
import oracle.bpm.ui.event.ListSelectionListener;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.table.BaseTablePanel;
import oracle.bpm.ui.table.ProviderTableModel;
import oracle.bpm.ui.table.TableModel;

public class RolesPanel
extends Panel {
    private Organization organization;
    private Panel roleDetailPanel;
    private CardLayout roleDetailPanelCardLayout;
    private ProjectListenerAdapter<Role> roleListener;
    private RolePanel rolePanel;
    private ModificationListener rolePanelModificationListener;
    private static final String NO_ROLE_PANEL = "noRolePanel";
    private static final String ROLE_PANEL = "rolePanel";

    public RolesPanel(UiContainer parent, Organization organization) {
        super(parent);
        this.organization = organization;
        this.buildUi();
    }

    public ModificationListener getRolePanelModificationListener() {
        if (this.rolePanelModificationListener == null) {
            this.rolePanelModificationListener = new ModificationListener(){

                public void objectModified(ModificationEvent event) {
                    RolesPanel.this.rolePanel.editorToObject();
                }
            };
        }
        return this.rolePanelModificationListener;
    }

    public void removeListener() {
        this.organization.removeListener(this.roleListener);
    }

    private void buildUi() {
        this.setLayout((Layout)new MigLayout("fill, gap 5, ins 5, wrap 1"));
        final RolesTableModel rolesTableModel = new RolesTableModel(this.organization.getRoles());
        this.roleListener = new ProjectListenerAdapter<Role>(Role.class){

            public void postObjectAdded(Role role, ProjectObject parent) {
                rolesTableModel.addRow((Object)role);
            }
        };
        this.organization.addListener(this.roleListener);
        RolesTablePanel rolesTablePanel = new RolesTablePanel((UiContainer)this, (TableModel)rolesTableModel);
        Panel roleDetailPanel = this.buildRoleDetailPanel((UiContainer)this);
        this.add((UiComponent)rolesTablePanel, "growx, growy 20");
        this.add((UiComponent)roleDetailPanel, "growx, growy 80");
    }

    private Panel buildRoleDetailPanel(UiContainer parent) {
        this.roleDetailPanel = new Panel(parent, DesignerMsg.ROLE);
        this.roleDetailPanelCardLayout = new CardLayout();
        this.roleDetailPanel.setLayout((Layout)this.roleDetailPanelCardLayout);
        Panel noRolePanel = new Panel((UiContainer)this.roleDetailPanel);
        noRolePanel.setLayout((Layout)new BorderLayout());
        noRolePanel.add((UiComponent)Label.createWithNoColon((UiContainer)noRolePanel, (Msg)DesignerMsg.NO_ROLE_SELECTED), (Object)"Center");
        this.rolePanel = new RolePanel((UiContainer)this.roleDetailPanel, this.organization, null);
        this.rolePanel.addModificationListener(this.getRolePanelModificationListener());
        this.roleDetailPanel.add((UiComponent)noRolePanel, (Object)NO_ROLE_PANEL);
        this.roleDetailPanel.add((UiComponent)this.rolePanel, (Object)ROLE_PANEL);
        this.roleDetailPanelCardLayout.show((UiContainer)this.roleDetailPanel, NO_ROLE_PANEL);
        return this.roleDetailPanel;
    }

    private class RolesTablePanel
    extends BaseTablePanel {
        public RolesTablePanel(UiContainer parent, TableModel tableModel) {
            super(parent, DesignerMsg.ROLES, null, tableModel);
            this.getTable().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    int[] selectedRows = RolesTablePanel.this.getTable().getSelectedRows();
                    if (selectedRows.length == 1) {
                        RolesPanel.this.rolePanel.removeModificationListener(RolesPanel.this.getRolePanelModificationListener());
                        Role role = (Role)RolesTablePanel.this.getModel().getRow(selectedRows[0]);
                        RolesPanel.this.rolePanel.setProjectObject(role);
                        RolesPanel.this.rolePanel.objectToEditor();
                        RolesPanel.this.roleDetailPanelCardLayout.show((UiContainer)RolesPanel.this.roleDetailPanel, RolesPanel.ROLE_PANEL);
                        RolesPanel.this.rolePanel.addModificationListener(RolesPanel.this.getRolePanelModificationListener());
                    } else {
                        RolesPanel.this.roleDetailPanelCardLayout.show((UiContainer)RolesPanel.this.roleDetailPanel, RolesPanel.NO_ROLE_PANEL);
                    }
                }
            });
        }

        protected void addAction() {
            NewOrganizationalRoleAction newRoleAction = new NewOrganizationalRoleAction(RolesPanel.this.organization, false);
            newRoleAction.run();
        }

        protected void selectionChanged(int[] selectedRows) {
            boolean enabled = true;
            for (int row : this.getTable().getSelectedRows()) {
                Role selectedRole = (Role)((RolesTableModel)this.getModel()).getRow(row);
                if (!selectedRole.isProcessOwner()) continue;
                enabled = false;
                break;
            }
            this.getRemoveAction().setEnabled(this.getTable().isEnabled() && selectedRows.length > 0 && enabled);
            this.getEditAction().setEnabled(this.getTable().isEnabled() && selectedRows.length == 1 && enabled);
        }

        protected void deleteAction() {
            try {
                for (int row : this.getTable().getSelectedRows()) {
                    Role selectedRole = (Role)((RolesTableModel)this.getModel()).getRow(row);
                    RolesPanel.this.organization.removeChild((ProjectObject)selectedRole);
                }
                super.deleteAction();
            }
            catch (ProjectException e) {
                e.printStackTrace();
                MessageDialog.showError((Throwable)e);
            }
        }

        protected boolean showEditAction() {
            return true;
        }

        protected void editAction() {
            Role selectedRole = (Role)((RolesTableModel)this.getModel()).getRow(this.getTable().getSelectedRow());
            if (selectedRole.isProcessOwner()) {
                MessageDialog.showWarning((Msg)DesignerMsg.UNEDITABLE_ROLE);
            } else {
                String oldName = selectedRole.getName();
                ProjectObjectNameDialog roleNameDialog = new ProjectObjectNameDialog(this.getParentWindow(), ProjectObjectType.ORGANIZATION_ROLE, oldName);
                roleNameDialog.setVisible(true);
                if (roleNameDialog.userAccepted()) {
                    String newName;
                    while (!oldName.equals(newName = roleNameDialog.getObjectName())) {
                        RoleImpl role = new RoleImpl(RolesPanel.this.organization, selectedRole.getId(), newName);
                        Msg msg = this.getRoleNameValidator().validate((Role)role);
                        if (msg == null) {
                            selectedRole.setName(newName);
                            RolesPanel.this.rolePanel.objectToEditor();
                            break;
                        }
                        MessageDialog.showError((Msg)msg);
                        roleNameDialog.setVisible(true);
                        if (roleNameDialog.userAccepted()) continue;
                    }
                    roleNameDialog.setVisible(false);
                }
            }
        }

        private CompositeValidator<Role> getRoleNameValidator() {
            CompositeValidator<Role> compositeValidator = new CompositeValidator<Role>();
            compositeValidator.addValidator(new EmptyRoleLabelValidator(RolesPanel.this.organization.getProject()));
            compositeValidator.addValidator(new RoleExistenceValidator(RolesPanel.this.organization.getProject()));
            return compositeValidator;
        }
    }

    private class RolesTableModel
    extends ProviderTableModel<Role> {
        public RolesTableModel(Sequence<Role> roles) {
            super(MsgList.create(DesignerMsg.NAME));
            this.addRows(roles);
        }

        public Object getValueAt(int row, int column) {
            return ((Role)this.getRow(row)).getName();
        }
    }
}

