/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.organization;

import oracle.bpm.designer.EditorType;
import oracle.bpm.designer.identity.MembersPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.organization.OrganizationBasePanel;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.identity.MemberContainer;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.text.TextField;
import org.jetbrains.annotations.NotNull;

public class RolePanel
extends OrganizationBasePanel<Role> {
    private TextField nameField;
    private MembersPanel roleMembersPanel;

    public RolePanel(UiContainer parent, @NotNull Organization organization, Role role) {
        super(parent, organization, role, Role.class);
    }

    public Image getIcon() {
        return Image.create((Msg)DesignerMsg.ROLE);
    }

    public Role getRole() {
        return (Role)this.getProjectObject();
    }

    public EditorType getEditorType() {
        return EditorType.ROLE;
    }

    @Override
    public void buildUI(UiContainer parent) {
        Label nameLabel = Label.create((UiContainer)parent, (Msg)ProjectDrawMsg.NAME);
        this.nameField = new TextField(parent, LENGTH_TEXT);
        this.roleMembersPanel = new MembersPanel(parent);
        this.appendRow(nameLabel, (UiComponent)this.nameField);
        this.add((UiComponent)this.roleMembersPanel, "spanx, wrap, grow");
    }

    public void editorToObject() {
    }

    @Override
    public String getTitle() {
        return this.getRole().getName();
    }

    protected void objectToEditor() {
        Role role = (Role)this.getProjectObject();
        this.nameField.setText(role.getName());
        this.nameField.setEnabled(false);
        this.roleMembersPanel.setMemberContainer((MemberContainer)role);
    }
}

