/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.organization;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import oracle.bpm.designer.EditorType;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.organization.AssignedGroups;
import oracle.bpm.designer.organization.AssignedRoles;
import oracle.bpm.designer.organization.OrganizationBasePanel;
import oracle.bpm.designer.organization.OrganizationalUnitCombo;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.extensionpoint.metadata.Editor;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.observers.ObjectPropertyListener;
import oracle.bpm.project.model.ProjectPreferences;
import oracle.bpm.project.model.organization.AssignableToGroup;
import oracle.bpm.project.model.organization.AssignableToRole;
import oracle.bpm.project.model.organization.OrganizationalUnit;
import oracle.bpm.project.model.organization.Participant;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.LanguageChooser;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.UiRunnableDecorator;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.text.NumericField;
import oracle.bpm.ui.text.TextComponent;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.util.TimeZoneItem;
import oracle.bpm.util.TimeZones;

@Editor(objectClass=Participant.class)
public class ParticipantPanel
extends OrganizationBasePanel<Participant> {
    private AssignedGroups assignedGroups;
    private AssignedRoles assignedRoles;
    private NumericField<Double> costField;
    private TextField displayNameField;
    private NumericField<Integer> efficiencySpinner;
    private TextField emailField;
    private TextField firstNameField;
    private TextField lastNameField;
    private ComboBox<Locale> localeCombo;
    private TextField nameField;
    private ObjectPropertyListener objectPropertyListener;
    private OrganizationalUnitCombo ouCombo;
    private ComboBox<TimeZoneItem> timeZoneCombo;

    public ParticipantPanel(UiContainer parent, Participant participant) {
        super(parent, participant.getOrganization(), participant, Participant.class);
    }

    public Image getIcon() {
        return Image.create((Msg)DesignerMsg.PARTICIPANTS);
    }

    public EditorType getEditorType() {
        return EditorType.PARTICIPANT;
    }

    protected void editorToObject() {
        String name = this.nameField.getText();
        if ("".equalsIgnoreCase(name)) {
            MessageDialog.showError((Msg)ProjectMsg.PARTICIPANT, (Msg)DesignerMsg.INVALID_PARTICIPANT_NAME(name));
            return;
        }
        try {
            TimeZoneItem timeZoneItem = (TimeZoneItem)this.timeZoneCombo.getSelectedItem();
            TimeZone timeZone = timeZoneItem != null ? timeZoneItem.getTimeZone() : null;
            Participant.Mutable participant = ((Participant)this.getProjectObject()).asMutable();
            participant.setMail(this.emailField.getText());
            participant.setFirstName(this.firstNameField.getText());
            participant.setLastName(this.lastNameField.getText());
            participant.setDisplayName(this.displayNameField.getText());
            participant.setEfficiency(((Integer)this.efficiencySpinner.getValue()).intValue());
            participant.setCost(((Double)this.costField.getValue()).doubleValue());
            participant.setLocale((Locale)this.localeCombo.getSelectedItem());
            participant.setTimeZone(timeZone);
            OrganizationalUnit ou = this.ouCombo.getOu();
            participant.setOrganizationalUnit(ou == null ? participant.getOrganization().getRootOrganizationalUnit() : ou);
            this.assignedRoles.addRolesAssigned((AssignableToRole)participant);
            this.assignedGroups.addGroupsAssigned((AssignableToGroup)participant);
        }
        catch (Throwable t) {
            MessageDialog.showError((Throwable)t);
        }
    }

    protected void objectToEditor() {
        Participant participant = (Participant)this.getProjectObject();
        this.nameField.setText(participant.getId());
        this.nameField.setEnabled(false);
        this.emailField.setText(participant.getMail());
        this.firstNameField.setText(participant.getFirstName());
        this.lastNameField.setText(participant.getLastName());
        this.displayNameField.setText(participant.getDisplayName());
        OrganizationalUnit ou = participant.getOrganizationalUnit();
        this.ouCombo.setSelectedOu(ou == null ? null : ou.getId());
        if (participant.getLocale() != null) {
            this.localeCombo.setSelectedItem((Object)participant.getLocale());
        }
        this.timeZoneCombo.setSelectedItem((Object)TimeZones.getNearestTimeZoneItem(participant.getTimeZone()));
        this.costField.setValue((Number)participant.getCost());
        this.efficiencySpinner.setValue((Number)participant.getEfficiency());
        this.assignedGroups.setGroupAssignment(participant.getGroupAssignments());
        this.assignedRoles.setRoleAssignment(participant.getRoleAssignments());
        UiUtilities.focusAndSelect((TextComponent)this.firstNameField);
    }

    @Override
    protected void buildUI(UiContainer parent) {
        Label nameLabel = Label.create((UiContainer)parent, (Msg)ProjectDrawMsg.NAME);
        this.nameField = new TextField(parent, LENGTH_TEXT);
        Label firstNameLabel = Label.create((UiContainer)parent, (Msg)LibMsg.FIRST_NAME);
        this.firstNameField = new TextField(parent, LENGTH_TEXT);
        Label lastNameLabel = Label.create((UiContainer)parent, (Msg)LibMsg.LAST_NAME);
        this.lastNameField = new TextField(parent, LENGTH_TEXT);
        Label displayNameLabel = Label.create((UiContainer)parent, (Msg)LibMsg.DISPLAY_NAME);
        this.displayNameField = new TextField(parent, LENGTH_TEXT);
        Label ouLabel = Label.create((UiContainer)parent, (Msg)LibMsg.OU);
        this.ouCombo = new OrganizationalUnitCombo(parent, this.getProject());
        Label emailLabel = Label.create((UiContainer)parent, (Msg)DesignerMsg.EMAIL);
        this.emailField = new TextField(parent, LENGTH_TEXT);
        Label efficiencyLabel = Label.create((UiContainer)parent, (Msg)DesignerMsg.EFFICIENCY);
        this.efficiencySpinner = NumericField.createIntegerNumericField((UiContainer)parent);
        this.efficiencySpinner.setRange((Number)1, (Number)100);
        this.efficiencySpinner.setStepSize((Number)1);
        Label costLabel = Label.create((UiContainer)parent, (Msg)DesignerMsg.COST_PER_HOUR);
        this.costField = NumericField.createDoubleNumericField((UiContainer)parent);
        this.costField.setValue((Number)0.0);
        this.costField.setColumns(12);
        this.costField.setRange((Number)0.0, (Number)Double.MAX_VALUE);
        this.costField.setAllowsInvalid(false);
        this.costField.setPattern("#,###.0##");
        Label localeLabel = Label.create((UiContainer)parent, (Msg)LibMsg.LOCALE);
        ProjectPreferences preferences = this.getProject().getPreferences();
        List locales = preferences.getAvailableLanguages();
        ArrayList mutableLocaleList = new ArrayList(locales);
        this.localeCombo = UiFactory.createMutableComboBox((UiContainer)parent, mutableLocaleList);
        this.localeCombo.setLabelProvider((LabelProvider)LanguageChooser.LanguageLabelProvider.INSTANCE);
        preferences.addPropertyObserver("availableLanguages", this.getObjectPropertyListener());
        Label timeZoneLabel = Label.create((UiContainer)parent, (Msg)LibMsg.TIMEZONE);
        this.timeZoneCombo = UiFactory.createComboBox((UiContainer)parent, (Object[])TimeZones.getSortedTimeZonesItems());
        this.assignedRoles = new AssignedRoles(parent, DesignerMsg.ASSIGN_ROLE_TO_PARTICIPANT, (AssignableToRole)this.getProjectObject());
        this.assignedGroups = new AssignedGroups(parent, DesignerMsg.ASSIGN_GROUP_TO_PARTICIPANT, ((Participant)this.getProjectObject()).getOrganization());
        this.appendRow(nameLabel, (UiComponent)this.nameField);
        this.appendRow(firstNameLabel, (UiComponent)this.firstNameField);
        this.appendRow(lastNameLabel, (UiComponent)this.lastNameField);
        this.appendRow(displayNameLabel, (UiComponent)this.displayNameField);
        this.appendRow(ouLabel, (UiComponent)this.ouCombo);
        this.appendRow(emailLabel, (UiComponent)this.emailField);
        this.appendRow(efficiencyLabel, (UiComponent)this.efficiencySpinner);
        this.appendRow(costLabel, (UiComponent)this.costField);
        this.appendRow(localeLabel, (UiComponent)this.localeCombo);
        this.appendRow(timeZoneLabel, (UiComponent)this.timeZoneCombo);
        this.appendRow((UiComponent)this.assignedRoles);
        this.appendRow((UiComponent)this.assignedGroups);
        parent.setSize(1000, 1000);
        UiUtilities.focusAndSelect((TextComponent)this.firstNameField);
    }

    private ObjectPropertyListener getObjectPropertyListener() {
        if (this.objectPropertyListener == null) {
            this.objectPropertyListener = new ObjectPropertyListener(){

                @Override
                public void propertyChanged(Object object, String propertyName) {
                    new UiRunnableDecorator(0, new Runnable(){

                        @Override
                        public void run() {
                            Locale selection = (Locale)ParticipantPanel.this.localeCombo.getSelectedItem();
                            ParticipantPanel.this.localeCombo.removeAllItems();
                            List locales = ParticipantPanel.this.getProject().getPreferences().getAvailableLanguages();
                            for (Locale locale : locales) {
                                ParticipantPanel.this.localeCombo.addItem((Object)locale);
                            }
                            if (selection != null) {
                                ParticipantPanel.this.localeCombo.setSelectedItem((Object)selection);
                            }
                        }
                    }).run();
                }
            };
        }
        return this.objectPropertyListener;
    }
}

