/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.organization;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.organization.OrganizationalChartTreePanel;
import oracle.bpm.designer.organization.OrganizationalUnitMappingPanel;
import oracle.bpm.designer.organization.OrganizationalUnitPanel;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.organization.OrganizationalChart;
import oracle.bpm.project.model.organization.OrganizationalUnit;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.TreeModelAdapter;
import oracle.bpm.ui.event.TreeModelEvent;
import oracle.bpm.ui.event.TreeModelListener;
import oracle.bpm.ui.event.TreeSelectionEvent;
import oracle.bpm.ui.event.TreeSelectionListener;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.tree.TreeNode;

public class OrganizationalUnitsPanel
extends Panel {
    private Organization organization;
    private OrganizationalChartTreePanel organizationalChartTreePanel;
    private Panel ouDetailPanel;
    private CardLayout ouDetailPanelCardLayout;
    private OrganizationalUnitPanel ouPanel;
    private ModificationListener ouPanelModificationListener;
    private static final String NO_OU_PANEL = "noOuPanel";
    private static final String OU_PANEL = "ouPanel";

    public OrganizationalUnitsPanel(UiContainer parent, Organization organization) {
        super(parent);
        this.organization = organization;
        this.buildUi();
    }

    private void buildUi() {
        this.setLayout((Layout)new MigLayout("fill, gap 5, ins 5, wrap 1, hidemode 3"));
        Panel organizationalUnitsPanel = this.buildOrganizationalUnitsPanel((UiContainer)this);
        Panel organizationalUnitDetailPanel = this.buildOrganizationalUnitDetailPanel((UiContainer)this);
        this.add((UiComponent)organizationalUnitsPanel, "growx, growy 50");
        this.add((UiComponent)organizationalUnitDetailPanel, "growx, growy 50");
    }

    private Panel buildOrganizationalUnitsPanel(UiContainer parent) {
        Panel ousPanel = new Panel(parent, DesignerMsg.OUS);
        ousPanel.setLayout((Layout)new MigLayout("fill, gap 5, ins 5, wrap 1, hidemode 3"));
        OrganizationalChart organizationalChart = this.organization.getOrganizationalChart();
        final OrganizationalUnitMappingPanel ouMappingPanel = new OrganizationalUnitMappingPanel((UiContainer)ousPanel, this.organization, organizationalChart);
        this.organizationalChartTreePanel = new OrganizationalChartTreePanel((UiContainer)ousPanel, DesignerMsg.ORGANIZATIONAL_CHART, organizationalChart);
        this.organizationalChartTreePanel.addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

            public void treeNodesRemoved(TreeModelEvent e) {
                ouMappingPanel.updateOuList();
            }

            public void treeNodesChanged(TreeModelEvent e) {
                ouMappingPanel.updateOuList();
            }

            public void treeNodesInserted(TreeModelEvent e) {
                ouMappingPanel.updateOuList();
            }
        });
        ousPanel.add((UiComponent)ouMappingPanel);
        ousPanel.add((UiComponent)this.organizationalChartTreePanel, (Object)"grow, height 150!");
        return ousPanel;
    }

    private Panel buildOrganizationalUnitDetailPanel(UiContainer parent) {
        this.ouDetailPanel = new Panel(parent, DesignerMsg.OU);
        this.ouDetailPanelCardLayout = new CardLayout();
        this.ouDetailPanel.setLayout((Layout)this.ouDetailPanelCardLayout);
        Panel noOuPanel = new Panel((UiContainer)this.ouDetailPanel);
        noOuPanel.setLayout((Layout)new MigLayout("ins 0, gap 0, hidemode 3"));
        noOuPanel.add((UiComponent)Label.createWithNoColon((UiContainer)noOuPanel, (Msg)DesignerMsg.NO_OU_SELECTED), (Object)"center");
        this.ouPanel = new OrganizationalUnitPanel((UiContainer)this.ouDetailPanel, this.organization, null);
        this.ouPanel.addModificationListener(this.getOuPanelModificationListener());
        this.ouDetailPanel.add((UiComponent)noOuPanel, (Object)NO_OU_PANEL);
        this.ouDetailPanel.add((UiComponent)this.ouPanel, (Object)OU_PANEL);
        this.ouDetailPanelCardLayout.show((UiContainer)this.ouDetailPanel, NO_OU_PANEL);
        this.organizationalChartTreePanel.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                TreeNode[] selectedNodes = OrganizationalUnitsPanel.this.organizationalChartTreePanel.getSelectedNode();
                if (selectedNodes.length == 1 && !selectedNodes[0].isRoot() && !((OrganizationalUnit)selectedNodes[0].getUserObject()).isRoot()) {
                    OrganizationalUnitsPanel.this.ouPanel.removeModificationListener(OrganizationalUnitsPanel.this.getOuPanelModificationListener());
                    OrganizationalUnitsPanel.this.ouPanel.setProjectObject((OrganizationalUnit)selectedNodes[0].getUserObject());
                    OrganizationalUnitsPanel.this.ouPanel.objectToEditor();
                    OrganizationalUnitsPanel.this.ouDetailPanelCardLayout.show((UiContainer)OrganizationalUnitsPanel.this.ouDetailPanel, OrganizationalUnitsPanel.OU_PANEL);
                    OrganizationalUnitsPanel.this.ouPanel.addModificationListener(OrganizationalUnitsPanel.this.getOuPanelModificationListener());
                } else {
                    OrganizationalUnitsPanel.this.ouDetailPanelCardLayout.show((UiContainer)OrganizationalUnitsPanel.this.ouDetailPanel, OrganizationalUnitsPanel.NO_OU_PANEL);
                }
            }
        });
        return this.ouDetailPanel;
    }

    private ModificationListener getOuPanelModificationListener() {
        if (this.ouPanelModificationListener == null) {
            this.ouPanelModificationListener = new ModificationListener(){

                public void objectModified(ModificationEvent event) {
                    if (OrganizationalUnitsPanel.this.ouPanel != null) {
                        OrganizationalUnitsPanel.this.ouPanel.editorToObject();
                    }
                }
            };
        }
        return this.ouPanelModificationListener;
    }
}

