/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.organization;

import java.util.Comparator;
import java.util.TreeSet;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.EditorType;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.organization.OrganizationBasePanel;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.project.OrganizationalUnitRefImpl;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.organization.OrganizationalChart;
import oracle.bpm.project.model.organization.OrganizationalUnit;
import oracle.bpm.project.model.organization.OrganizationalUnitRef;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.AbstractButton;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.text.TextField;
import org.jetbrains.annotations.NotNull;

public class OrganizationalUnitMappingPanel
extends OrganizationBasePanel<OrganizationalChart> {
    private Button browseOuFromRepositoryButton;
    private RadioButton noneOuRadioButton;
    private CardLayout ouFromProjectCardLayout;
    private Panel ouFromProjectCardPanel;
    private RadioButton ouFromProjectRadioButton;
    private RadioButton ouFromRepositoryRadioButton;
    private TextField ouFromRepositoryTextField;
    private ComboBox<OrganizationalUnitRef> ouRefComboBox;
    private static final String OU_FROM_PROJECT_COMBO_BOX = "OU_FROM_PROJECT_COMBO_BOX";
    private static final String NO_OUS_CREATED_LABEL = "NO_OUS_CREATED_LABEL";

    public OrganizationalUnitMappingPanel(UiContainer parent, @NotNull Organization organization, OrganizationalChart organizationalChart) {
        super(parent, organization, organizationalChart, OrganizationalChart.class, DesignerMsg.OU_MAPPING);
    }

    public void objectToEditor() {
        OrganizationalUnitRef ouRef = ((OrganizationalChart)this.getProjectObject()).getOrganizationalUnitMapping();
        this.ouRefComboBox.addItems(this.getOuRefList());
        if (ouRef != null) {
            if (ouRef.getObject() != null) {
                this.ouFromProjectRadioButton.setSelected(true);
                this.ouRefComboBox.setEnabled(true);
                this.ouRefComboBox.setSelectedItem((Object)ouRef);
            } else {
                this.ouFromRepositoryRadioButton.setSelected(true);
                this.browseOuFromRepositoryButton.setEnabled(true);
                this.ouFromRepositoryTextField.setText(ouRef.getName());
                this.ouFromRepositoryTextField.setEnabled(true);
            }
        } else {
            this.noneOuRadioButton.setSelected(true);
        }
    }

    public EditorType getEditorType() {
        return EditorType.ORGANIZATIONAL_CHART;
    }

    public Image getIcon() {
        return Image.create((Msg)DesignerMsg.ORGANIZATIONAL_CHART);
    }

    public void editorToObject() {
    }

    @Override
    public void buildUI(UiContainer parent) {
        ButtonGroup group = new ButtonGroup();
        this.noneOuRadioButton = new RadioButton(parent, DesignerMsg.NONE);
        this.noneOuRadioButton.setSelected(true);
        group.add((AbstractButton)this.noneOuRadioButton);
        this.ouFromProjectRadioButton = new RadioButton(parent, DesignerMsg.OU_FROM_PROJECT);
        this.ouFromProjectCardPanel = new Panel(parent);
        this.ouFromProjectCardLayout = new CardLayout();
        this.ouFromProjectCardPanel.setLayout((Layout)this.ouFromProjectCardLayout);
        this.ouRefComboBox = UiFactory.createComboBox((UiContainer)parent);
        this.ouRefComboBox.setEnabled(false);
        this.ouRefComboBox.setLabelProvider(this.getOuComboBoxLabelProvider());
        this.ouFromProjectCardPanel.add(this.ouRefComboBox, (Object)OU_FROM_PROJECT_COMBO_BOX);
        this.ouFromProjectCardPanel.add((UiComponent)Label.createWithNoColon((UiContainer)this.ouFromProjectCardPanel, (Msg)DesignerMsg.NO_OUS_CREATED_YET), (Object)NO_OUS_CREATED_LABEL);
        group.add((AbstractButton)this.ouFromProjectRadioButton);
        this.ouFromRepositoryRadioButton = new RadioButton(parent, DesignerMsg.OU_FROM_REPOSITORY);
        this.ouFromRepositoryTextField = new TextField(parent);
        this.ouFromRepositoryTextField.setEditable(false);
        this.ouFromRepositoryTextField.setEnabled(false);
        this.browseOuFromRepositoryButton = new Button(parent, Image.create((Msg)DesignerMsg.FIND_COMPONENT));
        this.browseOuFromRepositoryButton.setEnabled(false);
        Button.fixSize((Button)this.browseOuFromRepositoryButton);
        group.add((AbstractButton)this.ouFromRepositoryRadioButton);
        this.add((UiComponent)Label.create((UiContainer)parent, (Msg)DesignerMsg.ASSOCIATE_OU_WITH_PROJECT), "span 3, wrap");
        this.add((UiComponent)this.noneOuRadioButton, "wrap");
        this.add((UiComponent)this.ouFromProjectRadioButton);
        this.add((UiComponent)this.ouFromProjectCardPanel, "width pref:pref:400, span 3, wrap");
        this.add((UiComponent)this.ouFromRepositoryRadioButton);
        this.add((UiComponent)this.ouFromRepositoryTextField);
        this.add((UiComponent)this.browseOuFromRepositoryButton);
        this.objectToEditor();
        this.updateOuFromProjectCardPanelVisibility();
        this.noneOuRadioButton.addActionListener(this.getNoneOuRadioButtonActionListener());
        this.ouFromProjectRadioButton.addActionListener(this.getOuFromProjectRadioButtonActionListener());
        this.ouRefComboBox.addModificationListener(this.getOuComboBoxModificationListener());
        this.ouFromRepositoryRadioButton.addActionListener(this.getOuFromRepositoryRadioButtonActionListener());
        this.browseOuFromRepositoryButton.addActionListener(this.getBrowseOuFromRespositoryActionListener());
    }

    public void updateOuList() {
        this.ouRefComboBox.removeAllItems();
        this.objectToEditor();
        this.updateOuFromProjectCardPanelVisibility();
    }

    private ActionListener getNoneOuRadioButtonActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((OrganizationalChart)OrganizationalUnitMappingPanel.this.getProjectObject()).setOrganizationalUnitMapping(null);
                OrganizationalUnitMappingPanel.this.ouRefComboBox.setEnabled(false);
                OrganizationalUnitMappingPanel.this.browseOuFromRepositoryButton.setEnabled(false);
                OrganizationalUnitMappingPanel.this.ouFromRepositoryTextField.setEnabled(false);
            }
        };
    }

    private void updateOuFromProjectCardPanelVisibility() {
        if (CollectionUtils.size(this.getOrganization().getOrganizationalUnits()) > 0) {
            this.ouFromProjectCardLayout.show((UiContainer)this.ouFromProjectCardPanel, OU_FROM_PROJECT_COMBO_BOX);
        } else {
            this.ouFromProjectCardLayout.show((UiContainer)this.ouFromProjectCardPanel, NO_OUS_CREATED_LABEL);
        }
    }

    private ActionListener getOuFromRepositoryRadioButtonActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OrganizationalUnitMappingPanel.this.ouRefComboBox.setEnabled(false);
                OrganizationalUnitMappingPanel.this.ouFromRepositoryTextField.setEnabled(true);
                OrganizationalUnitMappingPanel.this.browseOuFromRepositoryButton.setEnabled(true);
            }
        };
    }

    private ActionListener getBrowseOuFromRespositoryActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OrganizationalUnitRef ref = AbstractStudioWorkbench.getInstance().getLookupOUService().selectOu(OrganizationalUnitMappingPanel.this.getParent().asSwing(), OrganizationalUnitMappingPanel.this.getProject());
                if (ref != null) {
                    OrganizationalUnitMappingPanel.this.ouFromRepositoryTextField.setText(ref.getName());
                    ((OrganizationalChart)OrganizationalUnitMappingPanel.this.getProjectObject()).setOrganizationalUnitMapping(ref);
                }
            }
        };
    }

    private ActionListener getOuFromProjectRadioButtonActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!OrganizationalUnitMappingPanel.this.getOrganization().getOrganizationalUnits().isEmpty()) {
                    OrganizationalUnit ou = (OrganizationalUnit)OrganizationalUnitMappingPanel.this.getOrganization().getOrganizationalUnits().iterator().next();
                    OrganizationalUnitRefImpl ouRef = new OrganizationalUnitRefImpl(ou.getId(), OrganizationalUnitMappingPanel.this.getProject());
                    ((OrganizationalChart)OrganizationalUnitMappingPanel.this.getProjectObject()).setOrganizationalUnitMapping((OrganizationalUnitRef)ouRef);
                    OrganizationalUnitMappingPanel.this.ouRefComboBox.setSelectedItem((Object)ouRef);
                }
                OrganizationalUnitMappingPanel.this.ouRefComboBox.setEnabled(true);
                OrganizationalUnitMappingPanel.this.ouFromRepositoryTextField.setEnabled(false);
                OrganizationalUnitMappingPanel.this.browseOuFromRepositoryButton.setEnabled(false);
            }
        };
    }

    private LabelProvider<OrganizationalUnitRef> getOuComboBoxLabelProvider() {
        return new LabelProvider.Default<OrganizationalUnitRef>(){

            public String getText(OrganizationalUnitRef element) {
                return element != null ? ((OrganizationalUnit)element.getObject()).getInternalPath() : "";
            }
        };
    }

    private ModificationListener getOuComboBoxModificationListener() {
        return new ModificationListener(){

            public void objectModified(ModificationEvent event) {
                ((OrganizationalChart)OrganizationalUnitMappingPanel.this.getProjectObject()).setOrganizationalUnitMapping((OrganizationalUnitRef)OrganizationalUnitMappingPanel.this.ouRefComboBox.getSelectedItem());
            }
        };
    }

    private Iterable<OrganizationalUnitRef> getOuRefList() {
        TreeSet<OrganizationalUnitRef> list = new TreeSet<OrganizationalUnitRef>(new Comparator<OrganizationalUnitRef>(){

            @Override
            public int compare(OrganizationalUnitRef organizationalUnitRef, OrganizationalUnitRef organizationalUnitRef1) {
                return ((OrganizationalUnit)organizationalUnitRef.getObject()).getName().compareTo(((OrganizationalUnit)organizationalUnitRef1.getObject()).getName());
            }
        });
        Project project = ((OrganizationalChart)this.getProjectObject()).getProject();
        for (OrganizationalUnit ou : project.getOrganization().getOrganizationalUnits()) {
            list.add((OrganizationalUnitRef)new OrganizationalUnitRefImpl(ou.getId(), project));
        }
        OrganizationalUnitRef currentOuRef = ((OrganizationalChart)this.getProjectObject()).getOrganizationalUnitMapping();
        if (currentOuRef != null && this.getOrganization().findOrganizationalUnit(currentOuRef.getId()) != null && !list.contains(currentOuRef)) {
            list.add(currentOuRef);
        }
        return list;
    }
}

