/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.organization;

import oracle.bpm.designer.action.organization.NewOrganizationalUnitAction;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.organization.OrganizationalChart;
import oracle.bpm.project.model.organization.OrganizationalUnit;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.tree.TreeBasePanel;
import oracle.bpm.ui.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public class OrganizationalChartTreePanel
extends TreeBasePanel {
    private OrganizationalChart organizationalChart;

    public OrganizationalChartTreePanel(UiContainer parent, Msg title, OrganizationalChart organizationalChart) {
        super(parent, title);
        this.organizationalChart = organizationalChart;
        this.init();
    }

    protected void addAction(@NotNull TreeNode selectedNode) {
        OrganizationalUnit parentOu = selectedNode.isRoot() ? null : (OrganizationalUnit)selectedNode.getUserObject();
        NewOrganizationalUnitAction newOuAction = new NewOrganizationalUnitAction(this.organizationalChart.getOrganization(), parentOu, false);
        newOuAction.run();
        OrganizationalUnit newOu = (OrganizationalUnit)newOuAction.getObjectAdded();
        if (newOu != null) {
            TreeNode nodeAded = selectedNode.addDynamic((Object)newOu);
            nodeAded.select();
        }
    }

    protected void deleteAction(@NotNull TreeNode selectedNode) {
        try {
            OrganizationalUnit ou = (OrganizationalUnit)selectedNode.getUserObject();
            if (ou.getParent() == null) {
                this.organizationalChart.removeChild((ProjectObject)ou);
            } else {
                ou.getParent().removeChild((ProjectObject)ou);
            }
            super.deleteAction(selectedNode);
        }
        catch (Throwable t) {
            MessageDialog.showError((Throwable)t);
        }
    }

    protected boolean isAddableSelection() {
        return super.isAddableSelection() && (this.getSelectedTreeNode() == this.getRoot() && !this.getSelectedTreeNode().hasChildren() || this.getSelectedTreeNode() != this.getRoot());
    }

    private void init() {
        this.setRoot(TreeNode.createDynamic((Object)this.organizationalChart));
    }
}

