/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.organization;

import oracle.bpm.designer.EditorType;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.organization.OrganizationBasePanel;
import oracle.bpm.designer.organization.OrganizationalChartTreePanel;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.project.model.organization.OrganizationalChart;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.text.TextField;
import org.jetbrains.annotations.NotNull;

public class OrganizationalChartPanel
extends OrganizationBasePanel<OrganizationalChart> {
    private TextField nameField;

    public OrganizationalChartPanel(UiContainer parent, @NotNull OrganizationalChart organizationalChart) {
        super(parent, organizationalChart.getOrganization(), organizationalChart, OrganizationalChart.class);
    }

    public Image getIcon() {
        return Image.create((Msg)DesignerMsg.ORGANIZATIONAL_CHART);
    }

    public EditorType getEditorType() {
        return EditorType.ORGANIZATIONAL_CHART;
    }

    @Override
    protected void buildUI(UiContainer parent) {
        Label nameLabel = Label.create((UiContainer)parent, (Msg)ProjectDrawMsg.NAME);
        this.nameField = new TextField(parent, LENGTH_TEXT);
        OrganizationalChartTreePanel chartTree = new OrganizationalChartTreePanel(parent, DesignerMsg.ORGANIZATIONAL_CHART, (OrganizationalChart)this.getProjectObject());
        this.appendRow(nameLabel, (UiComponent)this.nameField);
        this.appendRow((UiComponent)chartTree);
    }

    protected void editorToObject() {
    }

    protected void objectToEditor() {
        OrganizationalChart oc = (OrganizationalChart)this.getProjectObject();
        if (oc == null) {
            return;
        }
        this.nameField.setText(oc.getId());
        this.nameField.setEnabled(false);
    }
}

