/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.organization;

import java.util.HashMap;
import java.util.Map;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.organization.OrganizationTreeNode;
import oracle.bpm.extensionpoint.metadata.OutlineProjectFilter;
import oracle.bpm.project.model.CalendarRulesContainer;
import oracle.bpm.project.model.HolidayRulesContainer;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.RolesContainer;
import oracle.bpm.project.model.organization.CalendarRule;
import oracle.bpm.project.model.organization.HolidayRule;
import oracle.bpm.project.model.organization.OrganizationalChart;
import oracle.bpm.project.model.organization.OrganizationalUnit;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.organization.CalendarRulesContainerImpl;
import oracle.bpm.project.organization.HolidayRulesContainerImpl;
import oracle.bpm.project.organization.RolesContainerImpl;
import oracle.bpm.project.view.filter.ProjectFilter;
import org.jetbrains.annotations.NotNull;

@OutlineProjectFilter(rootNodeClass=OrganizationTreeNode.class)
public class OrganizationNodeOutlineProjectFilter
implements ProjectFilter {
    private Organization organization;
    private Map<Path, ProjectObjectContainer> organizationObjectContainers = new HashMap<Path, ProjectObjectContainer>();

    public OrganizationNodeOutlineProjectFilter(OrganizationTreeNode organizationTreeNode) {
        this.organization = (Organization)organizationTreeNode.getProjectObject();
        this.organizationObjectContainers.put(Path.ROLE, (ProjectObjectContainer)new RolesContainerImpl(this.organization.getProject()));
        this.organizationObjectContainers.put(Path.ORGANIZATIONAL_CHART, (ProjectObjectContainer)this.organization.getOrganizationalChart());
        this.organizationObjectContainers.put(Path.HOLIDAY, (ProjectObjectContainer)new HolidayRulesContainerImpl(this.organization.getProject()));
        this.organizationObjectContainers.put(Path.CALENDAR, (ProjectObjectContainer)new CalendarRulesContainerImpl(this.organization.getProject()));
    }

    @NotNull
    public Sequence<? extends ProjectObject> getChildren(ProjectObjectContainer object) {
        if (object instanceof Organization) {
            return CollectionUtils.asSequence(this.organizationObjectContainers.values());
        }
        if (object instanceof RolesContainer) {
            return this.organization.getRoles();
        }
        if (object instanceof OrganizationalChart) {
            return object.getChildren();
        }
        if (object instanceof OrganizationalUnit) {
            return object.getChildren();
        }
        if (object instanceof HolidayRulesContainer) {
            return this.organization.getHolidayRules();
        }
        if (object instanceof CalendarRulesContainer) {
            return this.organization.getCalendarRules();
        }
        return CollectionUtils.emptySequence();
    }

    public ProjectObjectContainer getParent(ProjectObject object) {
        if (object instanceof RolesContainer || object instanceof OrganizationalChart || object instanceof HolidayRulesContainer || object instanceof CalendarRulesContainer) {
            return this.organization;
        }
        if (object instanceof Role) {
            return this.organizationObjectContainers.get(Path.ROLE);
        }
        if (object instanceof OrganizationalUnit) {
            OrganizationalUnit ou = (OrganizationalUnit)object;
            if (ou.getParent() == null || ou.isRoot()) {
                return this.organizationObjectContainers.get(Path.ORGANIZATIONAL_CHART);
            }
            return ou.getParent();
        }
        if (object instanceof HolidayRule) {
            return this.organizationObjectContainers.get(Path.HOLIDAY);
        }
        if (object instanceof CalendarRule) {
            return this.organizationObjectContainers.get(Path.CALENDAR);
        }
        return null;
    }
}

