/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.organization;

import oracle.bpm.designer.AbstractEditor;
import oracle.bpm.designer.EditorType;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.organization.CalendarRulesPanel;
import oracle.bpm.designer.organization.HolidayRulesPanel;
import oracle.bpm.designer.organization.OrganizationalUnitsPanel;
import oracle.bpm.designer.organization.RolesPanel;
import oracle.bpm.extensionpoint.metadata.Editor;
import oracle.bpm.project.model.Organization;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.TabbedPane;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.VisibilityListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;

@Editor(objectClass=Organization.class)
public class OrganizationEditor
extends AbstractEditor<Organization> {
    private CalendarRulesPanel calendarRulesPanel;
    private TabbedPane organizationTabbedPane;
    private RolesPanel rolesPanel;

    public OrganizationEditor(UiContainer parent, Organization organization) {
        super(parent, organization, Organization.class);
        this.addVisibilityListener(new VisibilityListener(){

            public void onDispose() {
                System.out.print("");
            }
        });
    }

    @Override
    public Image getIcon() {
        return Image.create((Msg)this.getEditorType().getMsg());
    }

    @Override
    public EditorType getEditorType() {
        return EditorType.ORGANIZATION;
    }

    @Override
    public void openPart(Object part) {
    }

    @Override
    public String getHelpId() {
        return this.organizationTabbedPane.getHelpId();
    }

    @Override
    protected void buildUI(UiContainer parent) {
        parent.setLayout((Layout)new BorderLayout());
        this.organizationTabbedPane = new TabbedPane(parent, 2){

            public String getHelpId() {
                return OrganizationEditor.this.getDefaultHelpId() + "." + this.getTabHelpId();
            }
        };
        this.rolesPanel = new RolesPanel((UiContainer)this.organizationTabbedPane, (Organization)this.getProjectObject());
        this.organizationTabbedPane.addTab(DesignerMsg.ROLES, (UiComponent)this.rolesPanel);
        this.organizationTabbedPane.addTab(DesignerMsg.ORGANIZATIONAL_CHART, (UiComponent)new OrganizationalUnitsPanel((UiContainer)this.organizationTabbedPane, (Organization)this.getProjectObject()));
        this.organizationTabbedPane.addTab(DesignerMsg.HOLIDAYS, (UiComponent)new HolidayRulesPanel((UiContainer)this.organizationTabbedPane, (Organization)this.getProjectObject()));
        this.calendarRulesPanel = new CalendarRulesPanel((UiContainer)this.organizationTabbedPane, (Organization)this.getProjectObject());
        this.organizationTabbedPane.addTab(DesignerMsg.CALENDARS_ICON, (UiComponent)this.calendarRulesPanel);
        parent.add((UiComponent)this.organizationTabbedPane, (Object)"Center");
    }

    @Override
    protected void editorToObject() {
    }

    @Override
    protected void objectToEditor() {
    }

    protected void onDispose() {
        this.calendarRulesPanel.removeListener();
        this.rolesPanel.removeListener();
        super.onDispose();
    }
}

