/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.organization;

import java.util.List;
import oracle.bpm.designer.organization.OrganizationBaseSheet;
import oracle.bpm.project.model.Project;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.TreePanel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ListSelectionEvent;
import oracle.bpm.ui.event.ListSelectionListener;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.table.ProviderTableModel;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.table.TableAdapter;
import oracle.bpm.ui.table.TableListener;
import oracle.bpm.ui.table.TableModel;
import oracle.bpm.ui.table.ViewerSorter;

public abstract class OrganizationBaseTableSheet<E>
extends OrganizationBaseSheet<E> {
    private Table table;

    public OrganizationBaseTableSheet(TreePanel.Sheet parent, Msg msg, Project project) {
        super(parent, msg, project);
    }

    protected abstract ProviderTableModel createTableModel();

    protected ProviderTableModel<E> getModel() {
        return (ProviderTableModel)this.table.getModel();
    }

    @Override
    protected E getSelectedObject() {
        return this.getSelectedObject(this.table.getSelectedRow());
    }

    @Override
    protected List<E> getSelectedObjects() {
        return this.getModel().getRows(this.table.getSelectedRows());
    }

    protected Table getTable() {
        return this.table;
    }

    @Override
    protected UiComponent buildEditor(UiContainer parent) {
        ProviderTableModel tableModel = this.createTableModel();
        this.table = new Table(parent, (TableModel)tableModel);
        this.table.setSorter(new ViewerSorter());
        this.table.addTableListener((TableListener)new TableAdapter(){

            public void doubleClick(Table table, int row, int column, MouseEvent e) {
                table.setSelectionInterval(row, row);
                OrganizationBaseTableSheet.this.updateAction(OrganizationBaseTableSheet.this.getSelectedObject());
            }
        });
        this.table.setShowVerticalLines(true);
        this.table.setShowHorizontalLines(true);
        this.table.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                OrganizationBaseTableSheet.this.updateActions(OrganizationBaseTableSheet.this.getSelectedObjects().size());
            }
        });
        if (tableModel.getRowCount() > 0) {
            this.table.setSelectionInterval(0, 0);
        }
        return this.table;
    }

    @Override
    protected void refresh() {
        ProviderTableModel tableModel = this.createTableModel();
        this.table.setModel((TableModel)tableModel);
        if (tableModel.getRowCount() > 0) {
            this.table.setSelectionInterval(0, 0);
        }
    }

    private E getSelectedObject(int row) {
        return (E)this.getModel().getRow(row);
    }
}

