/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.organization;

import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.EditionPanel;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.text.TextArea;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OrganizationBasePanel<E extends ProjectObject>
extends EditionPanel {
    private Organization organization;
    private E projectObject;
    protected static int LENGTH_TEXT = 35;

    public OrganizationBasePanel(UiContainer parent, @NotNull Organization organization, @Nullable E projectObject, Class<E> objectType) {
        this(parent, organization, projectObject, objectType, null);
    }

    public OrganizationBasePanel(UiContainer parent, @NotNull Organization organization, @Nullable E projectObject, Class<E> objectType, Msg title) {
        super(parent, title);
        this.projectObject = projectObject;
        this.organization = organization;
        this.setLayout((Layout)this.createStandardLayout());
        this.buildUI((UiContainer)this);
    }

    public E getProjectObject() {
        return this.projectObject;
    }

    public void setProjectObject(E projectObject) {
        this.projectObject = projectObject;
    }

    public Organization getOrganization() {
        return this.organization;
    }

    public Object getInput() {
        return this.getProjectObject();
    }

    public String getTitle() {
        return this.getProjectObject().getId();
    }

    protected abstract void buildUI(UiContainer var1);

    protected MigLayout createStandardLayout() {
        return new MigLayout("fill, ins 0, gap 5, hidemode 3");
    }

    protected void appendRow(Label label, UiComponent component) {
        Panel p = new Panel(this.getParent());
        p.setLayout((Layout)new MigLayout("ins 0, gap 5, hidemode 3"));
        p.add((UiComponent)label);
        p.add(component, (Object)"spanx,  wrap");
        this.add((UiComponent)p, "wrap");
    }

    protected void appendRow(UiComponent label, UiComponent component, UiComponent component1) {
        this.add(label);
        this.add(component);
        this.add(component1, "wrap");
    }

    protected void appendRow(Label label, TextArea component) {
        this.add((UiComponent)label, "wrap");
        this.add((UiComponent)component, "spanx, wrap");
    }

    protected void appendRow(UiComponent component) {
        this.add(component, "spanx, wrap");
    }

    protected Project getProject() {
        return this.organization.getProject();
    }
}

