/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.organization;

import oracle.bpm.designer.ProjectObjectTreeNode;
import oracle.bpm.designer.utils.IconFactory;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.organization.OrganizationObject;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;

public abstract class OrganizationBaseObjectTreeNode<O extends OrganizationObject>
extends ProjectObjectTreeNode<O> {
    protected OrganizationBaseObjectTreeNode(O object, Msg msg) {
        super((ProjectObject)object);
        this.setUserObject(object);
        Image icon = Image.create((Msg)msg);
        this.setIcon(!this.isReadOnly() ? icon : IconFactory.createReadOnly(icon));
    }

    public Organization getOrganization() {
        return ((OrganizationObject)this.getProjectObject()).getOrganization();
    }

    @Override
    public Image resolveIcon() {
        return this.icon;
    }

    @Override
    public String toString() {
        return ((OrganizationObject)this.getProjectObject()).getName();
    }

    protected final boolean isValidName(String name) {
        return false;
    }

    protected boolean isReadOnly() {
        return ((OrganizationObject)this.getProjectObject()).isReadOnly();
    }
}

