/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.organization;

import java.util.Collection;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.geom.Dimension;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectWriter;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.event.DocumentEvent;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.text.TextField;

public abstract class OrganizationBaseDialog
extends OkCancelDialog {
    protected Collection disabledComponents;
    private UiComponent editorPanel;
    private ProjectObject object;
    private Project project;
    private static final int LENGTH_TEXT = 35;

    public OrganizationBaseDialog(UiWindow parent, Msg title, Project project, ProjectObject object) {
        super(parent, title, true);
        this.project = project;
        this.object = object;
        this.getContentPane().setLayout((Layout)new BorderLayout());
    }

    public UiComponent getEditorPanel() {
        return this.editorPanel;
    }

    public void setObject(ProjectObject object) {
        this.object = object;
    }

    public ProjectObject getObject() {
        return this.object;
    }

    public Dimension getMinimunSize() {
        return this.getPreferredSize();
    }

    protected abstract UiComponent buildEditorPanel(UiContainer var1);

    protected abstract void populate(ProjectObject var1);

    protected TextField getKeyTextField(UiContainer parent) {
        TextField textField = new TextField(parent, 35);
        this.addDocumentListener(textField);
        return textField;
    }

    protected Project getProject() {
        return this.project;
    }

    protected void addDocumentListener(final TextField textField) {
        textField.addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                OrganizationBaseDialog.this.okButton.setEnabled(textField.getText().trim().length() > 0);
            }

            public void removeUpdate(DocumentEvent e) {
                OrganizationBaseDialog.this.okButton.setEnabled(textField.getText().trim().length() > 0);
            }

            public void changedUpdate(DocumentEvent e) {
            }
        });
    }

    protected boolean editThisObject(String object, String name) {
        int result = MessageDialog.showQuestion((Msg)DesignerMsg.DUPLICATE_ID, (Msg)DesignerMsg.OBJECT_NAME_EXISTS_EDIT(object, name), (int)6);
        return result == 2;
    }

    protected void init() {
        this.addEditorPanel();
        this.setSize(700, 320);
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }

    protected void updateEditorPanel() {
        this.getContentPane().remove(this.editorPanel);
        this.addEditorPanel();
        this.getContentPane().validate();
    }

    protected void store() {
        ProjectWriter projectWriter = this.getProject().getWriter();
        try {
            projectWriter.write(new ProjectObject[]{this.getObject()});
        }
        catch (ProjectException e) {
            MessageDialog.showError((Throwable)e);
        }
    }

    private void addEditorPanel() {
        this.editorPanel = this.buildEditorPanel(this.getContentPane());
        this.getContentPane().add(this.editorPanel, (Object)"Center");
    }
}

