/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.organization;

import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.designer.action.organization.NewHolidayRuleAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.organization.HolidayPanel;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.HolidayRule;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ListSelectionEvent;
import oracle.bpm.ui.event.ListSelectionListener;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.table.BaseTablePanel;
import oracle.bpm.ui.table.ProviderTableModel;

public class HolidayRulesPanel
extends Panel {
    private HolidayPanel holidayPanel;
    private Panel holidayRuleDetailPanel;
    private ModificationListener holidayRulePanelModificationListener;
    private CardLayout hrDetailPanelCardLayout;
    private Organization organization;
    private static final String NO_HOLIDAY_RULE_PANEL = "noHolidayRulePanel";
    private static final String HOLIDAY_PANEL = "holidayPanel";

    public HolidayRulesPanel(UiContainer parent, Organization organization) {
        super(parent);
        this.organization = organization;
        this.buildUi();
    }

    private void buildUi() {
        this.setLayout((Layout)new MigLayout("fill, gap 5, ins 5, wrap 1"));
        HolidayRulesTableModel holidayRulesTableModel = new HolidayRulesTableModel(this.organization.getHolidayRules());
        HolidayRulesTablePanel holidayRulesTablePanel = new HolidayRulesTablePanel((UiContainer)this, holidayRulesTableModel);
        Panel holidayRulePanel = this.buildHolidayRuleDetailPanel((UiContainer)this);
        this.add((UiComponent)holidayRulesTablePanel, "growx, growy 20");
        this.add((UiComponent)holidayRulePanel, "growx, growy 80");
    }

    private Panel buildHolidayRuleDetailPanel(UiContainer parent) {
        this.holidayRuleDetailPanel = new Panel(parent, DesignerMsg.HOLIDAY_RULE);
        this.hrDetailPanelCardLayout = new CardLayout();
        this.holidayRuleDetailPanel.setLayout((Layout)this.hrDetailPanelCardLayout);
        Panel noHolidayRulePanel = new Panel((UiContainer)this.holidayRuleDetailPanel);
        noHolidayRulePanel.setLayout((Layout)new BorderLayout());
        noHolidayRulePanel.add((UiComponent)Label.createWithNoColon((UiContainer)noHolidayRulePanel, (Msg)DesignerMsg.NO_HOLIDAY_RULE_SELECTED), (Object)"Center");
        this.holidayPanel = new HolidayPanel((UiContainer)this.holidayRuleDetailPanel, this.organization, null);
        this.holidayPanel.addModificationListener(this.getHolidayPanelModificationListener());
        this.holidayRuleDetailPanel.add((UiComponent)noHolidayRulePanel, (Object)NO_HOLIDAY_RULE_PANEL);
        this.holidayRuleDetailPanel.add((UiComponent)this.holidayPanel, (Object)HOLIDAY_PANEL);
        this.hrDetailPanelCardLayout.show((UiContainer)this.holidayRuleDetailPanel, NO_HOLIDAY_RULE_PANEL);
        return this.holidayRuleDetailPanel;
    }

    private ModificationListener getHolidayPanelModificationListener() {
        if (this.holidayRulePanelModificationListener == null) {
            this.holidayRulePanelModificationListener = new ModificationListener(){

                public void objectModified(ModificationEvent event) {
                    HolidayRulesPanel.this.holidayPanel.editorToObject();
                }
            };
        }
        return this.holidayRulePanelModificationListener;
    }

    private class HolidayRulesTablePanel
    extends BaseTablePanel {
        public HolidayRulesTablePanel(UiContainer parent, ProviderTableModel<HolidayRule> tableModel) {
            super(parent, DesignerMsg.HOLIDAY_RULES, null, tableModel);
            this.getTable().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    int[] selectedRows = HolidayRulesTablePanel.this.getTable().getSelectedRows();
                    if (selectedRows.length == 1) {
                        HolidayRulesPanel.this.holidayPanel.removeModificationListener(HolidayRulesPanel.this.getHolidayPanelModificationListener());
                        HolidayRule holidayRule = (HolidayRule)HolidayRulesTablePanel.this.getModel().getRow(selectedRows[0]);
                        HolidayRulesPanel.this.holidayPanel.setProjectObject(holidayRule);
                        HolidayRulesPanel.this.holidayPanel.objectToEditor();
                        HolidayRulesPanel.this.hrDetailPanelCardLayout.show((UiContainer)HolidayRulesPanel.this.holidayRuleDetailPanel, HolidayRulesPanel.HOLIDAY_PANEL);
                        HolidayRulesPanel.this.holidayPanel.addModificationListener(HolidayRulesPanel.this.getHolidayPanelModificationListener());
                    } else {
                        HolidayRulesPanel.this.hrDetailPanelCardLayout.show((UiContainer)HolidayRulesPanel.this.holidayRuleDetailPanel, HolidayRulesPanel.NO_HOLIDAY_RULE_PANEL);
                    }
                }
            });
        }

        protected void addAction() {
            NewHolidayRuleAction newHolidayRuleAction = new NewHolidayRuleAction(HolidayRulesPanel.this.organization, false);
            newHolidayRuleAction.run();
            HolidayRule object = (HolidayRule)newHolidayRuleAction.getObjectAdded();
            if (object != null) {
                this.getModel().addRow((Object)object);
            }
        }

        protected void deleteAction() {
            try {
                for (int row : this.getTable().getSelectedRows()) {
                    HolidayRule holidayRule = (HolidayRule)((HolidayRulesTableModel)this.getModel()).getRow(row);
                    HolidayRulesPanel.this.organization.removeChild((ProjectObject)holidayRule);
                }
                super.deleteAction();
            }
            catch (ProjectException e) {
                e.printStackTrace();
                MessageDialog.showError((Throwable)e);
            }
        }
    }

    private class HolidayRulesTableModel
    extends ProviderTableModel<HolidayRule> {
        public HolidayRulesTableModel(Iterable<HolidayRule> holidayRules) {
            super(MsgList.create(DesignerMsg.HOLIDAYS));
            this.addRows(holidayRules);
        }

        public Object getValueAt(int row, int column) {
            return ((HolidayRule)this.getRow(row)).getName();
        }
    }
}

