/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.organization;

import oracle.bpm.designer.EditorType;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.organization.AssignedHolidays;
import oracle.bpm.designer.organization.OrganizationBasePanel;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.holidays.HolidayCalendar;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.organization.HolidayRule;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.text.TextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HolidayPanel
extends OrganizationBasePanel<HolidayRule> {
    private AssignedHolidays assignedHolidays;
    private TextField nameField;

    public HolidayPanel(UiContainer parent, @NotNull Organization organization, @Nullable HolidayRule holidayRule) {
        super(parent, organization, holidayRule, HolidayRule.class);
    }

    public Image getIcon() {
        return Image.create((Msg)DesignerMsg.HOLIDAYS);
    }

    public EditorType getEditorType() {
        return EditorType.HOLIDAY_RULE;
    }

    protected void editorToObject() {
        try {
            HolidayRule.Mutable holidayRule = ((HolidayRule)this.getProjectObject()).asMutable();
            HolidayCalendar holidayCalendar = this.assignedHolidays.getHolidayCalendar();
            holidayRule.setHolidayCalendar(holidayCalendar);
            holidayRule.setName(this.nameField.getText());
        }
        catch (Throwable t) {
            MessageDialog.showError((Throwable)t);
        }
    }

    protected void objectToEditor() {
        HolidayRule holiday = (HolidayRule)this.getProjectObject();
        this.nameField.setText(holiday.getName());
        HolidayCalendar holidayCalendar = holiday.getHolidayCalendar();
        this.assignedHolidays.clearItems();
        if (holidayCalendar != null) {
            this.assignedHolidays.setItems(holidayCalendar.getHolidays());
        }
        this.assignedHolidays.setHolidayRule(holiday);
    }

    @Override
    protected void buildUI(UiContainer parent) {
        Label nameLabel = Label.create((UiContainer)parent, (Msg)ProjectDrawMsg.NAME);
        this.nameField = new TextField(parent, LENGTH_TEXT);
        this.assignedHolidays = new AssignedHolidays(parent);
        this.appendRow(nameLabel, (UiComponent)this.nameField);
        this.add((UiComponent)this.assignedHolidays, "spanx, wrap, grow");
    }
}

