/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.organization;

import oracle.bpm.designer.EditorType;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.organization.AssignedGroups;
import oracle.bpm.designer.organization.AssignedRoles;
import oracle.bpm.designer.organization.OrganizationBasePanel;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.extensionpoint.metadata.Editor;
import oracle.bpm.project.model.organization.AssignableToGroup;
import oracle.bpm.project.model.organization.AssignableToRole;
import oracle.bpm.project.model.organization.Group;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.ScrollPolicy;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.text.TextArea;
import oracle.bpm.ui.text.TextField;

@Editor(objectClass=Group.class)
public class GroupPanel
extends OrganizationBasePanel<Group> {
    private AssignedGroups assignedGroups;
    private AssignedRoles assignedRoles;
    private TextArea descriptionArea;
    private TextField nameField;

    public GroupPanel(UiContainer parent, Group group) {
        super(parent, group.getOrganization(), group, Group.class);
        assert (group != null);
    }

    public Image getIcon() {
        return Image.create((Msg)DesignerMsg.GROUPS);
    }

    public EditorType getEditorType() {
        return EditorType.GROUP;
    }

    public void focusGained() {
        this.descriptionArea.requestFocus();
    }

    protected void editorToObject() {
        Group.Mutable group = ((Group)this.getProjectObject()).asMutable();
        group.setDescription(this.descriptionArea.getText());
        this.assignedRoles.addRolesAssigned((AssignableToRole)group);
        this.assignedGroups.addGroupsAssigned((AssignableToGroup)group);
    }

    protected void objectToEditor() {
        Group group = (Group)this.getProjectObject();
        this.nameField.setText(group.getId());
        this.nameField.setEnabled(false);
        this.descriptionArea.setText(group.getDescription());
        this.descriptionArea.requestFocus();
        this.assignedGroups.setGroupAssignment(group.getGroupAssignments(group));
        this.assignedRoles.setRoleAssignment(group.getRoleAssignments());
    }

    @Override
    protected void buildUI(UiContainer parent) {
        Label nameLabel = Label.create((UiContainer)parent, (Msg)ProjectDrawMsg.NAME);
        this.nameField = new TextField(parent, LENGTH_TEXT);
        Label descriptionLabel = Label.create((UiContainer)parent, (Msg)DesignerMsg.DESCRIPTION);
        this.descriptionArea = new TextArea(parent, ScrollPolicy.AS_NEEDED, ScrollPolicy.NEVER);
        this.descriptionArea.setRows(3);
        this.descriptionArea.setColumns(LENGTH_TEXT);
        this.assignedGroups = new AssignedGroups(parent, ((Group)this.getProjectObject()).getId(), DesignerMsg.ASSIGN_GROUP_TO_GROUP, ((Group)this.getProjectObject()).getOrganization());
        this.assignedRoles = new AssignedRoles(parent, DesignerMsg.ASSIGN_ROLE_TO_GROUP, (AssignableToRole)this.getProjectObject());
        this.appendRow(nameLabel, (UiComponent)this.nameField);
        this.appendRow(descriptionLabel, this.descriptionArea);
        this.appendRow((UiComponent)this.assignedRoles);
        this.appendRow((UiComponent)this.assignedGroups);
    }
}

