/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.organization;

import java.util.ArrayList;
import oracle.bpm.designer.catalog.bpmobjects.attributes.ComponentEditorProvider;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.Kind;
import oracle.bpm.lang.Time;
import oracle.bpm.lang.TimeFormatException;
import oracle.bpm.project.ProjectVariableImpl;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.editors.AbstractCellEditor;
import oracle.bpm.ui.event.Editable;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.table.editors.TableCellEditor;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.text.TimeField;

class DynamicEditor
extends Panel
implements Editable {
    private CardLayout cardLayout;
    private UiComponent[] editors;
    private int kind;
    private ArrayList<ModificationListener> modificationListeners = new ArrayList();
    private int oldKind;
    private static final int[] VALID_KINDS = ProjectVariableImpl.VALID_KINDS;

    DynamicEditor(UiContainer parent, int defaultKind) {
        super(parent);
        this.init((UiContainer)this);
        this.setKind(defaultKind);
        UiUtilities.addToEditableContainer((Editable)this, (UiContainer)parent);
    }

    public static String getValue(int kind, UiComponent editor) {
        String value = "";
        if (kind == 6) {
            TimeField timeField = (TimeField)editor;
            Time time = timeField.getTime();
            value = time != null ? time.toString() : Time.now().toString();
        } else if (kind == 1) {
            ComboBox checkBox = (ComboBox)editor;
            value = ((Boolean)checkBox.getSelectedItem()).toString();
        } else {
            TextField textField = (TextField)editor;
            value = textField.getText();
        }
        return value;
    }

    public void setKind(int kind) {
        this.kind = kind;
        this.cardLayout.show((UiContainer)this, Kind.getName(kind));
        this.fireChanged(this.kind);
    }

    public void setValue(String value) {
        int kind = this.getKind();
        UiComponent editor = this.getEditor(kind);
        if (kind == 6) {
            TimeField timeField = (TimeField)editor;
            Time time = null;
            try {
                time = Time.valueOf(value);
            }
            catch (TimeFormatException e) {
                // empty catch block
            }
            timeField.setTime(time != null ? time : Time.now());
        } else if (kind == 1) {
            ComboBox comboBox = (ComboBox)editor;
            comboBox.setSelectedItem((Object)Boolean.valueOf(value));
        } else {
            TextField textField = (TextField)editor;
            textField.setText(value);
        }
        this.cardLayout.show((UiContainer)this, Kind.getName(kind));
    }

    public String getValue() {
        return DynamicEditor.getValue(this.getKind(), this.editors[DynamicEditor.getIndex(this.kind)]);
    }

    public void addModificationListener(ModificationListener listener) {
        this.modificationListeners.add(listener);
    }

    public boolean isModified() {
        return !Any.equals(this.oldKind, this.kind);
    }

    public void removeModificationListener(ModificationListener listener) {
        this.modificationListeners.remove(listener);
    }

    public void resetModified() {
        this.oldKind = this.kind;
    }

    private static int getIndex(int kind) {
        for (int i = 0; i < VALID_KINDS.length; ++i) {
            if (kind != VALID_KINDS[i]) continue;
            return i;
        }
        return 0;
    }

    private UiComponent getEditor(int kind) {
        UiComponent editor = this.editors[DynamicEditor.getIndex(kind)];
        return editor;
    }

    private int getKind() {
        return this.kind;
    }

    private void init(UiContainer parent) {
        this.cardLayout = new CardLayout();
        this.setLayout((Layout)this.cardLayout);
        this.editors = new UiComponent[VALID_KINDS.length];
        for (int i = 0; i < VALID_KINDS.length; ++i) {
            int kind = VALID_KINDS[i];
            this.editors[i] = ComponentEditorProvider.getEditor(parent, kind, Kind.getInitialValue(kind));
            parent.add(this.editors[i], (Object)Kind.getName(kind));
        }
    }

    private void fireChanged(int kind) {
        ItemEvent itemEvent = new ItemEvent((Object)this.getEditor(kind), (Object)this.getValue(), true);
        for (ModificationListener modificationListener : this.modificationListeners) {
            modificationListener.objectModified(new ModificationEvent<DynamicEditor>(this, null, itemEvent.getItem()));
        }
    }

    static class CellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private UiComponent editor;
        private int kind;

        CellEditor() {
        }

        public Object getCellEditorValue() {
            return DynamicEditor.getValue(this.getKind(), this.editor);
        }

        public void setKind(int kind) {
            this.kind = kind;
        }

        public UiComponent getTableCellEditor(Table table, Object value, boolean isSelected, int rowIndex, int vColIndex) {
            return this.createEditor((UiContainer)table, value);
        }

        public UiComponent createEditor(UiContainer parent, Object value) {
            int kind = this.getKind();
            this.editor = ComponentEditorProvider.getEditor(parent, kind, (String)value);
            return this.editor;
        }

        private int getKind() {
            return this.kind;
        }
    }
}

