/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.organization;

import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.designer.action.organization.NewCalendarRuleAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.organization.CalendarPanel;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.CalendarRule;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ListSelectionEvent;
import oracle.bpm.ui.event.ListSelectionListener;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.table.BaseTablePanel;
import oracle.bpm.ui.table.ProviderTableModel;

public class CalendarRulesPanel
extends Panel {
    private CalendarPanel calendarPanel;
    private ModificationListener calendarPanelModificationListener;
    private Panel calendarRuleDetailPanel;
    private CardLayout crDetailPanelCardLayout;
    private Organization organization;
    private static final String NO_CALENDAR_RULE_PANEL = "noCalendarRulePanel";
    private static final String CALENDAR_PANEL = "calendarPanel";

    public CalendarRulesPanel(UiContainer parent, Organization organization) {
        super(parent);
        this.organization = organization;
        this.buildUi();
    }

    public void removeListener() {
        this.calendarPanel.removeListener();
    }

    private void buildUi() {
        this.setLayout((Layout)new MigLayout("fill, gap 5, ins 5, wrap 1"));
        CalendarRulesTableModel calendarRulesTableModel = new CalendarRulesTableModel(this.organization.getCalendarRules());
        CalendarRulesTablePanel calendarRulesTablePanel = new CalendarRulesTablePanel((UiContainer)this, calendarRulesTableModel);
        Panel calendarRulePanel = this.buildCalendarRuleDetailPanel((UiContainer)this);
        this.add((UiComponent)calendarRulesTablePanel, "growx, growy 30");
        this.add((UiComponent)calendarRulePanel, "growx, growy 70");
    }

    private Panel buildCalendarRuleDetailPanel(UiContainer parent) {
        this.crDetailPanelCardLayout = new CardLayout();
        this.calendarRuleDetailPanel = new Panel(parent, DesignerMsg.CALENDAR);
        this.calendarRuleDetailPanel.setLayout((Layout)this.crDetailPanelCardLayout);
        Panel noCalendarRulePanel = new Panel((UiContainer)this.calendarRuleDetailPanel);
        noCalendarRulePanel.setLayout((Layout)new BorderLayout());
        noCalendarRulePanel.add((UiComponent)Label.createWithNoColon((UiContainer)noCalendarRulePanel, (Msg)DesignerMsg.NO_CALENDAR_SELECTED), (Object)"Center");
        this.calendarPanel = new CalendarPanel((UiContainer)this.calendarRuleDetailPanel, this.organization, null);
        this.calendarPanel.addModificationListener(this.getCalendarPanelModificationListener());
        this.calendarRuleDetailPanel.add((UiComponent)noCalendarRulePanel, (Object)NO_CALENDAR_RULE_PANEL);
        this.calendarRuleDetailPanel.add((UiComponent)this.calendarPanel, (Object)CALENDAR_PANEL);
        this.crDetailPanelCardLayout.show((UiContainer)this.calendarRuleDetailPanel, NO_CALENDAR_RULE_PANEL);
        return this.calendarRuleDetailPanel;
    }

    private ModificationListener getCalendarPanelModificationListener() {
        if (this.calendarPanelModificationListener == null) {
            this.calendarPanelModificationListener = new ModificationListener(){

                public void objectModified(ModificationEvent event) {
                    CalendarRulesPanel.this.calendarPanel.editorToObject();
                }
            };
        }
        return this.calendarPanelModificationListener;
    }

    private class CalendarRulesTablePanel
    extends BaseTablePanel {
        public CalendarRulesTablePanel(UiContainer parent, ProviderTableModel<CalendarRule> calendarRulesTableModel) {
            super(parent, DesignerMsg.CALENDARS_ICON, null, calendarRulesTableModel);
            this.getTable().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    int[] selectedRows = CalendarRulesTablePanel.this.getTable().getSelectedRows();
                    if (selectedRows.length == 1) {
                        CalendarRulesPanel.this.calendarPanel.removeModificationListener(CalendarRulesPanel.this.getCalendarPanelModificationListener());
                        CalendarRule calendarRule = (CalendarRule)CalendarRulesTablePanel.this.getModel().getRow(selectedRows[0]);
                        CalendarRulesPanel.this.calendarPanel.setProjectObject(calendarRule);
                        CalendarRulesPanel.this.calendarPanel.objectToEditor();
                        CalendarRulesPanel.this.crDetailPanelCardLayout.show((UiContainer)CalendarRulesPanel.this.calendarRuleDetailPanel, CalendarRulesPanel.CALENDAR_PANEL);
                        CalendarRulesPanel.this.calendarPanel.addModificationListener(CalendarRulesPanel.this.getCalendarPanelModificationListener());
                    } else {
                        CalendarRulesPanel.this.crDetailPanelCardLayout.show((UiContainer)CalendarRulesPanel.this.calendarRuleDetailPanel, CalendarRulesPanel.NO_CALENDAR_RULE_PANEL);
                    }
                }
            });
        }

        protected void addAction() {
            NewCalendarRuleAction action = new NewCalendarRuleAction(CalendarRulesPanel.this.organization, false);
            action.run();
            CalendarRule object = (CalendarRule)action.getObjectAdded();
            if (object != null) {
                this.getModel().addRow((Object)object);
            }
        }

        protected void deleteAction() {
            try {
                for (int row : this.getTable().getSelectedRows()) {
                    CalendarRule rule = (CalendarRule)((CalendarRulesTableModel)this.getModel()).getRow(row);
                    CalendarRulesPanel.this.organization.removeChild((ProjectObject)rule);
                }
                super.deleteAction();
            }
            catch (ProjectException e) {
                e.printStackTrace();
                MessageDialog.showError((Throwable)e);
            }
        }
    }

    private class CalendarRulesTableModel
    extends ProviderTableModel<CalendarRule> {
        public CalendarRulesTableModel(Iterable<CalendarRule> calendarRules) {
            super(MsgList.create(DesignerMsg.NAME));
            this.addRows(calendarRules);
        }

        public Object getValueAt(int row, int column) {
            return ((CalendarRule)this.getRow(row)).getName();
        }
    }
}

