/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.bpm.collections.Predicate;
import oracle.bpm.designer.ProjectNavigatorTree;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.navigator.NavigatorActions;
import oracle.bpm.draw.Color;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.lang.Bool;
import oracle.bpm.lang.Cast;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.view.filter.ProjectFilter;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.BorderPanel;
import oracle.bpm.ui.ColorProvider;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.TreeSelectionMode;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.KeyAdapter;
import oracle.bpm.ui.event.KeyEvent;
import oracle.bpm.ui.event.KeyListener;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.event.TreeSelectionEvent;
import oracle.bpm.ui.event.TreeSelectionListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.selection.DefaultSelection;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.tree.TreeNode;
import oracle.bpm.ui.tree.TreePath;
import org.jetbrains.annotations.Nullable;

public class ProjectNavigatorDialog
extends OkCancelDialog
implements NavigatorActions {
    private List<BaseAction> actions = Collections.emptyList();
    private boolean canSelectRoot;
    private Bool.Holder enableEvents;
    private Predicate<ProjectObject> expectedSelection = new Predicate<ProjectObject>(){

        @Override
        public boolean check(@Nullable ProjectObject value) {
            return true;
        }
    };
    private List<TreeNode> matchingSearchNodes = Collections.emptyList();
    private ModuleNavigatorTree navigatorTree;
    private ProjectObject root;
    private TextField searchField;
    private TreeSelectionMode selectionMode = TreeSelectionMode.SINGLE_TREE_SELECTION;
    private Label statusField;

    ProjectNavigatorDialog(UiWindow parent, Msg msg, ProjectObject root, ProjectFilter filter, boolean rootVisible, List<BaseAction> actions) {
        super(parent, msg, true);
        this.okButton.setEnabled(false);
        this.actions = actions;
        this.build(root, rootVisible, filter);
        this.setSize(350, 450);
        this.setLocationRelativeTo((UiComponent)parent);
    }

    public String getHelpId() {
        return this.getHelpIdWithMsg();
    }

    public void setCanSelectRoot(boolean b) {
        this.canSelectRoot = b;
    }

    @Override
    public void refresh() {
        this.refreshTree();
    }

    public void ok() {
        if (this.isSelectionOk()) {
            this.setUserAccepted(true);
            this.getNavigatorTree().removeListener();
            this.close();
        } else {
            this.setUserAccepted(false);
        }
    }

    public <T extends ProjectObject> T selectSingle(Class<T> expectedClass) {
        return this.selectSingle(expectedClass, null);
    }

    public <T extends ProjectObject> T selectSingle(final Class<T> expectedClass, final Predicate<T> predicate) {
        this.setSelectionMode(TreeSelectionMode.SINGLE_TREE_SELECTION);
        this.setExpectedSelection(new Predicate<ProjectObject>(){

            @Override
            public boolean check(@Nullable ProjectObject value) {
                return expectedClass.isInstance(value) && (predicate == null || predicate.check(expectedClass.cast(value)));
            }
        });
        this.setVisible(true);
        TreeNode[] selectedNodes = this.getSelectedTreeNode();
        Object object = selectedNodes.length > 0 ? selectedNodes[0].getUserObject() : null;
        return (T)(expectedClass.isInstance(object) ? (ProjectObject)expectedClass.cast(object) : null);
    }

    public <T extends ProjectObject> Collection<T> selectMultiple(Class<T> expectedClass) {
        return this.selectMultiple(expectedClass, null);
    }

    public <T extends ProjectObject> Collection<T> selectMultiple(final Class<T> expectedClass, final Predicate<T> predicate) {
        this.setSelectionMode(TreeSelectionMode.SINGLE_TREE_SELECTION);
        this.setExpectedSelection(new Predicate<ProjectObject>(){

            @Override
            public boolean check(@Nullable ProjectObject value) {
                return expectedClass.isInstance(value) && (predicate == null || predicate.check(expectedClass.cast(value)));
            }
        });
        this.setVisible(true);
        TreeNode[] selectedNodes = this.getSelectedTreeNode();
        ArrayList<T> result = new ArrayList<T>();
        for (TreeNode selectedNode : selectedNodes) {
            if (!expectedClass.isInstance(selectedNode.getUserObject())) continue;
            result.add(expectedClass.cast(selectedNode.getUserObject()));
        }
        return result;
    }

    protected ToolBar buildToolBarPanel(UiContainer parent, List<BaseAction> actions, NavigatorActions navigatorActions) {
        ToolBar toolBar = null;
        if (!actions.isEmpty()) {
            toolBar = new ToolBar(parent);
            for (BaseAction action : actions) {
                toolBar.add(action);
            }
        }
        return toolBar;
    }

    void select(ProjectObject projectObject) {
        TreeNode node = this.getNavigatorTree().findNode(projectObject);
        if (node != null) {
            node.select();
            TreeNode parent = node.getParent();
            if (parent != null) {
                parent.expand();
            }
        }
    }

    private ProjectObject getRoot() {
        return this.root;
    }

    private ModuleNavigatorTree getNavigatorTree() {
        return this.navigatorTree;
    }

    private TreeNode[] getSelectedTreeNode() {
        return this.userAccepted() ? this.getNavigatorTree().getSelectedTreeNodes() : new TreeNode[]{};
    }

    private UiComponent buildSearchPanel(UiContainer parent, final ProjectNavigatorTree tree) {
        Panel searchPanel = new Panel(parent);
        searchPanel.setLayout((Layout)new BorderLayout());
        this.searchField = new TextField((UiContainer)searchPanel, 14);
        searchPanel.add((UiComponent)Label.create((UiContainer)searchPanel, (Msg)UIMsg.SEARCH), (Object)"North");
        searchPanel.add((UiComponent)this.searchField, (Object)"Center");
        this.enableEvents = new Bool.Holder(true);
        this.searchField.addModificationListener(new ModificationListener(){

            public void objectModified(ModificationEvent modificationEvent) {
                ProjectNavigatorDialog.this.refreshTree();
            }
        });
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                String text;
                TreeNode node;
                if (((ProjectNavigatorDialog)ProjectNavigatorDialog.this).enableEvents.value) {
                    ProjectNavigatorDialog.this.searchField.setText("");
                }
                if ((node = tree.getSelectedNode()) != null) {
                    ProjectObject po = (ProjectObject)node.getUserObject();
                    text = String.valueOf(po.getPath());
                } else {
                    text = " ";
                }
                ProjectNavigatorDialog.this.statusField.setText(text);
                for (BaseAction action : ProjectNavigatorDialog.this.actions) {
                    action.setSelection(DefaultSelection.createSingle((Object)node));
                }
            }
        });
        this.searchField.addKeyListener((KeyListener)new UpDownKeyListener(this.enableEvents));
        LabelProvider labelDelegate = (LabelProvider)Cast.force(tree.getLabelProvider());
        tree.setLabelProvider(new NavigatorLabelProvider((LabelProvider<TreeNode>)labelDelegate, this.searchField));
        ColorProvider colorDelegate = (ColorProvider)Cast.force(tree.getColorProvider());
        tree.setColorProvider(new NavigatorColorProvider((ColorProvider<TreeNode>)colorDelegate));
        return searchPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshTree() {
        String text = this.searchField.getText();
        text = text.trim();
        try {
            ModuleNavigatorTree tree = this.getNavigatorTree();
            this.enableEvents.value = false;
            this.getNavigatorTree().getRoot().unload();
            tree.reload();
            this.searchField.setForeground(Color.BLACK);
            this.matchingSearchNodes = Collections.emptyList();
            if (text.length() > 0) {
                boolean multiple = this.selectionMode != TreeSelectionMode.SINGLE_TREE_SELECTION;
                this.matchingSearchNodes = tree.findAndSelect(text, multiple, this.expectedSelection);
                if (this.matchingSearchNodes.isEmpty()) {
                    this.searchField.setForeground(Color.RED);
                }
            } else {
                tree.setSelectionRow(-1);
            }
        }
        finally {
            this.enableEvents.value = true;
        }
    }

    private void setSelectionMode(TreeSelectionMode selectionMode) {
        this.selectionMode = selectionMode;
        if (this.navigatorTree != null) {
            this.navigatorTree.setSelectionMode(selectionMode);
        }
    }

    private void setExpectedSelection(Predicate<ProjectObject> expectedSelection) {
        this.expectedSelection = expectedSelection;
    }

    private boolean isSelectionOk() {
        if (!this.isValidSelection()) {
            MessageDialog.showError((Msg)DesignerMsg.NO_ROW_SELECTED);
            return false;
        }
        return true;
    }

    private boolean isValidSelection() {
        boolean valid = true;
        TreeNode[] nodes = this.getNavigatorTree().getSelectedTreeNodes();
        if (nodes.length == 0) {
            valid = false;
        } else {
            for (TreeNode node : nodes) {
                if (!this.isExpectedSelection(node.getUserObject())) {
                    valid = false;
                    break;
                }
                if (this.canSelectRoot || node != this.getRoot()) continue;
                valid = false;
                break;
            }
        }
        return valid;
    }

    private void build(ProjectObject root, boolean rootVisible, ProjectFilter filter) {
        this.root = root;
        UiContainer mainPanel = this.getContentPane();
        BorderPanel container = new BorderPanel(mainPanel);
        container.setLayout((Layout)new BorderLayout(5, 5));
        Panel treePanel = this.buildTreePanel((UiContainer)container, rootVisible, filter);
        Panel statusPanel = this.buildStatusPanel((Panel)container);
        Panel northPanel = new Panel((UiContainer)container);
        northPanel.setLayout((Layout)new BorderLayout());
        UiComponent searchPanel = this.buildSearchPanel((UiContainer)northPanel, this.getNavigatorTree());
        northPanel.add(searchPanel, (Object)"North");
        ToolBar toolbar = this.buildToolBarPanel((UiContainer)northPanel, this.actions, this);
        if (toolbar != null) {
            northPanel.add((UiComponent)toolbar, (Object)"South");
        }
        container.add((UiComponent)northPanel, (Object)"North");
        container.add((UiComponent)treePanel, (Object)"Center");
        container.add((UiComponent)statusPanel, (Object)"South");
        mainPanel.add((UiComponent)container, (Object)"Center");
        this.pack();
    }

    private Panel buildTreePanel(UiContainer container, boolean rootVisible, ProjectFilter filter) {
        Panel panel = new Panel(container);
        panel.setLayout((Layout)new BorderLayout());
        this.navigatorTree = new ModuleNavigatorTree(container, this.getRoot(), filter, rootVisible);
        this.navigatorTree.setSelectionMode(this.selectionMode);
        this.navigatorTree.setShowMenues(false);
        this.navigatorTree.setPopupEnabled(false);
        this.navigatorTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                ProjectNavigatorDialog.this.okButton.setEnabled(ProjectNavigatorDialog.this.isValidSelection());
            }
        });
        panel.add((UiComponent)this.navigatorTree, (Object)"Center");
        return panel;
    }

    private Panel buildStatusPanel(Panel container) {
        Panel panel = new Panel((UiContainer)container);
        panel.setLayout((Layout)new BorderLayout());
        this.statusField = Label.create((UiContainer)container);
        this.statusField.setForeground(Color.GRAY);
        this.statusField.setText(" ");
        panel.add((UiComponent)this.statusField, (Object)"Center");
        return panel;
    }

    private boolean isExpectedSelection(Object element) {
        return element instanceof ProjectObject && this.expectedSelection.check((ProjectObject)element);
    }

    private class UpDownKeyListener
    extends KeyAdapter {
        private final Bool.Holder enableEvents;

        public UpDownKeyListener(Bool.Holder enableEvents) {
            this.enableEvents = enableEvents;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void keyReleased(KeyEvent e) {
            List nodes;
            if ((e.isAnyDown() || e.isUp()) && !(nodes = ProjectNavigatorDialog.this.matchingSearchNodes).isEmpty()) {
                TreeNode nextNode = null;
                TreeNode node = ProjectNavigatorDialog.this.getNavigatorTree().getSelectedNode();
                int index = nodes.indexOf(node);
                if (index != -1) {
                    int nextIndex;
                    if (e.isUp()) {
                        nextIndex = index - 1;
                        if (nextIndex == -1) {
                            nextIndex = nodes.size() - 1;
                        }
                    } else {
                        nextIndex = (index + 1) % nodes.size();
                    }
                    nextNode = (TreeNode)nodes.get(nextIndex);
                }
                if (nextNode == null) {
                    nextNode = (TreeNode)nodes.get(0);
                }
                try {
                    this.enableEvents.value = false;
                    nextNode.select();
                    TreeNode parent = nextNode.getParent();
                    if (!parent.isExpanded()) {
                        parent.expand();
                    }
                }
                finally {
                    this.enableEvents.value = true;
                }
            }
            e.consume();
        }
    }

    private class NavigatorColorProvider
    implements ColorProvider<TreeNode> {
        private final ColorProvider<TreeNode> colorDelegate;

        public NavigatorColorProvider(ColorProvider<TreeNode> colorDelegate) {
            this.colorDelegate = colorDelegate;
        }

        public Color getBackground(TreeNode element) {
            return this.colorDelegate.getBackground((Object)element);
        }

        public Color getForeground(TreeNode element) {
            List nodes = ProjectNavigatorDialog.this.matchingSearchNodes;
            Color result = !ProjectNavigatorDialog.this.isExpectedSelection(element.getUserObject()) ? Color.GRAY : (!nodes.isEmpty() && !nodes.contains(element) ? Color.GRAY : this.colorDelegate.getForeground((Object)element));
            return result;
        }
    }

    private class ModuleNavigatorTree
    extends ProjectNavigatorTree {
        public ModuleNavigatorTree(UiContainer parent, ProjectObject root, ProjectFilter filter, boolean rootVisible) {
            super(parent, root, filter, rootVisible);
            this.getProject().addListener(this.getProjectListener());
        }

        public void removeListener() {
            this.getProject().removeListener(this.getProjectListener());
        }

        @Override
        public boolean showProjectInherited() {
            return true;
        }

        @Override
        protected void doubleClick(MouseEvent e) {
            TreePath path = this.getPathForLocation(e.getX(), e.getY());
            if (path != null) {
                this.setSelectionPath(path);
                ProjectNavigatorDialog.this.ok();
            }
        }

        @Override
        protected void enterPressed() {
            ProjectNavigatorDialog.this.ok();
        }
    }

    private static class NavigatorLabelProvider
    implements LabelProvider<TreeNode> {
        private final LabelProvider<TreeNode> labelDelegate;
        private final TextField searchField;

        public NavigatorLabelProvider(LabelProvider<TreeNode> labelDelegate, TextField searchField) {
            this.labelDelegate = labelDelegate;
            this.searchField = searchField;
        }

        public Image getIcon(TreeNode element) {
            return this.labelDelegate.getIcon((Object)element);
        }

        public String getText(TreeNode element) {
            int start;
            String text = this.labelDelegate.getText((Object)element);
            boolean addHtml = false;
            String searchText = this.searchField.getText();
            if (searchText.length() > 0 && (start = text.toLowerCase().indexOf(searchText.toLowerCase())) != -1) {
                addHtml = true;
                int end = start + searchText.length();
                String left = text.substring(0, start);
                String match = text.substring(start, end);
                String right = text.substring(end);
                text = left + "<b><u>" + match + "</u></b>" + right;
            }
            if (addHtml) {
                text = "<html>" + text + "</html>";
            }
            return text;
        }
    }
}

