/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.measurementmark;

import oracle.bpm.adapter.Adaptable;
import oracle.bpm.designer.action.ChangeMeasurementTargetAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.extensionpoint.metadata.ActionGroupMetadata;
import oracle.bpm.lang.Any;
import oracle.bpm.project.command.msg.ProjectCommandMsg;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.action.ActionGroupFactory;
import oracle.bpm.ui.action.BaseAction;
import org.jetbrains.annotations.NotNull;

@ActionGroupMetadata(target=Measurement.class)
public class MeasurementTargetFlowAction
extends ActionGroup
implements ActionGroupFactory {
    public MeasurementTargetFlowAction() {
        super(ProjectCommandMsg.CHANGE_TARGET_TRANSITION);
        this.requires(Measurement.class);
        this.setShowOnDisabled(false);
    }

    public ActionGroup create(Adaptable context) {
        MeasurementTargetFlowAction group = new MeasurementTargetFlowAction();
        group.build(context.as(Measurement.class));
        return group;
    }

    private void build(@NotNull Measurement measurement) {
        ActionGroup result;
        ActionGroup currentAction = result = new ActionGroup(ProjectCommandMsg.CHANGE_TARGET_TRANSITION);
        int i = 0;
        Process container = measurement.getProcess();
        SequenceFlow currentTransition = measurement.getTransition();
        for (SequenceFlow sequenceFlow : container.getDescendants(SequenceFlow.class)) {
            if (Any.equals(sequenceFlow, currentTransition)) continue;
            if (i > 10) {
                ActionGroup moreActions = new ActionGroup(DesignerMsg.MORE);
                currentAction.addSeparator();
                currentAction.add((BaseAction)moreActions);
                currentAction = moreActions;
                i = 0;
            }
            currentAction.add((BaseAction)new ChangeMeasurementTargetAction(sequenceFlow));
            ++i;
        }
        this.add((BaseAction)result);
    }
}

