/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.measurementmark;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.collections.Tuple;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.designer.ProjectObjectEditorPanel;
import oracle.bpm.designer.action.NewBusinessIndicatorAction;
import oracle.bpm.designer.measurementmark.BusinessIndicatorsLabelProvider;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.events.ProjectListenerAdapter;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Counter;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.selection.DefaultSelection;
import oracle.bpm.ui.table.AbstractTableModel;
import oracle.bpm.ui.table.BaseTablePanel;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class CounterPropertiesPanel
extends ProjectObjectEditorPanel<Counter> {
    private ProjectListenerAdapter<ProjectDataObject> listener;
    private BusinessIndicatorTableModel tableModel;
    private static final int ASSIGNED_COLUMN = 0;
    private static final int BUSINESS_OBJECT_COLUMN = 1;

    public CounterPropertiesPanel(UiContainer parent, Counter counter) {
        super(parent, counter);
        this.build();
        this.addProjectDataObjectListener();
    }

    @Override
    public void objectToEditor(Counter counter) {
        this.reloadTable(counter);
    }

    @Override
    public Counter editorToObject() throws ProjectException {
        Counter counter = (Counter)this.getProjectObject();
        this.tableModel.tableToObject(counter);
        return counter;
    }

    @Override
    public void validatePanel() throws ProjectException {
    }

    protected void onDispose() {
        this.removeProjectDataObjectListener();
    }

    private void build() {
        this.setLayout((Layout)new MigLayout("fill, ins 0, gap 0"));
        Panel panel = this.buildTablePanel();
        this.add((UiComponent)panel, "grow, height 200::");
    }

    private Panel buildTablePanel() {
        this.tableModel = new BusinessIndicatorTableModel();
        return new BusinessIndicatorTable((UiContainer)this);
    }

    private void reloadTable(Counter counter) {
        if (counter != null) {
            this.tableModel.objectToTable(counter);
        }
    }

    private void addProjectDataObjectListener() {
        this.listener = new ProjectListenerAdapter<ProjectDataObject>(ProjectDataObject.class){

            public void postObjectAdded(ProjectDataObject object, ProjectObject parent) {
                CounterPropertiesPanel.this.reloadTable((Counter)CounterPropertiesPanel.this.getProjectObject());
            }
        };
        ((Counter)this.getProjectObject()).getProject().addListener(this.listener);
    }

    private void removeProjectDataObjectListener() {
        ((Counter)this.getProjectObject()).getProject().removeListener(this.listener);
    }

    private class BusinessIndicatorTableModel
    extends AbstractTableModel {
        private final MsgList columns;
        private List<Tuple<Boolean, ProjectDataObject>> rows = new ArrayList<Tuple<Boolean, ProjectDataObject>>();
        private boolean update = true;

        private BusinessIndicatorTableModel() {
            this.columns = MsgList.create(Msg.QUOTE("Assigned"), DesignerMsg.BUSINESS_INDICATOR);
        }

        public void objectToTable(@NotNull Counter counter) {
            if (this.update) {
                for (ProjectDataObject object : counter.getProject().getProjectDataObjects()) {
                    if (!object.isBusiness() || !object.getBusinessVariableType().isCounter()) continue;
                    this.setDataObject(object, counter.contains((ProjectObject)object));
                }
                this.fireTableDataChanged();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void tableToObject(@NotNull Counter counter) throws ProjectException {
            try {
                this.update = false;
                for (Tuple<Boolean, ProjectDataObject> row : this.rows) {
                    ProjectDataObject object = row.getSecond();
                    if (row.getFirst().booleanValue()) {
                        if (counter.contains((ProjectObject)object)) continue;
                        counter.addBusinessIndicator(object);
                        continue;
                    }
                    if (!counter.contains((ProjectObject)object)) continue;
                    counter.removeChild((ProjectObject)object);
                }
            }
            finally {
                this.update = true;
            }
        }

        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }

        public Object getValueAt(int row, int column) {
            return column == 0 ? this.rows.get(row).getFirst() : this.rows.get(row).getSecond();
        }

        public void setValueAt(Object value, int row, int column) {
            if (column == 0) {
                this.rows.set(row, Tuple.create((Boolean)value, this.rows.get(row).getSecond()));
            }
        }

        public int getColumnCount() {
            return this.columns.size();
        }

        public int getRowCount() {
            return this.rows.size();
        }

        public Class getColumnClass(int column) {
            return column == 0 ? Boolean.class : ProjectDataObject.class;
        }

        public String getColumnName(int column) {
            Msg msg = (Msg)this.columns.get(column);
            return msg != null ? msg.getString() : "";
        }

        private void setDataObject(@NotNull ProjectDataObject object, boolean assigned) {
            Tuple<Boolean, ProjectDataObject> value = Tuple.create(assigned, object);
            int index = this.indexOf(object);
            if (index != -1) {
                if (this.rows.get(index).getFirst() != assigned) {
                    this.rows.set(index, value);
                }
            } else {
                this.rows.add(value);
            }
        }

        private int indexOf(@NotNull ProjectDataObject object) {
            int result = -1;
            int length = this.getRowCount();
            for (int row = 0; row < length; ++row) {
                if (!this.getValueAt(row, 1).equals(object)) continue;
                result = row;
                break;
            }
            return result;
        }
    }

    private class BusinessIndicatorTable
    extends BaseTablePanel {
        public BusinessIndicatorTable(UiContainer parent) {
            super(parent, null, null, (TableModel)CounterPropertiesPanel.this.tableModel, BaseTablePanel.Style.TOOLBAR_TOP);
            this.init();
        }

        protected void addAction() {
            NewBusinessIndicatorAction action = NewBusinessIndicatorAction.createForCounter();
            Process process = ((Counter)CounterPropertiesPanel.this.getProjectObject()).getProject().getProjectModel();
            action.runWithSelection(DefaultSelection.createSingle((Object)process));
        }

        protected boolean showRemoveAction() {
            return false;
        }

        private void init() {
            Table table = this.getTable();
            table.getColumn(0).setResizable(false);
            table.getColumn(0).setWidth(25);
            table.getColumn(1).setLabelProvider((LabelProvider)new BusinessIndicatorsLabelProvider());
        }
    }
}

