/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.importer.visio;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.bpm.designer.importer.visio.VisioGeomElement;

class VisioGeom {
    private final List elements_d = new ArrayList();
    private Integer index_d;
    private String kind_d = "Other";
    private static final VisioGeom[] basicGeoms_sd = new VisioGeom[]{new RectangleGeom(), new EllipseGeom()};
    private static final VisioGeomElement[] relevantElements_sd = new VisioGeomElement[]{VisioGeomElement.MOVE_TO, VisioGeomElement.LINE_TO, VisioGeomElement.ARC_TO, VisioGeomElement.ELLIPTICAL_ARC_TO, VisioGeomElement.POLYLINE_TO, VisioGeomElement.ELLIPSE};
    static final String RECTANGLE_GEOM = "Rectangle";
    static final String ELLIPSE_GEOM = "Ellipse";

    public VisioGeom() {
    }

    public VisioGeom(int index) {
        this();
        this.index_d = index;
    }

    public static boolean isRelevantElement(String name) {
        for (int i = 0; i < relevantElements_sd.length; ++i) {
            if (!relevantElements_sd[i].getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public final VisioGeom getBasicGeom() {
        for (int i = 0; i < basicGeoms_sd.length; ++i) {
            if (!this.equals(basicGeoms_sd[i])) continue;
            return basicGeoms_sd[i];
        }
        return this;
    }

    public final int getIX() {
        return this.index_d;
    }

    public final String getKind() {
        return this.kind_d;
    }

    public final void addElement(VisioGeomElement element) {
        this.elements_d.add(element);
    }

    public final boolean equals(Object obj) {
        if (obj instanceof VisioGeom) {
            VisioGeom geom = (VisioGeom)obj;
            Iterator itThis = this.elements_d.iterator();
            Iterator itGeom = geom.elements_d.iterator();
            while (itThis.hasNext() && itGeom.hasNext()) {
                if (itThis.next().equals(itGeom.next())) continue;
                return false;
            }
            return !itThis.hasNext() && !itGeom.hasNext();
        }
        return false;
    }

    public int hashCode() {
        return this.elements_d != null ? ((Object)this.elements_d).hashCode() : 0;
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Geom: Index: " + this.index_d);
        if (!this.kind_d.equals("Other")) {
            sb.append(" - Kind: " + this.kind_d);
        }
        sb.append(" - Elements: ");
        Iterator it = this.elements_d.iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return new String(sb);
    }

    final void setKind(String kind) {
        this.kind_d = kind;
    }

    static final class EllipseGeom
    extends VisioGeom {
        public EllipseGeom() {
            this.addElement(VisioGeomElement.ELLIPSE);
            this.setKind(VisioGeom.ELLIPSE_GEOM);
        }
    }

    public static final class RectangleGeom
    extends VisioGeom {
        public RectangleGeom() {
            this.addElement(VisioGeomElement.MOVE_TO);
            this.addElement(VisioGeomElement.LINE_TO);
            this.addElement(VisioGeomElement.LINE_TO);
            this.addElement(VisioGeomElement.LINE_TO);
            this.addElement(VisioGeomElement.LINE_TO);
            this.setKind(VisioGeom.RECTANGLE_GEOM);
        }
    }
}

