/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.importer.visio;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.bpm.designer.importer.visio.Drawing;
import oracle.bpm.designer.importer.visio.VisioConnect;
import oracle.bpm.designer.importer.visio.VisioGeom;
import oracle.bpm.designer.importer.visio.VisioGeomElement;
import oracle.bpm.designer.importer.visio.VisioMaster;
import oracle.bpm.designer.importer.visio.VisioProperties;
import oracle.bpm.designer.importer.visio.VisioShape;
import oracle.bpm.designer.importer.visio.VisioXForm;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ImporterException;
import oracle.bpm.project.msg.ProjectMsg;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class Loader
extends DefaultHandler {
    private Drawing drawing_d;
    private VisioGeom geom_d;
    private VisioGeomElement geomElement_d;
    private InputSource inputSource_d;
    private boolean isConnects_d = false;
    private boolean isCoordinate_d = false;
    private boolean isDimension = false;
    private boolean isGeom_d = false;
    private boolean isGeomElement_d = false;
    private boolean isLine_d = false;
    private boolean isMaster_d = false;
    private boolean isNumber_d = false;
    private boolean isProperties_d = false;
    private boolean isShape_d = false;
    private boolean isShapes_d = false;
    private boolean isText_d = false;
    private boolean isXForm_d = false;
    private Map knownTags_d;
    private VisioMaster master_d;
    private VisioProperties properties_d;
    private VisioShape shape_d;
    private StringBuffer textBuffer_d;
    private VisioXForm xForm_d;
    private static final String SHAPES_TAG = "Shapes";
    private static final String SHAPE_TAG = "Shape";
    private static final String CONNECTS_TAG = "Connects";
    private static final String CONNECT_TAG = "Connect";
    private static final String MASTER_TAG = "Master";
    private static final String XFORM_TAG = "XForm";
    private static final String XFORM1D_TAG = "XForm1D";
    private static final String GEOM_TAG = "Geom";
    private static final String LINE_TAG = "Line";
    private static final String TEXT_TAG = "Text";
    private static final String PINX_TAG = "PinX";
    private static final String WIDTH_TAG = "Width";
    private static final String HEIGHT_TAG = "Height";
    private static final String PINY_TAG = "PinY";
    private static final String X_TAG = "X";
    private static final String Y_TAG = "Y";
    private static final String ENDARROW_TAG = "EndArrow";
    private static final String BEGINARROW_TAG = "BeginArrow";
    private static final String DOCUMENTPROPERTIES_TAG = "DocumentProperties";
    private static final String TITLE_TAG = "Title";
    private static final String CREATOR_TAG = "Creator";
    private static final String COMPANY_TAG = "Company";
    private static final String[] KNONW_TAGS = new String[]{"Shapes", "Shape", "Connects", "Connect", "Master", "XForm", "XForm1D", "Geom", "Line", "Text", "PinX", "PinY", "Width", "Height", "X", "Y", "EndArrow", "BeginArrow", "DocumentProperties", "Title", "Creator", "Company"};
    private static final String ID_ATT = "ID";
    private static final String MASTER_ATT = "Master";
    private static final String MASTERSHAPE_ATT = "MasterShape";
    private static final String NAMEU_ATT = "NameU";
    private static final String TYPE_ATT = "ConfigType";
    private static final String FROMSHEET_ATT = "FromSheet";
    private static final String TOSHEET_ATT = "ToSheet";
    private static final String IX_ATT = "IX";

    public Loader(File file, ProjectObject projectObject) throws ImporterException {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
            this.inputSource_d = new InputSource(inputStreamReader);
            this.load(projectObject);
            inputStreamReader.close();
        }
        catch (IOException e) {
            throw new ImporterException(projectObject, ProjectMsg.ERROR_PARSING_DRAWING, (Throwable)e);
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) {
        String s = new String(buf, offset, len);
        if (this.isCoordinate_d || this.isText_d || this.isNumber_d || this.isDimension) {
            this.textBuffer_d.append(s);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) {
        if (!this.isKnownTag(qName)) {
            return;
        }
        if (this.isShape_d) {
            VisioShape shape = this.shape_d;
            if (this.isGeom_d) {
                if (this.isGeomElement_d) {
                    if (qName.equals(X_TAG)) {
                        this.isCoordinate_d = false;
                        this.geomElement_d.setX(Double.parseDouble(new String(this.textBuffer_d)));
                    } else if (qName.equals(Y_TAG)) {
                        this.isCoordinate_d = false;
                        this.geomElement_d.setY(Double.parseDouble(new String(this.textBuffer_d)));
                    } else if (VisioGeom.isRelevantElement(qName)) {
                        this.isGeomElement_d = false;
                        this.geom_d.addElement(this.geomElement_d);
                    }
                } else if (qName.equals(GEOM_TAG)) {
                    this.isGeom_d = false;
                    shape.addGeom(this.geom_d.getIX(), this.geom_d);
                }
            } else if (this.isXForm_d) {
                if (qName.equals(WIDTH_TAG)) {
                    this.isDimension = false;
                    this.xForm_d.setWidth(Double.parseDouble(new String(this.textBuffer_d)));
                } else if (qName.equals(HEIGHT_TAG)) {
                    this.isDimension = false;
                    this.xForm_d.setHeight(Double.parseDouble(new String(this.textBuffer_d)));
                } else if (qName.equals(PINX_TAG)) {
                    this.isCoordinate_d = false;
                    this.xForm_d.setXPin(Double.parseDouble(new String(this.textBuffer_d)));
                } else if (qName.equals(PINY_TAG)) {
                    this.isCoordinate_d = false;
                    this.xForm_d.setYPin(Double.parseDouble(new String(this.textBuffer_d)));
                } else if (qName.equals(XFORM_TAG)) {
                    this.isXForm_d = false;
                    shape.setXForm(this.xForm_d);
                }
            } else if (qName.equals(XFORM1D_TAG)) {
                shape.setHasXForm1D(true);
            } else if (this.isText_d && qName.equals(TEXT_TAG)) {
                this.isText_d = false;
                shape.setText(new String(this.textBuffer_d));
            } else if (qName.equals(SHAPE_TAG)) {
                if (this.shape_d.isChildShape()) {
                    this.shape_d = shape.getParentShape();
                } else {
                    this.isShape_d = false;
                    if (this.isMaster_d) {
                        this.master_d.setShape(this.shape_d);
                    } else {
                        this.drawing_d.addShape(this.shape_d);
                    }
                }
            } else if (this.isLine_d) {
                if (qName.equals(ENDARROW_TAG)) {
                    int arrowType = Integer.parseInt(new String(this.textBuffer_d));
                    shape.setLineEndArrow(arrowType != 0);
                } else if (qName.equals(BEGINARROW_TAG)) {
                    int arrowType = Integer.parseInt(new String(this.textBuffer_d));
                    shape.setLineBeginArrow(arrowType != 0);
                } else if (qName.equals(LINE_TAG)) {
                    this.isLine_d = false;
                }
            }
        } else if (this.isProperties_d) {
            if (qName.equals(TITLE_TAG)) {
                this.isText_d = false;
                this.properties_d.setTitle(new String(this.textBuffer_d));
            } else if (qName.equals(CREATOR_TAG)) {
                this.isText_d = false;
                this.properties_d.setCreator(new String(this.textBuffer_d));
            } else if (qName.equals(COMPANY_TAG)) {
                this.isText_d = false;
                this.properties_d.setCompany(new String(this.textBuffer_d));
            } else if (qName.equals(DOCUMENTPROPERTIES_TAG)) {
                this.isProperties_d = false;
                this.drawing_d.setProperties(this.properties_d);
            }
        } else if (qName.equals("Master")) {
            this.isMaster_d = false;
            this.drawing_d.addMaster(this.master_d);
        } else if (qName.equals(SHAPES_TAG)) {
            this.isShapes_d = false;
        } else if (qName.equals(CONNECTS_TAG)) {
            this.isConnects_d = false;
        }
    }

    public Drawing getVisioDrawing() {
        return this.drawing_d;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        if (!this.isKnownTag(qName)) {
            return;
        }
        if (!(this.isMaster_d || this.isConnects_d || this.isShapes_d || this.isProperties_d)) {
            if (qName.equals(SHAPES_TAG)) {
                this.isShapes_d = true;
            } else if (qName.equals(CONNECTS_TAG)) {
                this.isConnects_d = true;
            } else if (qName.equals("Master")) {
                this.isMaster_d = true;
                this.master_d = Loader.createMaster(atts);
            } else if (qName.equals(DOCUMENTPROPERTIES_TAG)) {
                this.isProperties_d = true;
                this.properties_d = Loader.createProperties();
            }
        } else if ((this.isMaster_d || this.isShapes_d) && !this.isShape_d && qName.equals(SHAPE_TAG)) {
            this.isShape_d = true;
            this.shape_d = Loader.createShape(atts);
        } else if (!(!this.isShape_d || this.isXForm_d || this.isGeom_d || this.isText_d || this.isLine_d)) {
            if (qName.equals(XFORM_TAG)) {
                this.isXForm_d = true;
                this.xForm_d = new VisioXForm();
            } else if (qName.equals(GEOM_TAG)) {
                this.isGeom_d = true;
                this.geom_d = Loader.createGeom(atts);
            } else if (qName.equals(LINE_TAG)) {
                this.isLine_d = true;
            } else if (qName.equals(TEXT_TAG)) {
                this.isText_d = true;
                this.textBuffer_d = new StringBuffer();
            } else if (qName.equals(SHAPE_TAG)) {
                VisioShape shape = Loader.createShape(atts);
                this.shape_d.addShape(shape);
                this.shape_d = shape;
            }
        } else if (this.isConnects_d && qName.equals(CONNECT_TAG)) {
            this.drawing_d.addConnect(Loader.createConnect(atts));
        } else if (this.isGeom_d && !this.isGeomElement_d && VisioGeom.isRelevantElement(qName)) {
            this.isGeomElement_d = true;
            this.geomElement_d = new VisioGeomElement(qName);
        } else if (this.isXForm_d && (qName.equals(PINX_TAG) || qName.equals(PINY_TAG)) || this.isGeomElement_d && (qName.equals(X_TAG) || qName.equals(Y_TAG))) {
            this.isCoordinate_d = true;
            this.textBuffer_d = new StringBuffer();
        } else if (this.isXForm_d && (qName.equals(WIDTH_TAG) || qName.equals(HEIGHT_TAG))) {
            this.isDimension = true;
            this.textBuffer_d = new StringBuffer();
        } else if (this.isLine_d && (qName.equals(ENDARROW_TAG) || qName.equals(BEGINARROW_TAG))) {
            this.isNumber_d = true;
            this.textBuffer_d = new StringBuffer();
        } else if (this.isProperties_d && qName.equals(TITLE_TAG) || qName.equals(CREATOR_TAG) || qName.equals(COMPANY_TAG)) {
            this.isText_d = true;
            this.textBuffer_d = new StringBuffer();
        }
    }

    private static VisioConnect createConnect(Attributes atts) {
        int fromSheet = Integer.parseInt(atts.getValue(FROMSHEET_ATT));
        int toSheet = Integer.parseInt(atts.getValue(TOSHEET_ATT));
        return new VisioConnect(fromSheet, toSheet);
    }

    private static VisioGeom createGeom(Attributes atts) {
        int index = Integer.parseInt(atts.getValue(IX_ATT));
        VisioGeom geom = new VisioGeom(index);
        return geom;
    }

    private static VisioMaster createMaster(Attributes atts) {
        int id = Integer.parseInt(atts.getValue(ID_ATT));
        VisioMaster master = new VisioMaster(id);
        master.setName(atts.getValue(NAMEU_ATT));
        return master;
    }

    private static VisioProperties createProperties() {
        return new VisioProperties();
    }

    private static VisioShape createShape(Attributes atts) {
        int id = Integer.parseInt(atts.getValue(ID_ATT));
        VisioShape shape = new VisioShape(id);
        shape.setName(atts.getValue(NAMEU_ATT));
        String masterIdStr = atts.getValue("Master");
        if (masterIdStr == null) {
            masterIdStr = atts.getValue(MASTERSHAPE_ATT);
        }
        if (masterIdStr != null) {
            shape.setMasterId(Integer.parseInt(masterIdStr));
        }
        shape.setType(atts.getValue(TYPE_ATT));
        return shape;
    }

    private void buildKnownTags() {
        this.knownTags_d = new HashMap(KNONW_TAGS.length);
        for (int i = 0; i < KNONW_TAGS.length; ++i) {
            this.knownTags_d.put(KNONW_TAGS[i], null);
        }
    }

    private boolean isKnownTag(String name) {
        return this.knownTags_d.containsKey(name);
    }

    private void load(ProjectObject projectObject) throws ImporterException {
        this.buildKnownTags();
        this.drawing_d = new Drawing();
        SAXParserFactory spf = SAXParserFactory.newInstance();
        try {
            SAXParser sp = spf.newSAXParser();
            sp.parse(this.inputSource_d, (DefaultHandler)this);
        }
        catch (ParserConfigurationException e) {
            throw new ImporterException(projectObject, ProjectMsg.ERROR_PARSING_DRAWING, (Throwable)e);
        }
        catch (SAXException e) {
            throw new ImporterException(projectObject, ProjectMsg.ERROR_PARSING_DRAWING, (Throwable)e);
        }
        catch (IOException e) {
            throw new ImporterException(projectObject, ProjectMsg.ERROR_PARSING_DRAWING, (Throwable)e);
        }
    }
}

