/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.importer.visio;

import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.bpm.designer.importer.visio.VisioConnect;
import oracle.bpm.designer.importer.visio.VisioMaster;
import oracle.bpm.designer.importer.visio.VisioProperties;
import oracle.bpm.designer.importer.visio.VisioShape;

final class Drawing {
    public final Dimensions dimensions;
    public VisioProperties properties;
    private final Map<Integer, VisioConnect> connects;
    private final Map<Integer, VisioMaster> masters = new TreeMap<Integer, VisioMaster>();
    private final SortedSet<String> shapeNames;
    private final Map<Integer, VisioShape> shapes = new TreeMap<Integer, VisioShape>();

    public Drawing() {
        this.shapeNames = new TreeSet<String>();
        this.connects = new TreeMap<Integer, VisioConnect>();
        this.dimensions = new Dimensions();
    }

    public Iterable<VisioConnect> getConnects() {
        return this.connects.values();
    }

    public void setProperties(VisioProperties properties) {
        this.properties = properties;
    }

    public VisioShape getShape(Integer index) {
        return index == null ? null : this.shapes.get(index);
    }

    public SortedSet getShapeNames() {
        return this.shapeNames;
    }

    public Iterable<VisioShape> getShapes() {
        return this.shapes.values();
    }

    public void addConnect(VisioConnect connect) {
        VisioConnect existingConnect = this.connects.get(connect.getFromShape());
        if (existingConnect != null) {
            existingConnect.setToSecondShape(connect.getToFirstShape());
        } else {
            this.connects.put(connect.getFromShape(), connect);
        }
    }

    public void addMaster(VisioMaster master) {
        this.masters.put(master.getId(), master);
    }

    public void addShape(VisioShape shape) {
        Integer masterId = shape.getMasterId();
        if (masterId != null) {
            shape.setMaster(this.masters.get(masterId));
        }
        String name = shape.getName();
        if (shape.getGeoms().size() == 0 && name != null && name.toLowerCase().indexOf("title") != -1) {
            return;
        }
        if (name != null && !shape.isLine()) {
            this.shapeNames.add(name);
        }
        this.dimensions.addShapeCoordinates(shape.getXForm().getXPin(), shape.getXForm().getYPin());
        shape.setDrawingDimensions(this.dimensions);
        this.shapes.put(shape.getId(), shape);
    }

    public boolean hasShapes() {
        return this.shapes.size() != 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Visio Drawing:\n");
        sb.append(this.properties);
        sb.append("\nMASTERS:\n");
        for (VisioMaster visioMaster : this.masters.values()) {
            sb.append(visioMaster);
        }
        sb.append("\nSHAPES:\n");
        for (VisioShape visioShape : this.shapes.values()) {
            sb.append(visioShape);
        }
        sb.append("\nCONNECTS:\n");
        for (VisioConnect visioConnect : this.connects.values()) {
            sb.append(visioConnect);
        }
        return new String(sb);
    }

    public static final class Dimensions {
        private double maxX_d = 0.0;
        private double maxY_d = 0.0;
        private double minX_d = Double.MAX_VALUE;
        private double minY_d = Double.MAX_VALUE;

        public double getMaxY() {
            return this.maxY_d;
        }

        public double getMinX() {
            return this.minX_d;
        }

        public double getWidth() {
            return this.maxX_d - this.minX_d;
        }

        void addShapeCoordinates(double x, double y) {
            if (x < this.minX_d) {
                this.minX_d = x;
            }
            if (x > this.maxX_d) {
                this.maxX_d = x;
            }
            if (y < this.minY_d) {
                this.minY_d = y;
            }
            if (y > this.maxY_d) {
                this.maxY_d = y;
            }
        }
    }
}

