/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.identity;

import java.util.ArrayList;
import java.util.Collection;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.identity.LookupMembersService;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.identity.Member;
import oracle.bpm.project.model.identity.MemberContainer;
import oracle.bpm.project.model.identity.MemberType;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.table.BaseTablePanel;
import oracle.bpm.ui.table.ProviderTableModel;
import oracle.bpm.ui.table.TableModel;

public class MembersPanel
extends Panel {
    private MemberContainer memberContainer;
    private ProviderTableModel membersTableModel;
    private ComboBox<MemberType> membersTypeCombo;

    public MembersPanel(UiContainer parent) {
        super(parent, DesignerMsg.MEMBERS);
        this.buildUi();
    }

    public void setMemberContainer(MemberContainer memberContainer) {
        this.memberContainer = memberContainer;
        this.membersTableModel.removeAllElements();
        this.membersTableModel.addRows((Iterable)memberContainer.getMembers());
    }

    private void buildUi() {
        this.setLayout((Layout)new MigLayout("fill"));
        this.membersTableModel = new MembersTableModel();
        MembersTablePanel membersTablePanel = new MembersTablePanel((UiContainer)this, (TableModel)this.membersTableModel);
        this.membersTypeCombo = UiFactory.createComboBox((UiContainer)this, (Object[])MemberType.values());
        this.membersTypeCombo.setLabelProvider(this.getMembersTypeComboLabelProvider());
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.TYPE), "align right");
        this.add((UiComponent)this.membersTypeCombo, "wrap");
        this.add((UiComponent)membersTablePanel, "height 90::, grow, spanx");
    }

    private LabelProvider<MemberType> getMembersTypeComboLabelProvider() {
        return new LabelProvider<MemberType>(){

            public Image getIcon(MemberType element) {
                return null;
            }

            public String getText(MemberType element) {
                return element.getMsg().toString();
            }
        };
    }

    private class MembersTablePanel
    extends BaseTablePanel {
        public MembersTablePanel(UiContainer parent, TableModel tableModel) {
            super(parent, null, null, tableModel);
        }

        protected void addAction() {
            if (MembersPanel.this.memberContainer != null) {
                MemberType memberType = (MemberType)MembersPanel.this.membersTypeCombo.getSelectedItem();
                LookupMembersService lookupMembersService = AbstractStudioWorkbench.getInstance().getLookupMembersService();
                try {
                    if (lookupMembersService != null) {
                        Collection<Member> members = lookupMembersService.findMembers(MembersPanel.this.memberContainer, memberType);
                        ArrayList<Member> list = new ArrayList<Member>();
                        for (Member member : members) {
                            if (MembersPanel.this.memberContainer.findMember(member.getId()) != null) continue;
                            MembersPanel.this.memberContainer.addMember(member);
                            list.add(member);
                        }
                        this.getModel().addRows(list);
                    }
                }
                catch (ProjectException e) {
                    MessageDialog.showError((Throwable)e);
                }
            }
        }

        protected void deleteAction() {
            int[] selection = this.getTable().getSelectedRows();
            try {
                for (int row = selection.length - 1; row >= 0; --row) {
                    Member member = (Member)((ProviderTableModel)this.getTable().getModel()).getRow(selection[row]);
                    MembersPanel.this.memberContainer.removeMember(member);
                }
                super.deleteAction();
            }
            catch (ProjectException e) {
                e.printStackTrace();
                MessageDialog.showError((Throwable)e);
            }
        }
    }

    private class MembersTableModel
    extends ProviderTableModel<Member> {
        public MembersTableModel() {
            super(MsgList.create(DesignerMsg.NAME, DesignerMsg.TYPE));
        }

        public Object getValueAt(int row, int column) {
            Member member = (Member)this.getRow(row);
            return column == 0 ? member.getName() : member.getType().getMsg().toString();
        }
    }
}

