/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.web;

import oracle.bpm.designer.formdesigner.model.ComponentType;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.FontStyle;
import oracle.bpm.web.formdesigner.protocol.ComponentProperty;
import oracle.bpm.web.formdesigner.protocol.PropertiesValue;
import oracle.bpm.webformdesigner.msg.WebformdesignerMsg;
import oracle.bpm.xobject.presentationmodel.ColorProperties;
import oracle.bpm.xobject.presentationmodel.CssProperties;
import oracle.bpm.xobject.presentationmodel.FontProperties;
import oracle.bpm.xobject.presentationmodel.FullBorderProperties;
import oracle.bpm.xobject.presentationmodel.HorizontalAlignmentProperties;
import oracle.bpm.xobject.presentationmodel.SimpleBorderProperties;
import oracle.bpm.xobject.presentationmodel.XFormComponentType;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.xml.XFormXMLObject;

public class WebPropertyBuilder {
    private static String PALETTE_TITLE = "PALETTE_TITLE";

    public static void addProperties(PropertiesValue propertiesValue, XFormPresentationXMLObject component, boolean cssEnabled) {
        if (cssEnabled) {
            WebPropertyBuilder.addCssProperties(component, propertiesValue);
        }
        if (!cssEnabled || component.isMixedCss()) {
            Object properties;
            XFormComponentType componentType = component.getComponentType();
            if (component instanceof FontProperties && WebPropertyBuilder.addFonts(componentType)) {
                properties = (FontProperties)((Object)component);
                WebPropertyBuilder.addFontProperties((FontProperties)properties, propertiesValue);
            }
            if (component instanceof ColorProperties) {
                properties = (ColorProperties)((Object)component);
                if (WebPropertyBuilder.hasForegroundProperty(componentType)) {
                    WebPropertyBuilder.addColorProperties((ColorProperties)properties, propertiesValue);
                } else {
                    WebPropertyBuilder.addBackgroundColorProperties((ColorProperties)properties, propertiesValue);
                }
            }
            if (component instanceof HorizontalAlignmentProperties) {
                properties = (HorizontalAlignmentProperties)((Object)component);
                WebPropertyBuilder.addHorizontalAlignmentProperties((HorizontalAlignmentProperties)properties, propertiesValue);
            }
            if (component instanceof FullBorderProperties) {
                WebPropertyBuilder.addFullBorderProperties(component, propertiesValue);
            }
            if (component instanceof SimpleBorderProperties) {
                WebPropertyBuilder.addSimpleBorderProperties(component, propertiesValue);
            }
        }
    }

    public static void addPropertiesTitle(XFormPresentationXMLObject component, PropertiesValue value) {
        Msg componentMsg = ComponentType.get(component).getMsg();
        String paletteTitle = WebformdesignerMsg.FORMAT_COMPONENT((String)componentMsg.getString()).getString();
        value.addValue(PALETTE_TITLE, paletteTitle);
    }

    private static boolean addFonts(XFormComponentType componentType) {
        return componentType != XFormComponentType.CELL && componentType != XFormComponentType.GAUGE && componentType != XFormComponentType.PIE && componentType != XFormComponentType.CHART && componentType != XFormComponentType.ARRAY && componentType != XFormComponentType.REPEATABLESECTION;
    }

    private static boolean hasForegroundProperty(XFormComponentType componentType) {
        return componentType != XFormComponentType.CELL;
    }

    private static void addHorizontalAlignmentProperties(HorizontalAlignmentProperties properties, PropertiesValue propertiesValue) {
        String alignment = properties.getAlignment();
        propertiesValue.addValue(ComponentProperty.HORIZONTAL_ALIGNMENT, alignment);
    }

    private static void addCssProperties(CssProperties properties, PropertiesValue propertiesValue) {
        String cssClass = properties.getCssClass();
        propertiesValue.addValue(ComponentProperty.CSS_CLASS, cssClass);
    }

    private static void addColorProperties(ColorProperties properties, PropertiesValue propertiesValue) {
        WebPropertyBuilder.addForegroundColorProperties(properties, propertiesValue);
        WebPropertyBuilder.addBackgroundColorProperties(properties, propertiesValue);
    }

    private static void addForegroundColorProperties(ColorProperties properties, PropertiesValue propertiesValue) {
        String fgColor = properties.getFgcolor();
        propertiesValue.addValue(ComponentProperty.FGCOLOR, fgColor);
    }

    private static void addBackgroundColorProperties(ColorProperties properties, PropertiesValue propertiesValue) {
        String bgColor = properties.getBgcolor();
        propertiesValue.addValue(ComponentProperty.BGCOLOR, bgColor);
    }

    private static void addFullBorderProperties(XFormXMLObject properties, PropertiesValue propertiesValue) {
        String topValue = ComponentProperty.TOP_BORDER.getValue(properties);
        propertiesValue.addValue(ComponentProperty.TOP_BORDER, topValue);
        String bottomValue = ComponentProperty.BOTTOM_BORDER.getValue(properties);
        propertiesValue.addValue(ComponentProperty.BOTTOM_BORDER, bottomValue);
        String leftValue = ComponentProperty.LEFT_BORDER.getValue(properties);
        propertiesValue.addValue(ComponentProperty.LEFT_BORDER, leftValue);
        String rightValue = ComponentProperty.RIGHT_BORDER.getValue(properties);
        propertiesValue.addValue(ComponentProperty.RIGHT_BORDER, rightValue);
    }

    private static void addSimpleBorderProperties(XFormXMLObject properties, PropertiesValue propertiesValue) {
        String value = ComponentProperty.SIMPLE_BORDER.getValue(properties);
        propertiesValue.addValue(ComponentProperty.SIMPLE_BORDER, value);
    }

    private static void addFontProperties(FontProperties properties, PropertiesValue propertiesValue) {
        FontStyle style = properties.getFontStyle();
        if (style == null) {
            style = FontStyle.PLAIN;
        }
        switch (style) {
            case BOLD: {
                propertiesValue.addValue(ComponentProperty.FONT_BOLD, "true");
                propertiesValue.addValue(ComponentProperty.FONT_ITALIC, "false");
                break;
            }
            case BOLD_ITALIC: {
                propertiesValue.addValue(ComponentProperty.FONT_BOLD, "true");
                propertiesValue.addValue(ComponentProperty.FONT_ITALIC, "true");
                break;
            }
            case ITALIC: {
                propertiesValue.addValue(ComponentProperty.FONT_BOLD, "false");
                propertiesValue.addValue(ComponentProperty.FONT_ITALIC, "true");
                break;
            }
            case PLAIN: {
                propertiesValue.addValue(ComponentProperty.FONT_BOLD, "false");
                propertiesValue.addValue(ComponentProperty.FONT_ITALIC, "false");
            }
        }
        String fontFace = properties.getFonttype();
        propertiesValue.addValue(ComponentProperty.FONT_FACE, fontFace);
        int fontSize = properties.getFontsize();
        propertiesValue.addValue(ComponentProperty.FONT_SIZE, "" + fontSize);
    }
}

