/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.web;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.formdesigner.XFormSelectionBuilder;
import oracle.bpm.designer.formdesigner.outline.DeleteComponentAction;
import oracle.bpm.designer.formdesigner.outline.InsertColumnAction;
import oracle.bpm.designer.formdesigner.outline.InsertRowAction;
import oracle.bpm.designer.formdesigner.outline.PopupActions;
import oracle.bpm.designer.formdesigner.outline.PopupMenuManager;
import oracle.bpm.designer.formdesigner.outline.PresentationStructureView;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.log.Log;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.web.formdesigner.protocol.ComponentContextAction;
import oracle.bpm.web.formdesigner.protocol.ComponentContextActionGroup;
import oracle.bpm.web.formdesigner.protocol.DefaultComponentContextAction;
import oracle.bpm.webformdesigner.msg.WebformdesignerMsg;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;

public class WebActionFactory {
    private List<ComponentContextAction> actions;
    private XFormSelectionBuilder builder;

    public WebActionFactory(PresentationStructureView view, XFormSelectionBuilder builder) {
        this.builder = builder;
        this.createActions(view);
    }

    public static ComponentContextAction[] getActions(PresentationStructureView view, XFormSelectionBuilder builder, XFormPresentationXMLObject component) {
        WebActionFactory factory = new WebActionFactory(view, builder);
        return factory.getActions(component);
    }

    public ComponentContextAction[] getActions(XFormPresentationXMLObject component) {
        ArrayList<ComponentContextAction> result = new ArrayList<ComponentContextAction>();
        Selection selection = this.builder.buildSelection(component);
        for (ComponentContextAction action : this.actions) {
            action.setSelection(selection);
            if (!action.isEnabled()) continue;
            result.add(action);
        }
        return result.toArray(new ComponentContextAction[result.size()]);
    }

    public ComponentContextAction getAction(XFormPresentationXMLObject component, String commandId) {
        ComponentContextAction action = this.findAction(this.actions, component, commandId);
        if (action != null) {
            Selection selection = this.builder.buildSelection(component);
            action.setSelection(selection);
        }
        return action;
    }

    public ComponentContextAction findAction(List<ComponentContextAction> actionList, XFormPresentationXMLObject component, String commandId) {
        ComponentContextAction result = null;
        for (ComponentContextAction action : actionList) {
            if (action instanceof ComponentContextActionGroup) {
                List groupActions = ((ComponentContextActionGroup)action).getEnabledActions();
                result = this.findAction(groupActions, component, commandId);
            } else if (action.getId().equals(commandId)) {
                result = action;
            }
            if (result == null) continue;
            break;
        }
        return result;
    }

    public ArrayList<ComponentContextAction> createLayoutActions(PresentationStructureView view) {
        ArrayList<ComponentContextAction> layoutActions = new ArrayList<ComponentContextAction>();
        layoutActions.add(new InsertRowAction(view));
        layoutActions.add(PopupMenuManager.createDupliacateRowAction(view));
        layoutActions.add(new InsertColumnAction(view));
        layoutActions.add(new PopupActions.AppendColumnAction(view));
        layoutActions.add(PopupMenuManager.createRemoveCellCommand(view));
        layoutActions.add(PopupMenuManager.createRemoveRowAction(view));
        layoutActions.add(PopupMenuManager.createRemoveColumnCommand(view));
        layoutActions.add(PopupMenuManager.createRemoveTableCommand(view));
        return layoutActions;
    }

    private void createActions(PresentationStructureView view) {
        this.actions = new ArrayList<ComponentContextAction>();
        this.actions.add((ComponentContextAction)new DefaultComponentContextAction(DesignerMsg.PROPERTIES));
        this.actions.add(new DeleteComponentAction(view));
        this.actions.add((ComponentContextAction)new ComponentContextActionGroup(this.createReplaceActions(view), DesignerMsg.REPLACE));
        this.actions.add((ComponentContextAction)new ComponentContextActionGroup(this.createLayoutActions(view), DesignerMsg.LAYOUT));
        this.actions.add((ComponentContextAction)new ComponentContextActionGroup(this.createMoveActions(view), DesignerMsg.MOVE));
    }

    private ArrayList<ComponentContextAction> createReplaceActions(PresentationStructureView view) {
        ActionGroup actionGroup = PopupMenuManager.createReplaceActionGroup(view);
        ArrayList<ComponentContextAction> webActions = new ArrayList<ComponentContextAction>();
        BaseAction[] actions = actionGroup.getActions();
        this.fillActions(webActions, actions);
        return webActions;
    }

    private void fillActions(ArrayList<ComponentContextAction> webActions, BaseAction[] actions) {
        for (BaseAction action : actions) {
            if (action instanceof ActionGroup) {
                ActionGroup group = (ActionGroup)action;
                ArrayList<ComponentContextAction> elements = new ArrayList<ComponentContextAction>();
                ComponentContextActionGroup webGroup = new ComponentContextActionGroup(elements, group.getMsg());
                webActions.add((ComponentContextAction)webGroup);
                this.fillActions(elements, group.getActions());
                continue;
            }
            if (action instanceof ComponentContextAction) {
                webActions.add((ComponentContextAction)action);
                continue;
            }
            Log.logDebug("action " + action.getName() + " Does not implement ComponentContextAction");
        }
    }

    private ArrayList<ComponentContextAction> createMoveActions(PresentationStructureView view) {
        ArrayList<PopupActions.MoveAction> moveCell = new ArrayList<PopupActions.MoveAction>();
        moveCell.add(PopupMenuManager.createMoveCellLeftAction(view, WebformdesignerMsg.LEFT));
        moveCell.add(PopupMenuManager.createMoveCellLeftMostAction(view, WebformdesignerMsg.BEGINNING));
        moveCell.add(PopupMenuManager.createMoveCellRightAction(view, WebformdesignerMsg.RIGHT));
        moveCell.add(PopupMenuManager.createMoveCellRightMostAction(view, WebformdesignerMsg.END));
        ArrayList<PopupActions.MoveAction> moveRow = new ArrayList<PopupActions.MoveAction>();
        moveRow.add(PopupMenuManager.createMoveRowUpAction(view, WebformdesignerMsg.UP));
        moveRow.add(PopupMenuManager.createMoveRowTopAction(view, WebformdesignerMsg.TOP));
        moveRow.add(PopupMenuManager.createMoveRowDownAction(view, WebformdesignerMsg.DOWN));
        moveRow.add(PopupMenuManager.createMoveRowBottomAction(view, WebformdesignerMsg.BOTTOM));
        ArrayList<ComponentContextAction> moveActions = new ArrayList<ComponentContextAction>();
        moveActions.add((ComponentContextAction)new ComponentContextActionGroup(moveCell, WebformdesignerMsg.CELL));
        moveActions.add((ComponentContextAction)new ComponentContextActionGroup(moveRow, WebformdesignerMsg.ROW));
        return moveActions;
    }
}

