/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.web;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.LinkedBlockingQueue;
import oracle.bpm.designer.formdesigner.web.EventManager;
import oracle.bpm.designer.formdesigner.web.PresentationEvent;
import oracle.bpm.lang.Str;
import oracle.bpm.ui.Browser;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.web.formdesigner.json.JSONException;
import oracle.bpm.web.formdesigner.protocol.ApplicationMessage;
import oracle.bpm.web.formdesigner.protocol.NetworkMessage;
import oracle.bpm.web.formdesigner.protocol.TransportMessage;

public class TransportManager {
    private Browser browser;
    private EventManager eventManager;
    private Logger logger;
    private final MessageProcessor messageProcessor = new MessageProcessor();
    private static String DEFAULT_LOG = "PRESENTATION";
    private static final String JS_RECEIVE_FUNCTION_NAME = "JavaJsListener.receiveMsg";

    public TransportManager(Browser browser) {
        this(browser, DEFAULT_LOG);
    }

    public TransportManager(Browser browser, String logId) {
        this.messageProcessor.startProcessor();
        this.browser = browser;
        this.init();
        this.logger = new Logger(logId);
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public void sendPresentationEvent(PresentationEvent presentationEvent) {
        this.messageProcessor.processStudioMessage(presentationEvent);
    }

    protected void init() {
        this.browser.addStatusTextListener(new Browser.StatusTextListener(){

            public void changed(String statusText) {
                TransportManager.this.processMessage(statusText);
            }
        });
    }

    protected void processMessage(String msgText) {
        block2: {
            try {
                this.messageProcessor.processEditorMessage(NetworkMessage.valueOf((String)msgText));
                this.logger.log("incoming", msgText);
            }
            catch (JSONException e) {
                if (!msgText.contains(NetworkMessage.NETWORK_ID_VALUE)) break block2;
                this.logger.log("incoming", msgText);
                e.printStackTrace();
            }
        }
    }

    protected void writeToBrowser(String executionString) {
        if (!this.browser.isDisposed()) {
            this.browser.execute(executionString);
            this.logger.log("outgoing", executionString);
        }
    }

    protected void invoke(Runnable runnable) {
        UiUtilities.invokeLater((Runnable)runnable);
    }

    private void sendMessage(NetworkMessage networkMessage) {
        try {
            String jon = networkMessage.toJSONString();
            StringBuffer msg = new StringBuffer(JS_RECEIVE_FUNCTION_NAME).append("(\"").append(Str.escapeForScripts(jon)).append("\");");
            this.writeToBrowser(msg.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private class MessageProcessor
    extends Thread {
        private boolean isRunning = false;
        private final LinkedBlockingQueue<NetworkMessage> messageQue = new LinkedBlockingQueue();
        private String syncMessageId;

        private MessageProcessor() {
        }

        public void startProcessor() {
            if (!this.isRunning) {
                this.isRunning = true;
                this.start();
            }
        }

        public void stopProcessor() {
            this.isRunning = false;
        }

        @Override
        public void run() {
            while (this.isRunning) {
                try {
                    if (!this.isSyncProcessing() && !this.messageQue.isEmpty()) {
                        NetworkMessage message = this.messageQue.poll();
                        this.process(message.getTransportMessage());
                    }
                    MessageProcessor.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void processEditorMessage(NetworkMessage networkMessage) {
            this.messageQue.add(networkMessage);
        }

        public void processStudioMessage(PresentationEvent presEvent) {
            this.sendMessageCallback("0", presEvent.getApplicationMessage());
        }

        private void process(TransportMessage transportMessage) {
            if (transportMessage.isSynchronic()) {
                this.syncMessageId = transportMessage.getId();
            }
            ApplicationMessage applicationMessage = transportMessage.getApplicationMessage();
            ApplicationMessage answer = TransportManager.this.eventManager.processEditorEvent(applicationMessage);
            if (answer != null) {
                this.processMessageCallback(transportMessage.getId(), answer);
            }
        }

        private void processMessageCallback(String id, ApplicationMessage callbackMessage) {
            this.sendMessageCallback(id, callbackMessage);
            if (id.equals(this.syncMessageId)) {
                this.syncMessageId = null;
            }
        }

        private void sendMessageCallback(final String id, final ApplicationMessage message) {
            TransportManager.this.invoke(new Runnable(){

                @Override
                public void run() {
                    TransportMessage transportMessage = new TransportMessage(id, message);
                    NetworkMessage networkMessage = new NetworkMessage(transportMessage);
                    TransportManager.this.sendMessage(networkMessage);
                }
            });
        }

        private boolean isSyncProcessing() {
            return this.syncMessageId != null;
        }
    }

    private static class Logger {
        private String logId;
        private BufferedWriter writer;
        public static final String INCOMING = "incoming";
        public static final String OUTGOING = "outgoing";

        public Logger(String logId) {
            this.logId = logId;
        }

        public void log(String fromWhere, String msg) {
            if (Logger.isLogging()) {
                try {
                    Writer writer = this.getWriter();
                    writer.write(fromWhere + "--" + msg + "\n");
                    writer.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        public Writer getWriter() throws IOException {
            if (this.writer == null) {
                File file = File.createTempFile(this.logId, ".log");
                System.out.println("file.getAbsolutePath() = " + file.getAbsolutePath());
                FileWriter fileWriter = new FileWriter(file);
                this.writer = new BufferedWriter(fileWriter);
            }
            return this.writer;
        }

        private static boolean isLogging() {
            return false;
        }
    }
}

