/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.web;

import oracle.bpm.designer.formdesigner.AbstractPresentationEditor;
import oracle.bpm.designer.formdesigner.ChangeListener;
import oracle.bpm.designer.formdesigner.XFormSelectionBuilder;
import oracle.bpm.designer.formdesigner.command.Command;
import oracle.bpm.designer.formdesigner.outline.PresentationStructureView;
import oracle.bpm.designer.formdesigner.web.PresentationEditor;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.xml.XFormXMLObject;

public class RefreshCommand
extends Command {
    private ChangeListener listener;

    private RefreshCommand(ChangeListener listener) {
        this.listener = listener;
    }

    public static Command addRefreshAndIgnoreEvents(Command command, PresentationStructureView view) {
        return RefreshCommand.composeIgnoringEvents(command, new RefreshCommand(view.getChangeListener()), view.getPresentationEditor());
    }

    public static Command addRefresh(Command command, PresentationStructureView view) {
        return RefreshCommand.addRefresh(command, view.getChangeListener());
    }

    public static Command addRefresh(Command command, ChangeListener listener) {
        return RefreshCommand.compose(command, new RefreshCommand(listener));
    }

    public static Command addRefreshWithSelection(Command command, final XFormSelectionBuilder selectionBuilder, final PresentationEditor presentationEditor, final XFormXMLObject selection) {
        if (selection != null) {
            RefreshCommand refreshCommand = new RefreshCommand(presentationEditor){

                @Override
                public boolean doIt() {
                    Selection newSelection = selectionBuilder.buildSelection((XFormPresentationXMLObject)selection);
                    presentationEditor.setNextFocusable(newSelection);
                    return super.doIt();
                }
            };
            return RefreshCommand.compose(command, refreshCommand);
        }
        return RefreshCommand.addRefresh(command, presentationEditor);
    }

    @Override
    public Msg getMsg() {
        return DesignerMsg.REFRESH;
    }

    @Override
    public boolean doIt() {
        this.fireChange();
        return true;
    }

    @Override
    public boolean undoIt() {
        this.fireChange();
        return true;
    }

    private static Command compose(final Command command, final Command refreshCommand) {
        return new ComposedCommand(command){

            @Override
            public boolean doIt() {
                return command.doIt() && refreshCommand.doIt();
            }

            @Override
            public boolean undoIt() {
                return command.undoIt() && refreshCommand.undoIt();
            }
        };
    }

    private static Command composeIgnoringEvents(final Command command, final Command refreshCommand, final AbstractPresentationEditor editor) {
        return new ComposedCommand(command){

            @Override
            public boolean doIt() {
                return editor.doIgnoringEvents(command) && refreshCommand.doIt();
            }

            @Override
            public boolean undoIt() {
                return editor.undoIgnoringEvents(command) && refreshCommand.undoIt();
            }
        };
    }

    private void fireChange() {
        this.listener.changeOccured(ChangeListener.EventFactory.createChange(this));
    }

    private static abstract class ComposedCommand
    extends Command {
        private Command command;

        public ComposedCommand(Command command) {
            this.command = command;
        }

        @Override
        public String getName() {
            return this.command.getName();
        }

        @Override
        public Msg getMsg() {
            return this.command.getMsg();
        }
    }
}

