/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.web;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import oracle.bpm.data.html.TextType;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.formdesigner.ChangeListener;
import oracle.bpm.designer.formdesigner.CommandManager;
import oracle.bpm.designer.formdesigner.ComponentInteractionProviderImpl;
import oracle.bpm.designer.formdesigner.PresentationDesignerBrowser;
import oracle.bpm.designer.formdesigner.Utilities;
import oracle.bpm.designer.formdesigner.XFormSelection;
import oracle.bpm.designer.formdesigner.XFormSelectionBuilder;
import oracle.bpm.designer.formdesigner.command.AddDataCommand;
import oracle.bpm.designer.formdesigner.command.Command;
import oracle.bpm.designer.formdesigner.command.CompoundCommand;
import oracle.bpm.designer.formdesigner.command.ModifyArrayHeaderCommand;
import oracle.bpm.designer.formdesigner.command.ModifyComponentPropertyCommand;
import oracle.bpm.designer.formdesigner.command.MoveDataCommand;
import oracle.bpm.designer.formdesigner.editors.ComponentEditor;
import oracle.bpm.designer.formdesigner.editors.EditorRegistry;
import oracle.bpm.designer.formdesigner.outline.DataTreeHelper;
import oracle.bpm.designer.formdesigner.properties.ComponentInteractionProvider;
import oracle.bpm.designer.formdesigner.properties.ComponentProperties;
import oracle.bpm.designer.formdesigner.properties.PropertyMerger;
import oracle.bpm.designer.formdesigner.web.CTODragCommandBuilder;
import oracle.bpm.designer.formdesigner.web.EventManager;
import oracle.bpm.designer.formdesigner.web.PresentationEditor;
import oracle.bpm.designer.formdesigner.web.PresentationEvent;
import oracle.bpm.designer.formdesigner.web.RefreshCommand;
import oracle.bpm.designer.formdesigner.web.TransportManager;
import oracle.bpm.designer.formdesigner.web.Utils;
import oracle.bpm.designer.formdesigner.web.WebActionFactory;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.log.Log;
import oracle.bpm.project.FuegoProject;
import oracle.bpm.project.io.fs.FileProjectWriter;
import oracle.bpm.project.io.fs.WebRoot;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectWriter;
import oracle.bpm.project.model.fojsp.WebContentType;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.prop.PropertyTable;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.ui.selection.SelectionListener;
import oracle.bpm.util.FileUtils;
import oracle.bpm.web.formdesigner.protocol.ApplicationCTODragMessageValue;
import oracle.bpm.web.formdesigner.protocol.ApplicationKeyMessageValue;
import oracle.bpm.web.formdesigner.protocol.ComponentContextAction;
import oracle.bpm.web.formdesigner.protocol.ComponentId;
import oracle.bpm.web.formdesigner.protocol.ComponentProperty;
import oracle.bpm.web.formdesigner.protocol.PropertyValue;
import oracle.bpm.xobject.presentationmodel.XFormComponentType;
import oracle.bpm.xobject.presentationmodel.XFormLink;
import oracle.bpm.xobject.presentationmodel.XFormPresentation;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModel;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.presentationmodel.XFormRepeatable;
import oracle.bpm.xobject.presentationmodel.XFormTable;
import oracle.bpm.xobject.runtime.InvalidPresentationException;
import oracle.bpm.xobject.runtime.XScreen;
import oracle.bpm.xobject.runtime.html.HTMLPage;
import oracle.bpm.xobject.runtime.html.HTMLPresentationBuilder;
import oracle.bpm.xobject.runtime.html.XScreenHTMLImpl;
import oracle.bpm.xobject.runtime.presentationComponents.XOContainerComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOPresentationComponent;

public class PresentationManager {
    private DataTreeHelper dataTreeHelper;
    private HashMap<String, XOContainerComponent> droppables;
    private EditorRegistry editorRegistry;
    private EventManager eventManager;
    private boolean ignoreSelectionEvents = false;
    private boolean isListeningToFocus = true;
    private PresentationEditor presentationEditor;
    private ComponentInteractionProvider provider;
    private XFormSelectionBuilder selectionBuilder;
    private WebActionFactory webActionFactory;

    public PresentationManager(PresentationEditor abstractPresentationEditor, EditorRegistry editorRegistry, TransportManager transportManager) {
        this.editorRegistry = editorRegistry;
        this.presentationEditor = abstractPresentationEditor;
        this.dataTreeHelper = this.presentationEditor.getHelper();
        this.init(transportManager);
        this.initializeEditor();
    }

    public void previewPresentation() {
        this.eventManager.setLoaded(false);
        PresentationEvent reloadPresentationMessage = this.buildReloadPresentationEvent(false);
        this.eventManager.sendMessage(reloadPresentationMessage);
    }

    public void loadPresentation() {
        this.eventManager.setLoaded(false);
        this.ignoreSelectionEvents = true;
        Selection selection = this.presentationEditor.getFocuseable();
        this.reloadPresentation();
        if (selection != null) {
            this.updateFocus(selection, false);
        }
        this.ignoreSelectionEvents = false;
    }

    public PresentationEvent getDroppables(XFormComponentType componentType) {
        return this.getDroppables(componentType, null);
    }

    public XFormSelectionBuilder getSelectionBuilder() {
        return this.selectionBuilder;
    }

    public void requestFocus(XFormPresentationXMLObject object) {
        ComponentId componentId = this.getComponentId(object);
        this.requestFocus(Arrays.asList(componentId));
    }

    public PresentationEvent addComponent(String parentId, XFormComponentType componentType, Properties properties) {
        XFormPresentationXMLObject parent = this.getComponentForId(parentId);
        AddDataCommand command = AddDataCommand.newWithId(parent, componentType, this.presentationEditor.getView());
        if (componentType == XFormComponentType.TABLE) {
            XFormTable table = (XFormTable)command.getAddedObject();
            table.expand((Integer)properties.get("rows"), (Integer)properties.get("columns"));
        }
        command.setFireEvents(false);
        command.setSelect(false);
        Command refreshCommand = RefreshCommand.addRefreshWithSelection(command, this.selectionBuilder, this.presentationEditor, command.getAddedObject());
        CommandManager.invokeCommand(refreshCommand);
        return null;
    }

    public PresentationEvent moveComponent(String parentId, String componentId) {
        XFormPresentationXMLObject parent = this.getComponentForId(parentId);
        XFormPresentationXMLObject component = this.getComponentForId(componentId);
        MoveDataCommand command = new MoveDataCommand(this.presentationEditor.getView(), parent, component);
        CommandManager.invokeCommand(command);
        return null;
    }

    public void setSelection(Selection selection) {
        ((AbstractStudioWorkbench)AbstractStudioWorkbench.getInstance()).setFocusOnActiveEditor();
        this.ignoreSelectionEvents = true;
        this.presentationEditor.setSelection(selection);
        this.ignoreSelectionEvents = false;
    }

    public PresentationEvent getDroppables(String modelId) {
        final XFormPresentationXMLObject draggedObject = this.getComponentForId(modelId);
        if (draggedObject == null) {
            return null;
        }
        XFormComponentType type = draggedObject.getComponentType();
        Filter filter = null;
        if (type == XFormComponentType.TABLE || type == XFormComponentType.ROW) {
            filter = new Filter(){

                @Override
                public boolean accept(XOContainerComponent xoContainerComponent) {
                    return Utilities.canAdd(xoContainerComponent.getPresentationXMLObject(), draggedObject);
                }
            };
        }
        return this.getDroppables(type, filter);
    }

    public void runCommand(String commandId, String modelId) {
        ComponentContextAction action;
        XFormPresentationXMLObject component = this.getComponentForId(modelId);
        if (component != null && (action = this.getWebActionFactory().getAction(component, commandId)) != null) {
            ((BaseAction)action).run();
        }
    }

    public WebActionFactory getWebActionFactory() {
        if (this.webActionFactory == null) {
            this.webActionFactory = new WebActionFactory(this.presentationEditor.getView(), this.selectionBuilder);
        }
        return this.webActionFactory;
    }

    public void changeValues(PropertyValue[] propertyValues, String modelId) {
        CompoundCommand composite = new CompoundCommand(new ArrayList(), DesignerMsg.MODIFIED_VALUE_COMMAND("", "", ""));
        for (PropertyValue propertyValue : propertyValues) {
            Command command = this.getCommand(propertyValue.getName(), propertyValue.getValue(), modelId);
            composite.addCommand(command);
        }
        CommandManager.invokeCommand(RefreshCommand.addRefresh((Command)composite, this.presentationEditor));
    }

    public Command getCommand(String property, String newValue, String modelId) {
        ComponentProperty componentProperty = ComponentProperty.valueOf((String)property);
        XFormPresentationXMLObject object = this.getComponentForId(modelId);
        Command command = object == null && componentProperty == ComponentProperty.TEXT ? this.changeHeaderText(newValue, modelId, null) : new ModifyComponentPropertyCommand(object, newValue, componentProperty, null);
        return command;
    }

    public void processKey(ApplicationKeyMessageValue keyMessageValue) {
        String key = keyMessageValue.getKey();
        if (key != null && key.length() > 0) {
            if (key.toLowerCase().equals("delete")) {
                this.presentationEditor.getDeleteAction().run();
            }
            if (keyMessageValue.isCtrl()) {
                char character = key.toLowerCase().charAt(0);
                switch (character) {
                    case 'c': {
                        this.presentationEditor.getCopyAction().run();
                        break;
                    }
                    case 'x': {
                        this.presentationEditor.getCutAction().run();
                        break;
                    }
                    case 'v': {
                        this.presentationEditor.getPasteAction().run();
                        break;
                    }
                    case 'z': {
                        this.presentationEditor.fireUndo();
                        break;
                    }
                    case 'y': {
                        this.presentationEditor.fireRedo();
                    }
                }
            }
        }
    }

    public void processError(String stringValue) {
        this.presentationEditor.addError(stringValue);
    }

    public void processWarning(String stringValue) {
        this.presentationEditor.addWarning(stringValue);
    }

    public PresentationEvent processCTODrag(ApplicationCTODragMessageValue appMessageValue) {
        Command command = CTODragCommandBuilder.buildCommand(this.dataTreeHelper, this.presentationEditor.getView(), appMessageValue);
        CommandManager.invokeCommand(command);
        return null;
    }

    public boolean isListeningToFocus() {
        return this.isListeningToFocus;
    }

    public void setListeningToFocus(boolean listeningToFocus) {
        this.isListeningToFocus = listeningToFocus;
    }

    public void initializeEditor() {
        this.eventManager.setReady(false);
        this.eventManager.setLoaded(false);
        this.refreshEditor();
    }

    public void refreshEditor() {
        PresentationEvent initEvent = PresentationEvent.buildInitializationEvent();
        this.eventManager.sendMessage(initEvent);
    }

    public boolean closePresentation() {
        boolean result = false;
        if (this.presentationEditor instanceof PresentationDesignerBrowser) {
            PresentationDesignerBrowser browser = (PresentationDesignerBrowser)this.presentationEditor;
            result = browser.close();
        }
        return result;
    }

    public PresentationEvent getContexutalItems(String modelId) {
        XFormPresentationXMLObject currentElement = this.getComponentForId(modelId);
        if (currentElement == null) {
            return null;
        }
        ComponentContextAction[] actions = this.getWebActionFactory().getActions(currentElement);
        return PresentationEvent.buildContextualItemsEvent(this.getWebActionFactory(), this.provider.getModel(), actions);
    }

    public PresentationEvent getPropertyItems(String modelId) {
        XFormPresentationXMLObject currentElement = this.getComponentForId(modelId);
        if (currentElement == null) {
            return null;
        }
        return PresentationEvent.buildPropertyItemsEvent(this.getWebActionFactory(), this.provider.getModel(), currentElement);
    }

    public boolean doIgnoringEvents(Command command) {
        this.ignoreSelectionEvents = true;
        boolean result = command.doIt();
        this.ignoreSelectionEvents = false;
        return result;
    }

    public boolean undoIgnoringEvents(Command command) {
        this.ignoreSelectionEvents = true;
        boolean result = command.undoIt();
        this.ignoreSelectionEvents = false;
        return result;
    }

    public void enableToolbarActions(boolean enable) {
        if (this.presentationEditor instanceof PresentationDesignerBrowser) {
            PresentationDesignerBrowser browser = (PresentationDesignerBrowser)this.presentationEditor;
            browser.enableToolbarActions(enable);
        }
    }

    public void startDrag(XFormComponentType type) {
        PresentationEvent droppables = this.getDroppables(type);
        this.eventManager.sendMessage(droppables);
    }

    protected EventManager createEventManager(TransportManager transportManager) {
        return new EventManager(this.selectionBuilder, transportManager, this);
    }

    private static Collection<String> filter(Collection<XOContainerComponent> droppables, Filter filter) {
        ArrayList<String> result = new ArrayList<String>();
        for (XOContainerComponent xoContainerComponent : droppables) {
            if (!filter.accept(xoContainerComponent)) continue;
            XFormPresentationXMLObject presentationObject = xoContainerComponent.getPresentationXMLObject();
            result.add(presentationObject.getId());
        }
        return result;
    }

    private void requestFocus(List<ComponentId> componentIds) {
        this.eventManager.sendMessage(PresentationEvent.buildFocusEvent(componentIds, this.getWebActionFactory(), this.provider.getModel()));
    }

    private ComponentId getComponentId(XFormPresentationXMLObject component) {
        String id = component.getId();
        String presentationId = Utils.getComponentId(component);
        return new ComponentId(id, presentationId);
    }

    private void init(TransportManager transportManager) {
        this.droppables = new HashMap();
        this.provider = new ComponentInteractionProviderImpl(this.dataTreeHelper);
        this.selectionBuilder = new XFormSelectionBuilder(this.provider.getModel(), this.createPropertyRefresher());
        this.eventManager = this.createEventManager(transportManager);
        this.presentationEditor.addSelectionListener(new SelectionListener(){

            public void selectionChanged(Selection newSelection) {
                if (!PresentationManager.this.ignoreSelectionEvents && PresentationManager.this.isListeningToFocus()) {
                    PresentationManager.this.updateFocus(newSelection, true);
                }
            }
        });
    }

    private void updateFocus(Selection newSelection, boolean updateToEmpty) {
        List presentationSelection = newSelection.asList(XFormSelection.class);
        if (presentationSelection != null) {
            ArrayList<ComponentId> list = new ArrayList<ComponentId>();
            for (XFormSelection xFormSelection : presentationSelection) {
                XFormPresentationXMLObject pSelection = xFormSelection.getSelection();
                if (!Utils.isInModel(pSelection)) continue;
                ComponentId componentId = this.getComponentId(pSelection);
                list.add(componentId);
            }
            if (updateToEmpty || list.size() > 0) {
                this.requestFocus(list);
            }
        }
    }

    private PresentationEvent getDroppables(XFormComponentType componentType, final Filter baseFilter) {
        Filter filter = null;
        switch (componentType) {
            case CELL: {
                filter = new TypeFilter(XFormComponentType.ROW, baseFilter);
                break;
            }
            case ROW: {
                filter = new TypeFilter(XFormComponentType.TABLE, baseFilter);
                break;
            }
            default: {
                filter = !componentType.canBeAddedToGroup() ? new Filter(){

                    @Override
                    public boolean accept(XOContainerComponent xoContainerComponent) {
                        return !xoContainerComponent.isGroupColumnComponent() && (baseFilter == null || baseFilter.accept(xoContainerComponent));
                    }
                } : baseFilter;
            }
        }
        Set<String> eventDroppables = filter == null ? this.droppables.keySet() : PresentationManager.filter(this.droppables.values(), filter);
        return PresentationEvent.buildDropEvent(eventDroppables, this.getWebActionFactory(), this.provider.getModel());
    }

    private Command changeHeaderText(String newValue, String modelId, ChangeListener listener) {
        PresentationEvent.ArrayHeaderInfo headerInfo = PresentationEvent.parseHeader(modelId);
        ModifyArrayHeaderCommand result = null;
        if (headerInfo != null) {
            XFormRepeatable repeatable = (XFormRepeatable)this.getComponentForId(headerInfo.getArrayId());
            int index = headerInfo.getIndex();
            result = new ModifyArrayHeaderCommand(repeatable, newValue, listener, index);
        }
        return result;
    }

    private XFormPresentationXMLObject getComponentForId(String modelId) {
        return this.dataTreeHelper.getObjectForKey(modelId);
    }

    private void reloadPresentation() {
        PresentationEvent reloadPresentationMessage = this.buildReloadPresentationEvent();
        this.eventManager.sendMessage(reloadPresentationMessage);
    }

    private PresentationEvent buildReloadPresentationEvent() {
        return this.buildReloadPresentationEvent(true);
    }

    private PresentationEvent buildReloadPresentationEvent(boolean registerComponents) {
        XFormPresentationModel presentationModel = this.provider.getModel();
        PresentationEvent.Load reloadPresentationMessage = new PresentationEvent.Load(this.getWebActionFactory(), presentationModel);
        XFormPresentation presentation = presentationModel.getPresentation();
        if (registerComponents) {
            reloadPresentationMessage.addComponent(presentation);
        }
        this.droppables.clear();
        HTMLBuilderListener listener = registerComponents ? new HTMLBuilderListener(reloadPresentationMessage, this.droppables, this.dataTreeHelper) : null;
        XScreenHTMLImpl xscreen = this.getScreen(listener);
        reloadPresentationMessage.prependLoadMessage(this.getPresentationHTML(xscreen));
        String cssFilename = this.getCssFilename(xscreen);
        if (cssFilename != null) {
            reloadPresentationMessage.setCssFilename(cssFilename);
        }
        return reloadPresentationMessage;
    }

    private String getPresentationHTML(XScreenHTMLImpl xScreen) {
        StringBuffer presentationHTML = new StringBuffer();
        if (xScreen != null) {
            presentationHTML.append("<div style=\"");
            presentationHTML.append(xScreen.getPage().getStyle());
            presentationHTML.append("\">");
            presentationHTML.append(xScreen.getDocumentHtmlText());
            presentationHTML.append("</div>");
        }
        return presentationHTML.toString();
    }

    private XScreenHTMLImpl getScreen(HTMLPresentationBuilder.Listener listener) {
        XScreenHTMLImpl xscreen;
        try {
            xscreen = (XScreenHTMLImpl)this.getEditor(11, this.provider.getModel(), listener);
        }
        catch (Throwable e) {
            xscreen = null;
            if (Log.isDebugging()) {
                Log.logDebug(e);
            }
            MessageDialog.showError((Msg)DesignerMsg.CAN_NOT_PREVIEW, (Msg)DesignerMsg.CAN_NOT_PREVIEW_XOBJECT_HAS_ERRORS, (Throwable)e);
        }
        return xscreen;
    }

    private String getCssFilename(XScreenHTMLImpl xscreen) {
        String result = null;
        if (xscreen != null) {
            FuegoProject fuegoProject;
            String cssFileName;
            HTMLPage htmlPage = xscreen.getPage();
            String string = cssFileName = htmlPage != null ? htmlPage.getCssFilename() : null;
            if (xscreen.isCssEnabled() && cssFileName != null && (fuegoProject = FuegoProject.getFrom((TypeRef)this.provider.getModel().getOwner())) != null) {
                FileProjectWriter projectWriter = (FileProjectWriter)fuegoProject.getWriter();
                List<File> list = FileUtils.getFilesRecursively(WebRoot.getResourcesDir((ProjectWriter)projectWriter), WebContentType.CSS.getFileFilter(true), false);
                for (File file : list) {
                    if (cssFileName.indexOf(file.getName()) == -1) continue;
                    try {
                        URL url = file.toURL();
                        result = url.toString();
                    }
                    catch (MalformedURLException e) {
                        result = file.getAbsolutePath();
                    }
                    break;
                }
            }
        }
        return result;
    }

    private XScreen getEditor(int type, XFormPresentationModel model, HTMLPresentationBuilder.Listener listener) throws ComponentExecutionException, InvalidPresentationException {
        Project project = this.getProject();
        Locale locale = project == null ? Locale.getDefault() : project.getDefaultLanguage();
        return HTMLPresentationBuilder.buildEditorScreen((XFormPresentationModel)model, (Locale)locale, (TimeZone)TimeZone.getDefault(), (HTMLPresentationBuilder.Listener)listener);
    }

    private Project getProject() {
        return FuegoProject.getFrom((TypeRef)this.provider.getModel().getOwner());
    }

    private XFormSelection.PropertyRefresher createPropertyRefresher() {
        return new XFormSelection.PropertyRefresher(){

            @Override
            public void refreshProperties(PropertyTable propertyTable, XFormPresentationXMLObject selection) {
                boolean value = propertyTable.isShowGroupsAsPanels();
                propertyTable.setShowGroupsAsPanels(false);
                this.showSelection(propertyTable, selection);
                propertyTable.setShowGroupsAsPanels(value);
            }

            private void showSelection(PropertyTable propertyTable, XFormPresentationXMLObject selection) {
                ComponentEditor componentEditor = PresentationManager.this.editorRegistry.getEditorFor(selection.getComponentID());
                ComponentProperties componentProperties = componentEditor.createProperties(selection, PresentationManager.this.provider, PresentationManager.this.presentationEditor);
                componentProperties.showProperties(propertyTable);
            }

            private void showSelection(PropertyTable propertyTable, List<XFormPresentationXMLObject> selectionList) {
                ArrayList<ComponentProperties> list = new ArrayList<ComponentProperties>();
                Iterator<XFormPresentationXMLObject> iterator = selectionList.iterator();
                while (iterator.hasNext()) {
                    XFormPresentationXMLObject selection = iterator.next();
                    ComponentEditor componentEditor = PresentationManager.this.editorRegistry.getEditorFor(selection.getComponentID());
                    ComponentProperties componentProperties = componentEditor.createProperties(selection, PresentationManager.this.provider, iterator.hasNext() ? null : PresentationManager.this.presentationEditor);
                    list.add(componentProperties);
                }
                PropertyMerger.showProperties(propertyTable, list, PresentationManager.this.provider);
            }

            @Override
            public void refreshProperties(PropertyTable propertyTable, List<XFormPresentationXMLObject> selectionList) {
                boolean value = propertyTable.isShowGroupsAsPanels();
                propertyTable.setShowGroupsAsPanels(false);
                if (selectionList.size() == 1) {
                    this.showSelection(propertyTable, selectionList.get(0));
                } else {
                    this.showSelection(propertyTable, selectionList);
                }
                propertyTable.setShowGroupsAsPanels(value);
            }
        };
    }

    private class TypeFilter
    implements Filter {
        private Filter baseFilter;
        private XFormComponentType type;

        public TypeFilter(XFormComponentType type, Filter baseFilter) {
            this.type = type;
            this.baseFilter = baseFilter;
        }

        @Override
        public boolean accept(XOContainerComponent xoContainerComponent) {
            int componentType = xoContainerComponent.getPresentationXMLObject().getComponentID();
            return componentType == this.type.getType() && (this.baseFilter == null || this.baseFilter.accept(xoContainerComponent));
        }
    }

    private static class HTMLBuilderListener
    implements HTMLPresentationBuilder.Listener {
        private Map<String, XOContainerComponent> droppables;
        private DataTreeHelper helper;
        private final PresentationEvent.Load reloadPresentationMessage;

        public HTMLBuilderListener(PresentationEvent.Load registerMessages, Map<String, XOContainerComponent> droppables, DataTreeHelper helper) {
            this.reloadPresentationMessage = registerMessages;
            this.droppables = droppables;
            this.helper = helper;
        }

        public void initComponent(XOPresentationComponent component) {
            if (component != null) {
                XFormPresentationXMLObject presentationObject = component.getPresentationXMLObject();
                String id = presentationObject.getId();
                this.helper.addKey(id, presentationObject);
                String componentTypeStr = presentationObject.getName().toUpperCase();
                XFormComponentType componentType = XFormComponentType.getValueOf(componentTypeStr);
                switch (componentType) {
                    case LABEL: {
                        this.reloadPresentationMessage.addEditable(id);
                        this.reloadPresentationMessage.addComponent(presentationObject);
                        break;
                    }
                    case LINK: {
                        XFormLink link = (XFormLink)presentationObject;
                        if (TextType.FIXED.name().equals(link.getTextType())) {
                            this.reloadPresentationMessage.addEditable(id);
                        }
                        this.reloadPresentationMessage.addComponent(presentationObject);
                        break;
                    }
                    case CELL: {
                        this.reloadPresentationMessage.addComponent(presentationObject);
                        if (presentationObject.getChildCount() != 0) break;
                        this.droppables.put(id, (XOContainerComponent)component);
                        break;
                    }
                    case ARRAY: 
                    case REPEATABLESECTION: {
                        this.reloadPresentationMessage.addComponent(presentationObject);
                        this.reloadPresentationMessage.addGroupEditable((XFormRepeatable)presentationObject);
                        break;
                    }
                    default: {
                        this.reloadPresentationMessage.addComponent(presentationObject);
                    }
                }
            }
        }
    }

    private static interface Filter {
        public boolean accept(XOContainerComponent var1);
    }
}

