/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.web;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.bpm.designer.formdesigner.web.Utils;
import oracle.bpm.designer.formdesigner.web.WebActionFactory;
import oracle.bpm.designer.formdesigner.web.WebPropertyBuilder;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.utils.FontUtils;
import oracle.bpm.util.SystemInfo;
import oracle.bpm.web.formdesigner.protocol.ApplicationAddMessageValue;
import oracle.bpm.web.formdesigner.protocol.ApplicationMessage;
import oracle.bpm.web.formdesigner.protocol.ApplicationMessageAction;
import oracle.bpm.web.formdesigner.protocol.ApplicationMessageValue;
import oracle.bpm.web.formdesigner.protocol.ComponentContextAction;
import oracle.bpm.web.formdesigner.protocol.ComponentId;
import oracle.bpm.web.formdesigner.protocol.GroupValue;
import oracle.bpm.web.formdesigner.protocol.InitializationValue;
import oracle.bpm.web.formdesigner.protocol.MenuValue;
import oracle.bpm.web.formdesigner.protocol.PropertiesValue;
import oracle.bpm.web.formdesigner.protocol.PropertyValue;
import oracle.bpm.web.formdesigner.protocol.RegisterValue;
import oracle.bpm.webformdesigner.msg.WebformdesignerMsg;
import oracle.bpm.xobject.presentationmodel.XFormComponentType;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModel;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModelHelper;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.presentationmodel.XFormRepeatable;
import oracle.bpm.xobject.runtime.presentationComponents.ComponentIdFactory;

public abstract class PresentationEvent {
    protected static final boolean EXISTS_KEY_BUG = !SystemInfo.isLinux();

    public abstract ApplicationMessage getApplicationMessage();

    public static PresentationEvent buildDropEvent(Collection<String> eventDroppables, WebActionFactory webActionFactory, XFormPresentationModel model) {
        return new DropPresentationEvent(webActionFactory, model, eventDroppables);
    }

    public static PresentationEvent buildContextualItemsEvent(WebActionFactory webActionFactory, XFormPresentationModel model, ComponentContextAction[] actions) {
        return new ContextualItemsEvent(webActionFactory, model, actions);
    }

    public static PresentationEvent buildPropertyItemsEvent(WebActionFactory webActionFactory, XFormPresentationModel model, XFormPresentationXMLObject currentElement) {
        return new PropertyItemsEvent(webActionFactory, model, currentElement);
    }

    public static PresentationEvent buildInitializationEvent() {
        return new InitializationEvent();
    }

    public static PresentationEvent buildFocusEvent(List<ComponentId> componentIds, WebActionFactory webActionFactory, XFormPresentationModel model) {
        return new FocusPresentationEvent(webActionFactory, model, componentIds);
    }

    public static ArrayHeaderInfo parseHeader(String header) {
        if (header.endsWith("]_label")) {
            int posfixLength = "]_label".length();
            int arrayNameEnd = header.length() - 2 - posfixLength;
            String index = header.substring(arrayNameEnd + 1, header.length() - posfixLength);
            String array = header.substring(0, arrayNameEnd);
            return new ArrayHeaderInfo(array, Integer.parseInt(index));
        }
        return null;
    }

    private static class PropertyItemsEvent
    extends ModelEvent {
        private ApplicationMessage contextualItemsMessage;

        public PropertyItemsEvent(WebActionFactory webActionFactory, XFormPresentationModel model, XFormPresentationXMLObject component) {
            super(webActionFactory, model);
            PropertiesValue value = new PropertiesValue();
            WebPropertyBuilder.addPropertiesTitle(component, value);
            boolean isCssEnabled = model.getPresentation().isCssEnabled();
            WebPropertyBuilder.addProperties(value, component, isCssEnabled);
            this.contextualItemsMessage = ApplicationMessage.newApplicationMessage((ApplicationMessageAction)ApplicationMessageAction.CONTEXTUAL_ITEMS, (ApplicationMessageValue)ApplicationMessageValue.newPropertiesItemsValue((PropertiesValue)value));
        }

        @Override
        public ApplicationMessage getApplicationMessage() {
            return this.contextualItemsMessage;
        }
    }

    private static class InitializationEvent
    extends PresentationEvent {
        private ApplicationMessage initializationMessage;

        public InitializationEvent() {
            this.buildMsg();
        }

        @Override
        public ApplicationMessage getApplicationMessage() {
            return this.initializationMessage;
        }

        public InitializationValue getToolbarMsgInitValue() {
            InitializationValue msgValue = new InitializationValue();
            for (Msg msg : WebformdesignerMsg.webFormDesignerMsgs) {
                this.addMsg(msgValue, msg);
            }
            return msgValue;
        }

        public InitializationValue getFontInitValue() {
            String[] fontNames;
            InitializationValue result = new InitializationValue();
            for (String fontName : fontNames = FontUtils.getAvailableFontFamilyNames()) {
                result.addStringValue(fontName);
            }
            return result;
        }

        private void buildMsg() {
            ArrayList<ApplicationMessage> applicationMessages = new ArrayList<ApplicationMessage>();
            InitializationValue msgValue = this.getToolbarMsgInitValue();
            InitializationValue fontValue = this.getFontInitValue();
            ApplicationMessage addKeyListenerMsg = ApplicationMessage.newApplicationMessage((ApplicationMessageAction)ApplicationMessageAction.ADD_KEY_LISTENERS, (ApplicationMessageValue)ApplicationAddMessageValue.newBooleanValue((boolean)EXISTS_KEY_BUG));
            ApplicationMessage i18nMessage = ApplicationMessage.newApplicationMessage((ApplicationMessageAction)ApplicationMessageAction.TOOLBAR_MSGS, (ApplicationMessageValue)ApplicationAddMessageValue.newInitializationValue((InitializationValue)msgValue));
            ApplicationMessage fontMessage = ApplicationMessage.newApplicationMessage((ApplicationMessageAction)ApplicationMessageAction.FONT_LIST, (ApplicationMessageValue)ApplicationAddMessageValue.newInitializationValue((InitializationValue)fontValue));
            DesignerPreferences designerPreferences = DesignerPreferences.getPreferences();
            String droppableBgColor = designerPreferences.getPresentationDroppableBgColor();
            ApplicationMessage droppableBgColorMessage = ApplicationMessage.newApplicationMessage((ApplicationMessageAction)ApplicationMessageAction.DROPPABLE_BACKGROUND_COLOR, (ApplicationMessageValue)ApplicationAddMessageValue.newStringValue((String)droppableBgColor));
            String droppableBorderColor = designerPreferences.getPresentationDroppableBorderColor();
            ApplicationMessage droppableBorderColorMessage = ApplicationMessage.newApplicationMessage((ApplicationMessageAction)ApplicationMessageAction.DROPPABLE_BORDER_COLOR, (ApplicationMessageValue)ApplicationAddMessageValue.newStringValue((String)droppableBorderColor));
            String dropOverBgColor = designerPreferences.getPresentationDropOverBgColor();
            ApplicationMessage dropOverBgColorMessage = ApplicationMessage.newApplicationMessage((ApplicationMessageAction)ApplicationMessageAction.DROPPABLE_OVER_BACKGROUND_COLOR, (ApplicationMessageValue)ApplicationAddMessageValue.newStringValue((String)dropOverBgColor));
            String focusableBorderColor = designerPreferences.getPresentationFocusableBorderColor();
            if (focusableBorderColor != null) {
                ApplicationMessage focusableBorderColorMessage = ApplicationMessage.newApplicationMessage((ApplicationMessageAction)ApplicationMessageAction.FOCUS_COLOR, (ApplicationMessageValue)ApplicationAddMessageValue.newStringValue((String)focusableBorderColor));
                applicationMessages.add(focusableBorderColorMessage);
            }
            int cellPadding = designerPreferences.getPresentationEditorCellPadding();
            ApplicationMessage cellPaddingMessage = ApplicationMessage.newApplicationMessage((ApplicationMessageAction)ApplicationMessageAction.TABLE_CELL_PADDING, (ApplicationMessageValue)ApplicationAddMessageValue.newStringValue((String)(cellPadding + "")));
            int cellSpacing = designerPreferences.getPresentationEditorCellSpacing();
            ApplicationMessage cellSpacingMessage = ApplicationMessage.newApplicationMessage((ApplicationMessageAction)ApplicationMessageAction.TABLE_CELL_SPACING, (ApplicationMessageValue)ApplicationAddMessageValue.newStringValue((String)(cellSpacing + "")));
            applicationMessages.add(addKeyListenerMsg);
            applicationMessages.add(i18nMessage);
            applicationMessages.add(fontMessage);
            applicationMessages.add(droppableBgColorMessage);
            applicationMessages.add(droppableBorderColorMessage);
            applicationMessages.add(dropOverBgColorMessage);
            applicationMessages.add(cellPaddingMessage);
            applicationMessages.add(cellSpacingMessage);
            GroupValue groupValue = new GroupValue(applicationMessages);
            this.initializationMessage = ApplicationMessage.newApplicationMessage((ApplicationMessageAction)ApplicationMessageAction.GROUP_ACTION, (ApplicationMessageValue)ApplicationMessageValue.newGroupValue((GroupValue)groupValue));
        }

        private void addMsg(InitializationValue msgValue, Msg msg) {
            msgValue.addPropertyValue(new PropertyValue(msg.getCode(), msg.toString()));
        }
    }

    private static class FocusPresentationEvent
    extends ModelEvent {
        private ApplicationMessage focusMessage;

        public FocusPresentationEvent(WebActionFactory webActionFactory, XFormPresentationModel model, List<ComponentId> componentIds) {
            super(webActionFactory, model);
            this.addFocusables(componentIds);
        }

        @Override
        public ApplicationMessage getApplicationMessage() {
            return this.focusMessage;
        }

        private void addFocusables(List<ComponentId> componentIds) {
            this.focusMessage = ApplicationMessage.newApplicationMessage((ApplicationMessageAction)ApplicationMessageAction.FOCUS, componentIds);
        }
    }

    private static class DropPresentationEvent
    extends ModelEvent {
        private ApplicationMessage droppablesMessage;

        public DropPresentationEvent(WebActionFactory webActionFactory, XFormPresentationModel model, Collection<String> eventDroppables) {
            super(webActionFactory, model);
            this.addDroppables(eventDroppables);
        }

        @Override
        public ApplicationMessage getApplicationMessage() {
            return this.droppablesMessage;
        }

        private void addDroppables(Collection<String> modelIds) {
            ArrayList<ComponentId> droppableIds = new ArrayList<ComponentId>(modelIds.size());
            for (String modelId : modelIds) {
                droppableIds.add(new ComponentId(modelId, ComponentIdFactory.buildComponentId((String)modelId)));
            }
            this.droppablesMessage = ApplicationMessage.newApplicationMessage((ApplicationMessageAction)ApplicationMessageAction.DROPPABLES, droppableIds);
        }
    }

    private static class ContextualItemsEvent
    extends ModelEvent {
        private ApplicationMessage contextualItemsMessage;

        public ContextualItemsEvent(WebActionFactory webActionFactory, XFormPresentationModel model, ComponentContextAction[] actions) {
            super(webActionFactory, model);
            MenuValue value = new MenuValue();
            for (ComponentContextAction action : actions) {
                value.addValue(action);
            }
            this.contextualItemsMessage = ApplicationMessage.newApplicationMessage((ApplicationMessageAction)ApplicationMessageAction.CONTEXTUAL_ITEMS, (ApplicationMessageValue)ApplicationMessageValue.newMenuItemsValue((MenuValue)value));
        }

        @Override
        public ApplicationMessage getApplicationMessage() {
            return this.contextualItemsMessage;
        }
    }

    private static abstract class ModelEvent
    extends PresentationEvent {
        protected XFormPresentationModel model;
        protected WebActionFactory webActionFactory;

        public ModelEvent(WebActionFactory webActionFactory, XFormPresentationModel model) {
            this.webActionFactory = webActionFactory;
            this.model = model;
        }
    }

    public static class Load
    extends ModelEvent {
        protected List<ApplicationMessage> applicationMessages = new ArrayList<ApplicationMessage>();

        public Load(WebActionFactory webActionFactory, XFormPresentationModel model) {
            super(webActionFactory, model);
        }

        public void addEditable(String id) {
            this.applicationMessages.add(this.createEditableMessage(id));
        }

        public void addComponent(XFormPresentationXMLObject component) {
            this.applicationMessages.add(this.createRegisterMessage(component));
        }

        public void prependLoadMessage(String html) {
            ComponentId presentationId = new ComponentId("");
            ApplicationMessageValue loadValue = ApplicationMessageValue.newStringValue((String)html);
            ApplicationMessage reloadMessage = ApplicationMessage.newApplicationMessage((ApplicationMessageAction)ApplicationMessageAction.LOAD, (ComponentId)presentationId, (ApplicationMessageValue)loadValue);
            this.applicationMessages.add(0, reloadMessage);
        }

        public void setCssFilename(String cssFilename) {
            ApplicationMessage focusMessage = ApplicationMessage.newApplicationMessage((ApplicationMessageAction)ApplicationMessageAction.CSS, (ApplicationMessageValue)ApplicationMessageValue.newStringValue((String)cssFilename));
            this.applicationMessages.add(focusMessage);
        }

        public void addGroupEditable(XFormRepeatable presentationObject) {
            String id = presentationObject.getId();
            String[] headers = presentationObject.headers;
            if (headers != null && presentationObject.isHeaderenabled()) {
                int headersLength = headers.length;
                for (int i = 0; i < headersLength; ++i) {
                    String editableId = ComponentIdFactory.buildGroupHeaderId((String)id, (int)i);
                    String modelId = id + "[" + i + "]_label";
                    ApplicationMessageAction action = ApplicationMessageAction.EDITABLE;
                    ComponentId componentID = new ComponentId(modelId, editableId);
                    ApplicationMessage msg = ApplicationMessage.newApplicationMessage((ApplicationMessageAction)action, (ComponentId)componentID);
                    this.applicationMessages.add(msg);
                }
            }
        }

        @Override
        public ApplicationMessage getApplicationMessage() {
            return this.getApplicationMessageGroup();
        }

        public ApplicationMessage getApplicationMessageGroup() {
            GroupValue groupValue = new GroupValue(this.applicationMessages);
            return ApplicationMessage.newApplicationMessage((ApplicationMessageAction)ApplicationMessageAction.GROUP_ACTION, (ApplicationMessageValue)ApplicationMessageValue.newGroupValue((GroupValue)groupValue));
        }

        private ApplicationMessage createEditableMessage(String id) {
            String editableId = ComponentIdFactory.buildEditableTextComponentId((String)id);
            ApplicationMessageAction action = ApplicationMessageAction.EDITABLE;
            ComponentId componentID = new ComponentId(id, editableId);
            return ApplicationMessage.newApplicationMessage((ApplicationMessageAction)action, (ComponentId)componentID);
        }

        private ApplicationMessage createRegisterMessage(XFormPresentationXMLObject component) {
            XFormComponentType componentType = component.getComponentType();
            String focusId = Utils.getComponentId(component);
            ComponentId componentID = new ComponentId(component.getId(), focusId);
            RegisterValue registerValue = new RegisterValue();
            registerValue.setComponentType(componentType);
            boolean canMove = componentType != XFormComponentType.PRESENTATION && componentType != XFormComponentType.ROW && componentType != XFormComponentType.CELL && !XFormPresentationModelHelper.isTopLevelLayout(component);
            boolean isOverlay = componentType == XFormComponentType.GAUGE || componentType == XFormComponentType.PIE || componentType == XFormComponentType.CHART || componentType == XFormComponentType.IFRAME;
            registerValue.setMoveable(canMove);
            registerValue.setOverlayed(isOverlay);
            ApplicationMessageValue componentTypeRegisterValue = ApplicationMessageValue.newRegisterValue((RegisterValue)registerValue);
            return ApplicationMessage.newApplicationMessage((ApplicationMessageAction)ApplicationMessageAction.REGISTER, (ComponentId)componentID, (ApplicationMessageValue)componentTypeRegisterValue);
        }
    }

    public static class ArrayHeaderInfo {
        private String arrayId;
        private int index;

        public ArrayHeaderInfo(String arrayId, int index) {
            this.index = index;
            this.arrayId = arrayId;
        }

        public int getIndex() {
            return this.index;
        }

        public String getArrayId() {
            return this.arrayId;
        }
    }
}

