/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.web;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import oracle.bpm.designer.formdesigner.PresentationDesignerBrowser;
import oracle.bpm.designer.formdesigner.XFormSelectionBuilder;
import oracle.bpm.designer.formdesigner.web.PresentationEvent;
import oracle.bpm.designer.formdesigner.web.PresentationManager;
import oracle.bpm.designer.formdesigner.web.TransportManager;
import oracle.bpm.log.Log;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.web.formdesigner.protocol.ApplicationAddMessageValue;
import oracle.bpm.web.formdesigner.protocol.ApplicationCTODragMessageValue;
import oracle.bpm.web.formdesigner.protocol.ApplicationErrorMessageValue;
import oracle.bpm.web.formdesigner.protocol.ApplicationKeyMessageValue;
import oracle.bpm.web.formdesigner.protocol.ApplicationMessage;
import oracle.bpm.web.formdesigner.protocol.ApplicationMessageAction;
import oracle.bpm.web.formdesigner.protocol.ApplicationMessageValue;
import oracle.bpm.web.formdesigner.protocol.ApplicationPropertyMessageValue;
import oracle.bpm.web.formdesigner.protocol.ComponentId;
import oracle.bpm.web.formdesigner.protocol.PropertyValue;
import oracle.bpm.xobject.presentationmodel.XFormComponentType;

public class EventManager {
    private XFormSelectionBuilder builder;
    private boolean isBrowserLoaded = false;
    private boolean isBrowserReady = false;
    private PresentationManager presentationManager;
    private List<PresentationEvent> queue;
    private TransportManager transportManager;

    public EventManager(XFormSelectionBuilder builder, TransportManager transportManager, PresentationManager presentationManager) {
        this.builder = builder;
        this.transportManager = transportManager;
        this.presentationManager = presentationManager;
        this.queue = new ArrayList<PresentationEvent>();
        transportManager.setEventManager(this);
    }

    public ApplicationMessage processEditorEvent(final ApplicationMessage message) {
        PresentationEvent answer = null;
        ApplicationMessageAction messageType = message.getAction();
        switch (messageType) {
            case ERROR: {
                ApplicationErrorMessageValue value = (ApplicationErrorMessageValue)message.getValue();
                this.presentationManager.processError(value.toString());
                break;
            }
            case WARNING: {
                ApplicationErrorMessageValue value = (ApplicationErrorMessageValue)message.getValue();
                this.presentationManager.processWarning(value.toString());
                break;
            }
            case FOCUS: {
                this.invoke(new Runnable(){

                    @Override
                    public void run() {
                        EventManager.this.focusGained(message.getComponentIds());
                    }
                });
                break;
            }
            case LOG: {
                ApplicationErrorMessageValue value = (ApplicationErrorMessageValue)message.getValue();
                if (value.isReadyMessage()) {
                    this.processReady();
                    break;
                }
                if (value.isLoadingFinishedMessage()) {
                    this.processLoaded();
                    break;
                }
                if (!Log.isDebugging()) break;
                Log.logDebug(value.toString());
                break;
            }
            case CTOS_DRAG: {
                this.invoke(new Runnable(){

                    @Override
                    public void run() {
                        ApplicationCTODragMessageValue appMessageValue = (ApplicationCTODragMessageValue)message.getValue();
                        EventManager.this.presentationManager.processCTODrag(appMessageValue);
                    }
                });
                break;
            }
            case DROPPABLES: {
                List ids = message.getComponentIds();
                if (ids != null && ids.size() > 0) {
                    String modelId = ((ComponentId)ids.get(0)).getModelId();
                    answer = this.presentationManager.getDroppables(modelId);
                    break;
                }
                ApplicationMessageValue messageValue = message.getValue();
                String componentTypeString = messageValue.getStringValue();
                XFormComponentType componentType = XFormComponentType.getValueOf(componentTypeString);
                answer = this.presentationManager.getDroppables(componentType);
                break;
            }
            case CONTEXTUAL_ITEMS: {
                List componentIds = message.getComponentIds();
                if (componentIds == null || componentIds.size() <= 0) break;
                String modelId = ((ComponentId)componentIds.get(0)).getModelId();
                answer = this.presentationManager.getContexutalItems(modelId);
                break;
            }
            case PROPERTY_ITEMS: {
                List componentIds = message.getComponentIds();
                if (componentIds == null || componentIds.size() <= 0) break;
                String modelId = ((ComponentId)componentIds.get(0)).getModelId();
                answer = this.presentationManager.getPropertyItems(modelId);
                break;
            }
            case MOVE: {
                this.invoke(new Runnable(){

                    @Override
                    public void run() {
                        EventManager.this.moveComponent((ComponentId)message.getComponentIds().get(0), message.getValue());
                    }
                });
                break;
            }
            case ADD: {
                this.invoke(new Runnable(){

                    @Override
                    public void run() {
                        EventManager.this.addComponent((ComponentId)message.getComponentIds().get(0), message.getValue());
                    }
                });
                break;
            }
            case RUN_COMMAND: {
                this.invoke(new Runnable(){

                    @Override
                    public void run() {
                        EventManager.this.runCommand((ComponentId)message.getComponentIds().get(0), message.getValue());
                    }
                });
                break;
            }
            case CHANGE: {
                this.invoke(new Runnable(){

                    @Override
                    public void run() {
                        EventManager.this.changeValue((ComponentId)message.getComponentIds().get(0), (ApplicationPropertyMessageValue)message.getValue());
                    }
                });
            }
            case KEY_EVENT: {
                this.invoke(new Runnable(){

                    @Override
                    public void run() {
                        ApplicationMessageValue value = message.getValue();
                        if (value instanceof ApplicationKeyMessageValue) {
                            ApplicationKeyMessageValue keyMessageValue = (ApplicationKeyMessageValue)value;
                            EventManager.this.presentationManager.processKey(keyMessageValue);
                        }
                    }
                });
                break;
            }
            case FLASH_NOT_INSTALLED: {
                this.invoke(new Runnable(){

                    @Override
                    public void run() {
                        new PresentationDesignerBrowser.InstallFlash().run();
                    }
                });
                break;
            }
        }
        return answer == null ? null : answer.getApplicationMessage();
    }

    public void sendMessage(PresentationEvent event) {
        if (this.canSend(event)) {
            this.transportManager.sendPresentationEvent(event);
        } else {
            this.queue.add(event);
        }
    }

    public void setReady(boolean ready) {
        this.isBrowserReady = ready;
    }

    public void setLoaded(boolean loaded) {
        this.isBrowserLoaded = loaded;
    }

    protected void invoke(Runnable runnable) {
        UiUtilities.invokeLater((Runnable)runnable);
    }

    private boolean canSend(PresentationEvent event) {
        boolean needsLoadingToBeFinished = event.getApplicationMessage().getAction().needsLoadingToBeFinished();
        return this.isBrowserLoaded || this.isBrowserReady && !needsLoadingToBeFinished;
    }

    private void processReady() {
        this.invoke(new Runnable(){

            @Override
            public void run() {
                EventManager.this.isBrowserReady = true;
                EventManager.this.sendQueuedMessages();
            }
        });
    }

    private void processLoaded() {
        this.invoke(new Runnable(){

            @Override
            public void run() {
                EventManager.this.isBrowserLoaded = true;
                EventManager.this.presentationManager.enableToolbarActions(true);
                EventManager.this.sendQueuedMessages();
            }
        });
    }

    private void sendQueuedMessages() {
        ArrayList<PresentationEvent> toBeRemoved = new ArrayList<PresentationEvent>();
        for (PresentationEvent presentationEvent : this.queue) {
            if (!this.canSend(presentationEvent)) continue;
            this.transportManager.sendPresentationEvent(presentationEvent);
            toBeRemoved.add(presentationEvent);
        }
        this.queue.removeAll(toBeRemoved);
    }

    private PresentationEvent moveComponent(ComponentId componentId, ApplicationMessageValue value) {
        String draggedComponentId = componentId.getModelId();
        String parentId = value.getStringValue();
        return this.presentationManager.moveComponent(parentId, draggedComponentId);
    }

    private void changeValue(ComponentId componentId, ApplicationPropertyMessageValue value) {
        String modelId = componentId.getModelId();
        PropertyValue[] propertyValues = value.getPropertyValues();
        this.presentationManager.changeValues(propertyValues, modelId);
    }

    private void runCommand(ComponentId componentId, ApplicationMessageValue value) {
        String modelId = componentId.getModelId();
        String commandId = value.getStringValue();
        this.presentationManager.runCommand(commandId, modelId);
    }

    private PresentationEvent addComponent(ComponentId componentId, ApplicationMessageValue value) {
        String parentId = componentId.getModelId();
        String componentTypeString = value.getStringValue();
        ApplicationAddMessageValue addMessageValue = (ApplicationAddMessageValue)value;
        String cols = addMessageValue.getColumns();
        String rows = addMessageValue.getRows();
        Properties properties = new Properties();
        if (cols != null) {
            properties.put("columns", Integer.valueOf(cols));
        }
        if (rows != null) {
            properties.put("rows", Integer.valueOf(rows));
        }
        XFormComponentType type = XFormComponentType.getValueOf(componentTypeString);
        return this.presentationManager.addComponent(parentId, type, properties);
    }

    private void focusGained(List<ComponentId> componentIds) {
        ArrayList<String> ids = new ArrayList<String>();
        for (ComponentId componentId : componentIds) {
            ids.add(componentId.getModelId());
        }
        Selection selection = this.builder.buildSelection(ids);
        this.presentationManager.setSelection(selection);
    }
}

