/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.web;

import java.util.ArrayList;
import oracle.bpm.designer.formdesigner.command.AddDataCommand;
import oracle.bpm.designer.formdesigner.command.Command;
import oracle.bpm.designer.formdesigner.command.CompoundCommand;
import oracle.bpm.designer.formdesigner.command.MoveDataCommand;
import oracle.bpm.designer.formdesigner.outline.DataTreeHelper;
import oracle.bpm.designer.formdesigner.outline.PresentationStructureView;
import oracle.bpm.designer.formdesigner.web.RefreshCommand;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.util.Properties;
import oracle.bpm.web.formdesigner.protocol.ApplicationCTODragMessageValue;
import oracle.bpm.xobject.presentationmodel.XFormCell;
import oracle.bpm.xobject.presentationmodel.XFormComponentType;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.presentationmodel.XFormRow;
import oracle.bpm.xobject.presentationmodel.XFormTable;
import oracle.bpm.xobject.xml.XFormXMLObject;

public class CTODragCommandBuilder {
    private ApplicationCTODragMessageValue appMessageValue;
    private Command ctoCommand;
    private XFormCell dragDestination;
    private DataTreeHelper helper;
    private PresentationStructureView view;

    private CTODragCommandBuilder(DataTreeHelper helper, PresentationStructureView view, ApplicationCTODragMessageValue appMessageValue) {
        this.helper = helper;
        this.view = view;
        this.appMessageValue = appMessageValue;
    }

    public static Command buildCommand(DataTreeHelper helper, PresentationStructureView view, ApplicationCTODragMessageValue appMessageValue) {
        CTODragCommandBuilder result = new CTODragCommandBuilder(helper, view, appMessageValue);
        result.buildCommands();
        return result.getCtoCommand();
    }

    private void buildCommands() {
        CompoundCommand command = new CompoundCommand(new ArrayList(), "CTODrag");
        ApplicationCTODragMessageValue.CTOTableStructure structure = this.appMessageValue.getStructure();
        String dest = this.appMessageValue.getDest();
        this.processCTOStructureDrag(structure, dest, command);
        if (this.dragDestination != null) {
            if (this.appMessageValue.isAdd()) {
                String componentType = this.appMessageValue.getAddComponentType();
                Properties properties = this.appMessageValue.getAddProperties();
                command.addCommand(this.createAddCommand(componentType, properties));
            } else {
                command.addCommand(this.createMoveEvent(this.appMessageValue.getMoveId()));
            }
        }
        this.ctoCommand = RefreshCommand.addRefresh((Command)command, this.view);
    }

    private AddDataCommand createAddCommand(String componentType, Properties properties) {
        XFormComponentType type = XFormComponentType.getValueOf(componentType);
        AddDataCommand command = AddDataCommand.newWithId(this.dragDestination, type, this.view);
        command.setFireEvents(false);
        command.setSelect(false);
        if (type == XFormComponentType.TABLE) {
            XFormTable table = (XFormTable)command.getAddedObject();
            table.expand((Integer)properties.get("rows"), (Integer)properties.get("columns"));
        }
        return command;
    }

    private MoveDataCommand createMoveEvent(String moveId) {
        XFormCell parent = this.dragDestination;
        XFormPresentationXMLObject component = this.helper.getObjectForKey(moveId);
        MoveDataCommand result = new MoveDataCommand(this.view, parent, component);
        result.setFireEvents(false);
        return result;
    }

    private void processCTOStructureDrag(ApplicationCTODragMessageValue.CTOTableStructure structure, String dest, CompoundCommand command) {
        String tableId = structure.getId();
        XFormTable table = (XFormTable)this.helper.getObjectForKey(tableId);
        ApplicationCTODragMessageValue.CTOTableRow[] rows = structure.getRows();
        XFormRow[] tableRows = table.row;
        int newIndex = 0;
        int oldIndex = 0;
        while (newIndex < rows.length) {
            ApplicationCTODragMessageValue.CTOTableRow newRow = rows[newIndex];
            XFormRow oldRow = oldIndex < tableRows.length ? tableRows[oldIndex] : null;
            String newRowId = newRow.getId();
            if (oldRow == null || !newRowId.equals(oldRow.getId())) {
                this.addRow(newRow, newIndex, table, command, dest);
                ++newIndex;
            } else {
                this.transformRow(newRow, oldRow, command, dest);
            }
            ++newIndex;
            ++oldIndex;
        }
    }

    private void addRow(ApplicationCTODragMessageValue.CTOTableRow row, int newIndex, XFormTable table, CompoundCommand commands, String dest) {
        ApplicationCTODragMessageValue.CTOTableCell[] cells;
        XFormRow newRow = new XFormRow();
        AddDataCommand addDataCommand = new AddDataCommand((XFormXMLObject)table, newRow, this.view, newIndex);
        addDataCommand.setFireEvents(false);
        addDataCommand.setSelect(false);
        commands.addCommand(addDataCommand);
        for (ApplicationCTODragMessageValue.CTOTableCell cell : cells = row.getCells()) {
            XFormCell newCell = this.buildCell(cell, dest);
            AddDataCommand addCellCommand = new AddDataCommand((XFormXMLObject)newRow, newCell, this.view);
            addCellCommand.setFireEvents(false);
            addCellCommand.setSelect(false);
            commands.addCommand(addCellCommand);
        }
    }

    private XFormCell buildCell(ApplicationCTODragMessageValue.CTOTableCell cell, String dest) {
        XFormCell result = new XFormCell();
        result.setHexpand(cell.getColspan());
        result.setVexpand(cell.getRowspan());
        if (dest.equals(cell.getId())) {
            this.dragDestination = result;
        }
        return result;
    }

    private void transformRow(ApplicationCTODragMessageValue.CTOTableRow row, XFormRow xFormRow, CompoundCommand command, String dest) {
        ApplicationCTODragMessageValue.CTOTableCell[] cells = row.getCells();
        XFormCell[] rowCells = xFormRow.cell;
        int newIndex = 0;
        int oldIndex = 0;
        while (newIndex < cells.length) {
            ApplicationCTODragMessageValue.CTOTableCell newCell = cells[newIndex];
            XFormCell oldCell = oldIndex < rowCells.length ? rowCells[oldIndex] : null;
            String newCellId = newCell.getId();
            if (oldCell == null || !newCellId.equals(oldCell.getId())) {
                this.addCell(newCell, newIndex, xFormRow, command, dest);
                ++newIndex;
            } else {
                this.transformCell(newCell, oldCell, command, dest);
            }
            ++newIndex;
            ++oldIndex;
        }
    }

    private void addCell(ApplicationCTODragMessageValue.CTOTableCell cell, int newIndex, XFormRow xFormRow, CompoundCommand commands, String dest) {
        XFormCell newCell = this.buildCell(cell, dest);
        AddDataCommand addDataCommand = new AddDataCommand((XFormXMLObject)xFormRow, newCell, this.view, newIndex);
        addDataCommand.setFireEvents(false);
        addDataCommand.setSelect(false);
        commands.addCommand(addDataCommand);
    }

    private void transformCell(ApplicationCTODragMessageValue.CTOTableCell cell, XFormCell xFormCell, CompoundCommand commands, String dest) {
        if (cell.getId().equals(dest)) {
            this.dragDestination = xFormCell;
        }
        if (cell.getColspan() != xFormCell.getHexpand()) {
            commands.addCommand(new ModifyCellHexpandCommand(xFormCell, cell));
        }
        if (cell.getRowspan() != xFormCell.getVexpand()) {
            commands.addCommand(new ModifyCellVexpandCommand(xFormCell, cell));
        }
    }

    private Command getCtoCommand() {
        return this.ctoCommand;
    }

    private static class ModifyCellVexpandCommand
    extends Command {
        public int oldValue;
        private int newValue;
        private final XFormCell xFormCell;

        public ModifyCellVexpandCommand(XFormCell xFormCell, ApplicationCTODragMessageValue.CTOTableCell cell) {
            this.xFormCell = xFormCell;
            this.newValue = cell.getRowspan();
        }

        @Override
        public Msg getMsg() {
            return DesignerMsg.MODIFIED_COMMAND("vexpand", "" + this.newValue);
        }

        @Override
        public boolean doIt() {
            this.oldValue = this.xFormCell.getVexpand();
            this.xFormCell.setVexpand(this.newValue);
            return true;
        }

        @Override
        public boolean undoIt() {
            this.xFormCell.setVexpand(this.oldValue);
            return true;
        }
    }

    private static class ModifyCellHexpandCommand
    extends Command {
        public int oldValue;
        private int newValue;
        private final XFormCell xFormCell;

        public ModifyCellHexpandCommand(XFormCell xFormCell, ApplicationCTODragMessageValue.CTOTableCell cell) {
            this.xFormCell = xFormCell;
            this.newValue = cell.getColspan();
        }

        @Override
        public Msg getMsg() {
            return DesignerMsg.MODIFIED_COMMAND("hexpand", "" + this.newValue);
        }

        @Override
        public boolean doIt() {
            this.oldValue = this.xFormCell.getHexpand();
            this.xFormCell.setHexpand(this.newValue);
            return true;
        }

        @Override
        public boolean undoIt() {
            this.xFormCell.setHexpand(this.oldValue);
            return true;
        }
    }
}

