/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.toolbar;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.AbstractEditor;
import oracle.bpm.designer.formdesigner.PresentationDesignerPanel;
import oracle.bpm.designer.formdesigner.ToolbarListener;
import oracle.bpm.designer.formdesigner.toolbar.AlignManager;
import oracle.bpm.designer.formdesigner.toolbar.BorderManager;
import oracle.bpm.designer.formdesigner.toolbar.ColorManager;
import oracle.bpm.designer.formdesigner.toolbar.FontManager;
import oracle.bpm.designer.formdesigner.toolbar.FormatActionManager;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.action.BaseAction;

public class FormatToolbarManager {
    private List<BaseAction> actions;
    private List<FormatActionManager> formatManagers;
    private PresentationDesignerPanel presentationDesignerPanel;
    private ToolbarListener.ToolbarInteractions toolbarInteractions;
    static final String MODIFIER = "Toolbar modifier";

    public FormatToolbarManager(PresentationDesignerPanel panel) {
        this.presentationDesignerPanel = panel;
        this.actions = new ArrayList<BaseAction>();
        this.initManagers();
    }

    public ToolBar initFormatToolbar(ToolBar formatToolbar) {
        for (FormatActionManager manager : this.formatManagers) {
            this.actions.addAll(manager.createActions(this, formatToolbar));
            formatToolbar.addSeparator();
        }
        return formatToolbar;
    }

    public ToolbarListener.ToolbarInteractions getToolbarInteractions() {
        return this.toolbarInteractions;
    }

    public void setAvaliable(int avaliableActions, ToolbarListener.ToolbarInteractions toolbarInteractions) {
        boolean isReadWrite = !this.presentationDesignerPanel.isReadOnly();
        for (FormatActionManager manager : this.formatManagers) {
            manager.setAvaliable(isReadWrite, avaliableActions);
        }
        for (BaseAction action : this.actions) {
            Integer modifier = (Integer)action.getValue(MODIFIER);
            action.setEnabled(isReadWrite && (avaliableActions & modifier) != 0);
        }
        this.toolbarInteractions = toolbarInteractions;
        for (FormatActionManager manager : this.formatManagers) {
            manager.refresh(this, this.toolbarInteractions);
        }
    }

    protected AbstractEditor getPresentationDesignerPanel() {
        return this.presentationDesignerPanel;
    }

    void refreshProperties() {
        this.presentationDesignerPanel.refreshProperties();
    }

    private void initManagers() {
        this.formatManagers = new ArrayList<FormatActionManager>();
        this.formatManagers.add(new FontManager());
        this.formatManagers.add(new AlignManager());
        this.formatManagers.add(new ColorManager(this.presentationDesignerPanel));
        this.formatManagers.add(new BorderManager(this.presentationDesignerPanel));
    }
}

