/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.toolbar;

import java.util.ArrayList;
import java.util.Collection;
import oracle.bpm.designer.formdesigner.ToolbarListener;
import oracle.bpm.designer.formdesigner.toolbar.ChangeFontAction;
import oracle.bpm.designer.formdesigner.toolbar.FontTypeRenderer;
import oracle.bpm.designer.formdesigner.toolbar.FormatActionManager;
import oracle.bpm.designer.formdesigner.toolbar.FormatToolbarManager;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.FontProvider;
import oracle.bpm.ui.FontStyle;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.ToolBarItem;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.utils.FontUtils;

class FontManager
implements FormatActionManager {
    private ToolBarItem boldToogle;
    private ComboBox fontCombo;
    private ComboBox fontSizeCombo;
    private ToolBarItem italicToogle;
    private boolean refreshing = false;
    private ToolbarListener.ToolbarInteractions toolbarInteraction;

    FontManager() {
    }

    @Override
    public void refresh(FormatToolbarManager toolbarManager, ToolbarListener.ToolbarInteractions toolbarInteractions) {
        this.toolbarInteraction = toolbarInteractions;
        this.refreshing = true;
        String face = toolbarInteractions.getFontFace();
        if (face != null) {
            this.fontCombo.setSelectedItem((Object)face);
        }
        this.fontSizeCombo.setSelectedItem((Object)(toolbarInteractions.getFontSize() + ""));
        FontStyle fontModifiers = toolbarInteractions.getFontModifiers();
        boolean fontIsBold = fontModifiers == FontStyle.BOLD || fontModifiers == FontStyle.BOLD_ITALIC;
        boolean fontIsItalic = fontModifiers == FontStyle.ITALIC || fontModifiers == FontStyle.BOLD_ITALIC;
        this.boldToogle.setSelected(fontIsBold);
        this.italicToogle.setSelected(fontIsItalic);
        this.refreshing = false;
    }

    @Override
    public Collection<? extends BaseAction> createActions(final FormatToolbarManager toolbarManager, ToolBar formatToolbar) {
        ArrayList<ChangeFontAction> actions = new ArrayList<ChangeFontAction>();
        this.fontCombo = UiFactory.createComboBox((UiContainer)formatToolbar, (Object[])FontUtils.getAvailableFontFamilyNames());
        this.fontCombo.setFontProvider((FontProvider)new FontTypeRenderer());
        this.fontCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (!FontManager.this.refreshing && FontManager.this.toolbarInteraction != null && e.isStateSelected()) {
                    String newFontFace = (String)FontManager.this.fontCombo.getSelectedItem();
                    FontManager.this.toolbarInteraction.setFontFace(newFontFace);
                    toolbarManager.refreshProperties();
                }
            }
        });
        this.fontCombo.setToolTipText(UIMsg.FONTS.getString());
        this.fontSizeCombo = UiFactory.createComboBox((UiContainer)formatToolbar, (Object[])FontUtils.getDefaultFontSizes());
        this.fontSizeCombo.setPrototypeDisplayValue("xxxx");
        this.fontSizeCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (!FontManager.this.refreshing && FontManager.this.toolbarInteraction != null && e.isStateSelected()) {
                    String fontSizeString = (String)FontManager.this.fontSizeCombo.getSelectedItem();
                    int fontSize = Integer.parseInt(fontSizeString);
                    FontManager.this.toolbarInteraction.setFontSize(fontSize);
                    toolbarManager.refreshProperties();
                }
            }
        });
        this.fontSizeCombo.setToolTipText(UIMsg.FONT_SIZE.getString());
        this.fontCombo.setMaximumSize(this.fontCombo.getMinimumSize());
        this.fontSizeCombo.setMaximumSize(this.fontSizeCombo.getMinimumSize());
        formatToolbar.add((UiComponent)this.fontCombo);
        formatToolbar.add((UiComponent)this.fontSizeCombo);
        formatToolbar.addSeparator();
        ChangeFontAction action = new ChangeFontAction(toolbarManager, DesignerMsg.BOLD, FontStyle.BOLD);
        actions.add(action);
        this.boldToogle = formatToolbar.addToggleButton((BaseAction)action);
        action = new ChangeFontAction(toolbarManager, DesignerMsg.ITALIC, FontStyle.ITALIC);
        actions.add(action);
        this.italicToogle = formatToolbar.addToggleButton((BaseAction)action);
        return actions;
    }

    @Override
    public void setAvaliable(boolean isReadWrite, int avaliableActions) {
        if (!this.fontCombo.isDisposed()) {
            this.fontCombo.setEnabled(isReadWrite && (avaliableActions & 0x40) != 0);
        }
        if (!this.fontSizeCombo.isDisposed()) {
            this.fontSizeCombo.setEnabled(isReadWrite && (avaliableActions & 0x80) != 0);
        }
    }
}

